/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.KVStoreFactory;
import oracle.kv.ParamConstant;
import oracle.kv.impl.security.util.KVStoreLogin;
import oracle.kv.table.FieldDef;
import oracle.kv.table.Table;
import oracle.kv.table.TableAPI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;

abstract class TableSerDeBase
implements SerDe {
    private static final String thisClassName = TableSerDeBase.class.getName();
    private static final Log LOG = LogFactory.getLog(thisClassName);
    private KVStore kvStore = null;
    private TableAPI kvTableApi = null;
    private Table kvTable = null;
    private List<String> kvFieldNames = null;
    private List<FieldDef> kvFieldDefs = null;
    private List<FieldDef.Type> kvFieldTypes = null;
    private String hiveTableName = null;
    private LazySimpleSerDe.SerDeParameters serdeParams;
    private ObjectInspector objInspector;
    protected List<Object> hiveRow;
    protected MapWritable kvMapWritable;
    private String kvStoreName = null;
    private String[] kvHelperHosts = null;
    private String[] kvHadoopHosts = null;
    private String kvTableName = null;
    private String kvStoreSecurityFile = null;
    private static String staticKvStoreName = null;
    private static String[] staticKvHelperHosts = null;
    private static String[] staticKvHadoopHosts = null;
    private static String staticKvTableName = null;
    private static String staticKvStoreSecurityFile = null;

    TableSerDeBase() {
    }

    protected abstract void validateParams(Properties var1) throws SerDeException;

    protected abstract ObjectInspector createObjectInspector() throws SerDeException;

    public void initialize(Configuration job, Properties tbl) throws SerDeException {
        this.initKvStoreParams(tbl);
        this.serdeParams = this.initSerdeParams(job, tbl);
        this.displayInitParams(this.serdeParams);
        this.validateParams(tbl);
        this.objInspector = this.createObjectInspector();
        this.hiveRow = new ArrayList<Object>();
        this.kvMapWritable = new MapWritable();
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public abstract Object deserialize(Writable var1) throws SerDeException;

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return MapWritable.class;
    }

    public abstract Writable serialize(Object var1, ObjectInspector var2) throws SerDeException;

    public String toString() {
        return "[kvStoreName=" + this.getKvStoreName() + ":" + "kvHelperHosts=" + Arrays.asList(this.getKvHelperHosts()) + ":" + "kvHadoopHosts=" + Arrays.asList(this.getKvHadoopHosts()) + ":" + "kvTableName=" + this.getKvTableName() + ":" + "kvFieldNames=" + this.getKvFieldNames() + ":" + "kvFieldTypes=" + this.getKvFieldTypes() + ":" + "hiveTableName=" + this.getHiveTableName() + ":" + "hiveSeparators=" + this.getSeparatorsStr(this.serdeParams) + ":" + "hiveColumnNames=" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldNames() + ":" + "hiveColumnTypes=" + ((StructTypeInfo)this.serdeParams.getRowTypeInfo()).getAllStructFieldTypeInfos() + "]";
    }

    String getKvStoreName() {
        return this.kvStoreName;
    }

    String[] getKvHelperHosts() {
        return this.kvHelperHosts;
    }

    String[] getKvHadoopHosts() {
        return this.kvHadoopHosts;
    }

    String getKvTableName() {
        return this.kvTableName;
    }

    TableAPI getKvTableApi() {
        return this.kvTableApi;
    }

    Table getKvTable() {
        return this.kvTable;
    }

    List<String> getKvFieldNames() {
        return this.kvFieldNames;
    }

    List<FieldDef> getKvFieldDefs() {
        return this.kvFieldDefs;
    }

    List<FieldDef.Type> getKvFieldTypes() {
        return this.kvFieldTypes;
    }

    LazySimpleSerDe.SerDeParameters getSerdeParams() {
        return this.serdeParams;
    }

    String getHiveTableName() {
        return this.hiveTableName;
    }

    static byte getByte(String altValue, byte defaultVal) {
        if (altValue != null && altValue.length() > 0) {
            try {
                return Byte.valueOf(altValue);
            }
            catch (NumberFormatException e) {
                return (byte)altValue.charAt(0);
            }
        }
        return defaultVal;
    }

    String getSeparatorsStr(LazySimpleSerDe.SerDeParameters params) {
        StringBuilder buf = new StringBuilder("[");
        if (params != null) {
            byte[] seps = params.getSeparators();
            for (int i = 0; i < seps.length; ++i) {
                buf.append(seps[i]);
                if (i >= seps.length - 1) continue;
                buf.append(",");
            }
        }
        buf.append("]");
        return buf.toString();
    }

    private void initKvStoreParams(Properties tbl) throws SerDeException {
        String kvStoreSecurityStr;
        int i;
        String helperHosts;
        this.kvStoreName = tbl.getProperty(ParamConstant.KVSTORE_NAME.getName());
        if (this.kvStoreName == null) {
            this.kvStoreName = staticKvStoreName;
            if (this.kvStoreName == null) {
                String msg = "No KV Store name specified. Specify the store name via the '" + ParamConstant.KVSTORE_NAME.getName() + "' property in the TBLPROPERTIES clause when creating " + "the Hive table";
                LOG.error(msg);
                throw new SerDeException((Throwable)new IllegalArgumentException(msg));
            }
        } else {
            staticKvStoreName = this.kvStoreName;
        }
        if ((helperHosts = tbl.getProperty(ParamConstant.KVSTORE_NODES.getName())) != null) {
            this.kvHelperHosts = helperHosts.trim().split(",");
            staticKvHelperHosts = helperHosts.trim().split(",");
        } else if (staticKvHelperHosts != null) {
            this.kvHelperHosts = new String[staticKvHelperHosts.length];
            for (int i2 = 0; i2 < staticKvHelperHosts.length; ++i2) {
                this.kvHelperHosts[i2] = staticKvHelperHosts[i2];
            }
        } else {
            String msg = "No KV Store helper hosts specified. Specify the helper hosts via the '" + ParamConstant.KVSTORE_NODES.getName() + "' property in the TBLPROPERTIES clause when creating " + "the Hive table";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        String hadoopHosts = tbl.getProperty(ParamConstant.KVHADOOP_NODES.getName());
        if (hadoopHosts != null) {
            this.kvHadoopHosts = hadoopHosts.trim().split(",");
            staticKvHadoopHosts = hadoopHosts.trim().split(",");
        } else if (staticKvHadoopHosts != null) {
            this.kvHadoopHosts = new String[staticKvHadoopHosts.length];
            for (i = 0; i < staticKvHadoopHosts.length; ++i) {
                this.kvHadoopHosts[i] = staticKvHadoopHosts[i];
            }
        } else {
            this.kvHadoopHosts = new String[this.kvHelperHosts.length];
            staticKvHadoopHosts = new String[staticKvHelperHosts.length];
            for (i = 0; i < this.kvHelperHosts.length; ++i) {
                String[] hostPort = this.kvHelperHosts[i].trim().split(":");
                String[] staticHostPort = staticKvHelperHosts[i].trim().split(":");
                this.kvHadoopHosts[i] = hostPort[0];
                TableSerDeBase.staticKvHadoopHosts[i] = staticHostPort[0];
            }
        }
        this.kvTableName = tbl.getProperty(ParamConstant.TABLE_NAME.getName());
        if (this.kvTableName == null) {
            this.kvTableName = staticKvTableName;
            if (this.kvTableName == null) {
                String msg = "No KV Table name specified. Specify the table name via the '" + ParamConstant.TABLE_NAME.getName() + "' property in the TBLPROPERTIES clause when creating " + "the Hive table";
                LOG.error(msg);
                throw new SerDeException((Throwable)new IllegalArgumentException(msg));
            }
        } else {
            staticKvTableName = this.kvTableName;
        }
        if ((kvStoreSecurityStr = tbl.getProperty(ParamConstant.KVSTORE_SECURITY.getName())) != null) {
            this.kvStoreSecurityFile = kvStoreSecurityStr;
            staticKvStoreSecurityFile = kvStoreSecurityStr;
        } else if (staticKvStoreSecurityFile != null) {
            this.kvStoreSecurityFile = staticKvStoreSecurityFile;
        }
        KVStoreConfig kvStoreConfig = new KVStoreConfig(this.kvStoreName, this.kvHelperHosts);
        kvStoreConfig.setSecurityProperties(KVStoreLogin.createSecurityProperties(this.kvStoreSecurityFile));
        this.kvStore = KVStoreFactory.getStore(kvStoreConfig);
        this.kvTableApi = this.kvStore.getTableAPI();
        this.kvTable = this.kvTableApi.getTable(this.kvTableName);
        if (this.kvTable == null) {
            String msg = "Store does not contain table [name=" + this.kvTableName + "]";
            LOG.error(msg);
            throw new SerDeException((Throwable)new IllegalArgumentException(msg));
        }
        this.kvFieldNames = this.kvTable.getFields();
        this.kvFieldDefs = new ArrayList<FieldDef>();
        this.kvFieldTypes = new ArrayList<FieldDef.Type>();
        for (String fieldName : this.kvFieldNames) {
            FieldDef fieldDef = this.kvTable.getField(fieldName);
            this.kvFieldDefs.add(fieldDef);
            this.kvFieldTypes.add(fieldDef.getType());
        }
    }

    private LazySimpleSerDe.SerDeParameters initSerdeParams(Configuration job, Properties tbl) throws SerDeException {
        this.hiveTableName = tbl.getProperty("name");
        int indx = this.hiveTableName.indexOf(".");
        if (indx >= 0) {
            this.hiveTableName = this.hiveTableName.substring(indx + 1);
        }
        return LazySimpleSerDe.initSerdeParams((Configuration)job, (Properties)tbl, (String)thisClassName);
    }

    private void displayInitParams(LazySimpleSerDe.SerDeParameters params) {
        LOG.debug("kvStoreName = " + this.getKvStoreName());
        LOG.debug("kvHelperHosts = " + Arrays.asList(this.getKvHelperHosts()));
        LOG.debug("kvHadoopHosts = " + Arrays.asList(this.getKvHadoopHosts()));
        LOG.debug("kvTableName = " + this.getKvTableName());
        LOG.debug("kvFieldNames = " + this.getKvFieldNames());
        LOG.debug("kvFieldTypes = " + this.getKvFieldTypes());
        LOG.debug("hiveTableName = " + this.getHiveTableName());
        LOG.debug("hiveSeparators = " + this.getSeparatorsStr(params));
        LOG.debug("hiveColumnNames = " + params.getColumnNames());
        LOG.debug("hiveColumnTypes = " + params.getColumnTypes());
        LOG.debug("nullSequence = " + params.getNullSequence());
        LOG.debug("lastColumnTakesRest = " + params.isLastColumnTakesRest());
        LOG.debug("isEscaped = " + params.isEscaped());
        LOG.debug("escapeChar = " + params.getEscapeChar());
    }
}

