/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.io.IOException;
import oracle.kv.hadoop.hive.table.V1V2TableUtil;
import oracle.kv.hadoop.table.TableRecordReader;
import oracle.kv.table.Row;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.RecordReader;

public class TableHiveRecordReader
implements RecordReader<Text, Text> {
    private static final Log LOG = LogFactory.getLog("oracle.kv.hadoop.hive.table.TableHiveRecordReader");
    private TableRecordReader v2RecordReader;

    public TableHiveRecordReader(TableRecordReader v2RecordReader) {
        this.v2RecordReader = v2RecordReader;
    }

    public void close() throws IOException {
        if (this.v2RecordReader != null) {
            this.v2RecordReader.close();
            this.v2RecordReader = null;
        }
        V1V2TableUtil.resetInputJobInfoForNewQuery();
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public float getProgress() {
        return this.v2RecordReader.getProgress();
    }

    public boolean next(Text key, Text value) {
        if (key == null || value == null) {
            return false;
        }
        boolean ret = false;
        try {
            key.clear();
            value.clear();
            ret = this.v2RecordReader.nextKeyValue();
            if (ret) {
                Row curRow = this.v2RecordReader.getCurrentValue();
                assert (curRow != null);
                key.set(curRow.createPrimaryKey().toString());
                value.set(curRow.toString());
            }
        }
        catch (Exception e) {
            LOG.error("TableHiveRecordReader " + this + " caught: " + e, e);
        }
        return ret;
    }

    public Text createKey() {
        return new Text();
    }

    public Text createValue() {
        return new Text();
    }
}

