/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import oracle.bali.xml.gui.swing.util.FillContainerLayoutManager;
import oracle.bali.xml.gui.swing.util.NullFocusPolicy;
import oracle.bali.xml.gui.swing.util.NullScrollable;

public class ScrollableTwoLayerPane
extends JLayeredPane
implements Scrollable {
    private JComponent _contentPane;
    private JComponent _glassPane;
    private static final Integer CONTENT_LAYER = DEFAULT_LAYER;
    private static final Integer GLASS_LAYER = MODAL_LAYER;

    public ScrollableTwoLayerPane() {
        this.setGlassPane(this.createGlassPane());
        this.setContentPane(this.createContentPane());
        this.setLayout(new TwoPaneLayoutManager());
    }

    public JComponent getContentPane() {
        return this._contentPane;
    }

    public JComponent getGlassPane() {
        return this._glassPane;
    }

    public void setContentPane(JComponent contentPane) {
        if (contentPane == null) {
            throw new IllegalComponentStateException("Can set content pane to null on " + this.getClass().getName());
        }
        if (this._contentPane != null) {
            this.remove(this._contentPane);
        }
        this._contentPane = contentPane;
        this._makeContainerUnfocusable(this._contentPane);
        this.add((Component)this._contentPane, CONTENT_LAYER);
    }

    public void setGlassPane(JComponent glassPane) {
        if (glassPane == null) {
            throw new IllegalComponentStateException("Can set glass pane to null on " + this.getClass().getName());
        }
        if (this._glassPane != null) {
            this.remove(this._glassPane);
        }
        this._glassPane = glassPane;
        this.add((Component)this._glassPane, GLASS_LAYER);
    }

    public void dispose() {
        this.removeAll();
        this._glassPane = null;
        this._contentPane = null;
    }

    protected JComponent createContentPane() {
        JPanel c = new JPanel();
        c.setLayout(new BorderLayout(){

            @Override
            public void addLayoutComponent(Component comp, Object constraints) {
                if (constraints == null) {
                    constraints = "Center";
                }
                super.addLayoutComponent(comp, constraints);
            }
        });
        return c;
    }

    protected JComponent createGlassPane() {
        JPanel p = new JPanel();
        p.setOpaque(false);
        return p;
    }

    private void _makeContainerUnfocusable(Container c) {
        c.setFocusable(false);
        c.setFocusCycleRoot(true);
        c.setFocusTraversalPolicy(NullFocusPolicy.ONLY);
    }

    @Override
    public boolean isValidateRoot() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this._getDelegatee().getPreferredScrollableViewportSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this._getDelegatee().getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this._getDelegatee().getScrollableBlockIncrement(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this._getDelegatee().getScrollableTracksViewportWidth();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this._getDelegatee().getScrollableTracksViewportHeight();
    }

    private JViewport _getContainingViewport() {
        Container comp = this;
        while ((comp = comp.getParent()) != null && !(comp instanceof JViewport)) {
        }
        return (JViewport)comp;
    }

    private Scrollable _getDelegatee() throws IllegalStateException {
        if (this.getContentPane().getComponentCount() == 0 || !(this.getContentPane().getComponent(0) instanceof Scrollable)) {
            return NullScrollable.ONLY;
        }
        return (Scrollable)((Object)this.getContentPane().getComponent(0));
    }

    private class TwoPaneLayoutManager
    extends FillContainerLayoutManager {
        private TwoPaneLayoutManager() {
        }

        @Override
        protected Component getPrimaryComponent(Container parent) {
            return ScrollableTwoLayerPane.this._contentPane;
        }

        @Override
        protected void layoutNonPrimaryComponents(Container parent, int x, int y, int width, int height) {
            ScrollableTwoLayerPane.this._glassPane.setBounds(x, y, width, height);
        }
    }
}

