/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.grammar.PrefixName;
import oracle.bali.xml.gui.GuiXmlContext;
import oracle.bali.xml.gui.base.inspector.editors.AbstractSimplePropretyEditor;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.metadata.ContextualPropertyEditor;
import oracle.bali.xml.model.metadata.PropertyEditorContext;
import oracle.bali.xml.util.XmlNameUtils;
import org.w3c.dom.Node;

public final class QNameEditor
extends AbstractSimplePropretyEditor<PrefixName>
implements ContextualPropertyEditor {
    private JComponent _editor;
    private JTextField _prefixField;
    private JTextField _nameField;
    private XmlKey _key;
    private XmlContext _context;
    private Node _node;
    private Node _ownerNode;

    public QNameEditor() {
        super(PrefixName.class);
    }

    public void clearContext() {
        this._setContext(null, null, null, null);
    }

    public void setContext(PropertyEditorContext context) {
        this._setContext(context.getXmlContext(), context.getKey(), context.getNode(), context.getOwnerNode());
    }

    protected String getJavaInitializationStringImpl(PrefixName value) {
        return "oracle.bali.xml.grammar.PrefixName.getPrefixName(" + value.getPrefix() + "," + value.getName() + ")";
    }

    public Component getCustomEditor() {
        if (this._editor == null && this._context != null) {
            Container panel = UIUtils.createLabelFieldContainer();
            JTextField prefixField = new JTextField();
            JTextField nameField = new JTextField();
            String prefixString = this._context.getTranslatedString("QNAME_EDITOR.NAMESPACE_PROMPT");
            JLabel prefixLabel = new JLabel(StringUtils.stripMnemonic((String)prefixString));
            prefixLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)prefixString));
            prefixLabel.setLabelFor(prefixField);
            String nameString = this._context.getTranslatedString("QNAME_EDITOR.NAME_PROMPT");
            JLabel nameLabel = new JLabel(StringUtils.stripMnemonic((String)nameString));
            nameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)nameString));
            nameLabel.setLabelFor(nameField);
            panel.add(prefixLabel);
            panel.add(prefixField);
            panel.add(nameLabel);
            panel.add(nameField);
            this._editor = new CustomEditorDecorator(panel);
            this._prefixField = prefixField;
            this._nameField = nameField;
            this._updateTextFields();
            this._updateHelp();
        }
        this._updateTextFields();
        return this._editor;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getHelpTopic(XmlContext context, XmlKey key, Node node, Node ownerNode) {
        if (context == null) {
            return null;
        }
        context.getModel().acquireReadLock();
        try {
            String string = ((GuiXmlContext)context).getActiveGui().getHelpTopic(node, key);
            return string;
        }
        finally {
            context.getModel().releaseReadLock();
        }
    }

    protected String getStringForValue(PrefixName value) throws IllegalArgumentException {
        return value.getPrefixName();
    }

    protected PrefixName getValueForString(String text) throws IllegalArgumentException {
        if (text == null || "".equals(text)) {
            return null;
        }
        String name = null;
        String prefix = null;
        int sep = text.indexOf(58);
        if (sep == text.length() - 1) {
            throw new IllegalArgumentException("qualified name can not end with colon");
        }
        if (sep < 0) {
            name = text;
        } else {
            prefix = text.substring(0, sep);
            name = text.substring(sep + 1);
        }
        if (prefix != null) {
            XmlNameUtils.validateName((CharSequence)prefix);
        }
        XmlNameUtils.validateName((CharSequence)name);
        PrefixName prefixName = PrefixName.getPrefixName((String)text);
        return prefixName;
    }

    private void _updateTextFields() {
        String name;
        if (this._nameField == null) {
            return;
        }
        PrefixName value = (PrefixName)this.getValue();
        String prefix = value == null ? null : value.getPrefix();
        String string = name = value == null ? null : value.getName();
        if (!this._prefixField.hasFocus()) {
            this._prefixField.setText(prefix);
        }
        if (!this._nameField.hasFocus()) {
            this._nameField.setText(name);
        }
    }

    private void _updateValue() {
        String prefix = this._prefixField.getText();
        String name = this._nameField.getText();
        if (name != null && !"".equals(name)) {
            if ("".equals(prefix)) {
                prefix = null;
            }
            try {
                if (prefix != null) {
                    XmlNameUtils.validateName((CharSequence)prefix);
                }
                XmlNameUtils.validateName((CharSequence)name);
                PrefixName prefixName = PrefixName.getPrefixName((String)prefix, (String)name);
                this.setValue(prefixName);
            }
            catch (IllegalArgumentException e) {
                JOptionPane.showMessageDialog(this.getCustomEditor(), this._context.getTranslatedString("QNAME_EDITOR.ERROR_WINDOW_MESSAGE"), this._context.getTranslatedString("QNAME_EDITOR.ERROR_WINDOW_TITLE"), 0);
            }
        }
    }

    private void _updateHelp() {
        if (this._editor != null) {
            String topic = this._context != null ? this.getHelpTopic(this._context, this._key, this._node, this._ownerNode) : null;
            HelpUtils.setHelpID((JComponent)this._editor, topic);
        }
    }

    private void _setContext(XmlContext context, XmlKey key, Node node, Node ownerNode) {
        this._key = key;
        this._context = context;
        this._node = node;
        this._ownerNode = ownerNode;
        this._updateHelp();
    }

    private final class CustomEditorDecorator
    extends JComponent
    implements VetoableChangeListener {
        public CustomEditorDecorator(Component editor) {
            this.setLayout(new BorderLayout());
            this.add(editor, "Center");
        }

        @Override
        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
            QNameEditor.this._updateValue();
        }
    }
}

