/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.inspector.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.model.XmlContext;

public class ListEditorPanel
extends JPanel
implements VetoableChangeListener {
    private XmlContext _xmlContext;
    private BorderLayout _myBorderLayout = new BorderLayout();
    private JPanel _centerAndBottomPanel = new JPanel();
    private BorderLayout _centerAndBottomPanelBorderLayout = new BorderLayout();
    private JPanel _centerTablePanel = new JPanel();
    private BorderLayout _centerTablePanelBorderLayout = new BorderLayout();
    private MultiLineLabel _instructionText;
    private JLabel _topLabel = new JLabel();
    private JScrollPane _mainScrollPane = new JScrollPane();
    private JTable _mainTable = new JTable();
    private DefaultTableModel _tableModel = new DefaultTableModel();
    private JPanel _rightPanel = new JPanel();
    private FlowLayout _rightPanelFlowLayout = new FlowLayout(3, 0, 0);
    private JPanel _bottomPanel = new JPanel();
    private FlowLayout _bottomPanelFlowLayout = new FlowLayout(4, 0, 0);
    private ButtonBar _bottomButtonBar = new ButtonBar();
    private ButtonBar _rightButtonBar = new ButtonBar(1);
    private JButton _newButton = new JButton();
    private JButton _deleteButton = new JButton();
    private JButton _moveToTopButton = new JButton();
    private JButton _moveUpButton = new JButton();
    private JButton _moveDownButton = new JButton();
    private JButton _moveToBottomButton = new JButton();

    public ListEditorPanel(XmlContext xmlContext) {
        this._xmlContext = xmlContext;
        this.jbInit();
        UIUtils.initializeJTable(this._mainTable);
    }

    public void setListItemEditor(TableCellEditor tableCellEditor) {
        TableColumn tc = this._mainTable.getColumnModel().getColumn(0);
        tc.setCellEditor(tableCellEditor);
    }

    public void setValue(Object[] valueList) {
        int numItems = valueList.length;
        this._tableModel.setColumnCount(1);
        this._tableModel.setRowCount(numItems);
        for (int x = 0; x < numItems; ++x) {
            this._tableModel.setValueAt(valueList[x], x, 0);
        }
        this._tableRequestFocus();
    }

    public Object[] getValue() {
        int numItems = this._tableModel.getRowCount();
        Object[] valueList = new Object[numItems];
        for (int x = 0; x < numItems; ++x) {
            valueList[x] = this._tableModel.getValueAt(x, 0);
        }
        return valueList;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._tableRequestFocus();
    }

    public void setInstructionText(String text) {
        if (text != null && text.length() > 0) {
            this._instructionText.setText(text + "\n\n");
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("closed".equals(evt.getPropertyName())) {
            this._stopTableCellEditing();
            this.fireVetoableChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            UIUtils.diposeJTable(this._mainTable);
        }
    }

    private void jbInit() {
        this.setLayout(this._myBorderLayout);
        this._centerTablePanel.setLayout(this._centerTablePanelBorderLayout);
        this._rightPanel.setLayout(this._rightPanelFlowLayout);
        String resourceStringListItems = this._xmlContext.getTranslatedString("LIST_EDITOR_LABEL");
        String translatedStringListItems = StringUtils.stripMnemonic((String)resourceStringListItems);
        int mnemonicListItems = StringUtils.getMnemonicKeyCode((String)resourceStringListItems);
        String resourceStringNew = this._xmlContext.getTranslatedString("LIST_EDITOR_NEW_BUTTON");
        String translatedStringNew = StringUtils.stripMnemonic((String)resourceStringNew);
        int mnemonicNew = StringUtils.getMnemonicKeyCode((String)resourceStringNew);
        String resourceStringDelete = this._xmlContext.getTranslatedString("LIST_EDITOR_DELETE_BUTTON");
        String translatedStringDelete = StringUtils.stripMnemonic((String)resourceStringDelete);
        int mnemonicDelete = StringUtils.getMnemonicKeyCode((String)resourceStringDelete);
        String resourceStringTop = this._xmlContext.getTranslatedString("LIST_EDITOR_TOP_BUTTON");
        String translatedStringTop = StringUtils.stripMnemonic((String)resourceStringTop);
        int mnemonicTop = StringUtils.getMnemonicKeyCode((String)resourceStringTop);
        String resourceStringBottom = this._xmlContext.getTranslatedString("LIST_EDITOR_BOTTOM_BUTTON");
        String translatedStringBottom = StringUtils.stripMnemonic((String)resourceStringBottom);
        int mnemonicBottom = StringUtils.getMnemonicKeyCode((String)resourceStringBottom);
        String resourceStringUp = this._xmlContext.getTranslatedString("LIST_EDITOR_UP_BUTTON");
        String translatedStringUp = StringUtils.stripMnemonic((String)resourceStringUp);
        int mnemonicUp = StringUtils.getMnemonicKeyCode((String)resourceStringUp);
        String resourceStringDown = this._xmlContext.getTranslatedString("LIST_EDITOR_DOWN_BUTTON");
        String translatedStringDown = StringUtils.stripMnemonic((String)resourceStringDown);
        int mnemonicDown = StringUtils.getMnemonicKeyCode((String)resourceStringDown);
        this._instructionText = new MultiLineLabel();
        this._instructionText.setTextWrapper(WordWrapper.getTextWrapper());
        this._instructionText.setText("");
        this._topLabel.setText(translatedStringListItems);
        this._topLabel.setDisplayedMnemonic(mnemonicListItems);
        this._topLabel.setLabelFor(this._mainTable);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        topPanel.add((Component)this._instructionText, "North");
        topPanel.add((Component)this._topLabel, "South");
        this._newButton.setText(translatedStringNew);
        this._newButton.setMnemonic(mnemonicNew);
        this._newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditorPanel.this._newButton_actionPerformed(e);
            }
        });
        this._deleteButton.setText(translatedStringDelete);
        this._deleteButton.setMnemonic(mnemonicDelete);
        this._deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditorPanel.this._deleteButton_actionPerformed(e);
            }
        });
        this._moveToTopButton.setText(translatedStringTop);
        this._moveToTopButton.setMnemonic(mnemonicTop);
        this._moveToTopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditorPanel.this._moveToTopButton_actionPerformed(e);
            }
        });
        this._moveUpButton.setText(translatedStringUp);
        this._moveUpButton.setMnemonic(mnemonicUp);
        this._moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditorPanel.this._moveUpButton_actionPerformed(e);
            }
        });
        this._moveDownButton.setText(translatedStringDown);
        this._moveDownButton.setMnemonic(mnemonicDown);
        this._moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditorPanel.this._moveDownButton_actionPerformed(e);
            }
        });
        this._moveToBottomButton.setText(translatedStringBottom);
        this._moveToBottomButton.setMnemonic(mnemonicBottom);
        this._moveToBottomButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListEditorPanel.this._moveToBottomButton_actionPerformed(e);
            }
        });
        this._mainScrollPane.getViewport().add(this._mainTable);
        this._mainScrollPane.setColumnHeaderView(null);
        this._centerAndBottomPanel.setLayout(this._centerAndBottomPanelBorderLayout);
        this.add((Component)this._centerAndBottomPanel, "Center");
        this._centerAndBottomPanel.add((Component)this._centerTablePanel, "Center");
        this._centerTablePanel.add((Component)this._mainScrollPane, "Center");
        this._mainTable.setTableHeader(null);
        this._mainTable.setModel(this._tableModel);
        ListSelectionModel rowSM = this._mainTable.getSelectionModel();
        this._centerAndBottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this._topLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this._centerTablePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this._mainScrollPane.setPreferredSize(new Dimension(155, 113));
        this._moveToBottomButton.setEnabled(false);
        this._moveDownButton.setEnabled(false);
        this._moveUpButton.setEnabled(false);
        this._moveToTopButton.setEnabled(false);
        this._deleteButton.setEnabled(false);
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListEditorPanel.this._mainTable_selectionChanged(e);
            }
        });
        this.add((Component)this._rightPanel, "East");
        this.add((Component)topPanel, "North");
        this._bottomPanel.setLayout(this._bottomPanelFlowLayout);
        this._rightPanel.add((Component)this._rightButtonBar);
        this._rightButtonBar.add((Component)this._moveToTopButton);
        this._rightButtonBar.add((Component)this._moveUpButton);
        this._rightButtonBar.add((Component)this._moveDownButton);
        this._rightButtonBar.add((Component)this._moveToBottomButton);
        this._centerAndBottomPanel.add((Component)this._bottomPanel, "South");
        this._bottomPanel.add((Component)this._bottomButtonBar);
        this._bottomButtonBar.add((Component)this._newButton, null);
        this._bottomButtonBar.add((Component)this._deleteButton, null);
    }

    private void _mainTable_selectionChanged(ListSelectionEvent e) {
        boolean tableHasMultipleRowsSelected;
        if (e.getValueIsAdjusting()) {
            return;
        }
        int[] selectedRows = this._mainTable.getSelectedRows();
        int numSelectedRows = selectedRows.length;
        boolean tableIsEmpty = this._mainTable.getRowCount() < 1;
        boolean tableHasNoSelection = numSelectedRows < 1;
        boolean bl = tableHasMultipleRowsSelected = numSelectedRows > 1;
        if (tableIsEmpty || tableHasNoSelection) {
            this._deleteButton.setEnabled(false);
            this._setMoveButtonsEnabled(false);
        } else if (tableHasMultipleRowsSelected) {
            this._deleteButton.setEnabled(true);
            this._setMoveButtonsEnabled(false);
        } else {
            boolean tableBottomRowSelected;
            assert (this._mainTable.getSelectedRowCount() == 1);
            this._deleteButton.setEnabled(true);
            boolean tableHasOneRow = this._mainTable.getRowCount() == 1;
            boolean tableTopRowSelected = this._mainTable.getSelectedRow() == 0;
            boolean bl2 = tableBottomRowSelected = this._mainTable.getSelectedRow() + 1 == this._mainTable.getRowCount();
            if (tableHasOneRow) {
                this._setMoveButtonsEnabled(false);
            } else if (!tableTopRowSelected && !tableBottomRowSelected) {
                this._deleteButton.setEnabled(true);
                this._setMoveButtonsEnabled(true);
            } else if (tableTopRowSelected) {
                this._deleteButton.setEnabled(true);
                this._moveToTopButton.setEnabled(false);
                this._moveUpButton.setEnabled(false);
                this._moveToBottomButton.setEnabled(true);
                this._moveDownButton.setEnabled(true);
            } else if (tableBottomRowSelected) {
                this._deleteButton.setEnabled(true);
                this._moveToTopButton.setEnabled(true);
                this._moveUpButton.setEnabled(true);
                this._moveToBottomButton.setEnabled(false);
                this._moveDownButton.setEnabled(false);
            }
        }
    }

    private void _setMoveButtonsEnabled(boolean enabled) {
        this._moveToTopButton.setEnabled(enabled);
        this._moveToBottomButton.setEnabled(enabled);
        this._moveUpButton.setEnabled(enabled);
        this._moveDownButton.setEnabled(enabled);
    }

    private void _moveToTopButton_actionPerformed(ActionEvent e) {
        this._stopTableCellEditing();
        int currentSelectedRow = this._mainTable.getSelectedRow();
        this._tableModel.moveRow(currentSelectedRow, currentSelectedRow, 0);
        this._mainTable.requestFocus();
        this._mainTable.changeSelection(0, 0, false, false);
    }

    private void _moveUpButton_actionPerformed(ActionEvent e) {
        this._stopTableCellEditing();
        int currentSelectedRow = this._mainTable.getSelectedRow();
        int up1Row = currentSelectedRow - 1;
        this._tableModel.moveRow(currentSelectedRow, currentSelectedRow, up1Row);
        this._mainTable.requestFocus();
        this._mainTable.changeSelection(up1Row, 0, false, false);
    }

    private void _moveDownButton_actionPerformed(ActionEvent e) {
        this._stopTableCellEditing();
        int currentSelectedRow = this._mainTable.getSelectedRow();
        int down1Row = currentSelectedRow + 1;
        this._tableModel.moveRow(currentSelectedRow, currentSelectedRow, down1Row);
        this._mainTable.requestFocus();
        this._mainTable.changeSelection(down1Row, 0, false, false);
    }

    private void _moveToBottomButton_actionPerformed(ActionEvent e) {
        this._stopTableCellEditing();
        int currentSelectedRow = this._mainTable.getSelectedRow();
        int lastRow = this._tableModel.getRowCount() - 1;
        this._tableModel.moveRow(currentSelectedRow, currentSelectedRow, lastRow);
        this._mainTable.requestFocus();
        this._mainTable.changeSelection(lastRow, 0, false, false);
    }

    private void _newButton_actionPerformed(ActionEvent e) {
        this._stopTableCellEditing();
        Object[] emptyRow = new Object[]{new String("")};
        this._tableModel.addRow(emptyRow);
        int newRowNumber = this._tableModel.getRowCount() - 1;
        this._mainTable.requestFocus();
        this._mainTable.changeSelection(newRowNumber, 0, false, false);
        this._mainTable.editCellAt(newRowNumber, 0);
        this._mainTable.getEditorComponent().requestFocus();
    }

    private void _deleteButton_actionPerformed(ActionEvent e) {
        int[] selectedRows = this._mainTable.getSelectedRows();
        if (selectedRows.length > 0 && this._tableModel.getRowCount() > 0) {
            this._stopTableCellEditing();
            int numSelectedRows = selectedRows.length;
            for (int x = numSelectedRows - 1; x >= 0; --x) {
                this._tableModel.removeRow(selectedRows[x]);
            }
            int rowAfterLastSelectedRow = selectedRows[numSelectedRows - 1] - numSelectedRows + 1;
            if (rowAfterLastSelectedRow >= this._tableModel.getRowCount() && this._tableModel.getRowCount() > 0) {
                --rowAfterLastSelectedRow;
            }
            this._mainTable.requestFocus();
            this._mainTable.changeSelection(rowAfterLastSelectedRow, 0, false, false);
        }
    }

    private void _stopTableCellEditing() {
        if (this._mainTable.isEditing()) {
            this._mainTable.getCellEditor().stopCellEditing();
        }
    }

    private void _tableRequestFocus() {
        Runnable tableRequestFocus = new Runnable(){

            @Override
            public void run() {
                ListEditorPanel.this._stopTableCellEditing();
                if (ListEditorPanel.this._tableModel.getRowCount() <= 0) {
                    Object[] emptyRow = new Object[]{new String("")};
                    ListEditorPanel.this._tableModel.addRow(emptyRow);
                }
                ListEditorPanel.this._mainTable.requestFocus();
                ListEditorPanel.this._mainTable.changeSelection(0, 0, false, false);
                ListEditorPanel.this._mainTable.editCellAt(0, 0);
                ListEditorPanel.this._mainTable.getEditorComponent().requestFocus();
            }
        };
        SwingUtilities.invokeLater(tableRequestFocus);
    }
}

