/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.explorer;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.swing.dnd.ModelDropHandler;
import oracle.bali.xml.gui.swing.explorer.SwingTreeListHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SwingTreeListDropHandler<ComponentType extends JComponent>
extends ModelDropHandler<ComponentType> {
    private SwingTreeListHelper _helper;

    public SwingTreeListDropHandler(SwingTreeListHelper<?, ComponentType> helper) {
        super((XmlGui)helper.getGui(), helper.getPointToModelFinder());
        this._helper = helper;
    }

    @Override
    protected DomPosition getClosestDropPosition(ComponentType component, Point location) {
        Node lastNode;
        int bottom;
        Rectangle lastRowBounds;
        int lastRow;
        DomPosition pos = super.getClosestDropPosition(component, location);
        if (pos == null && (lastRow = this._helper.getRowCount(component) - 1) >= 0 && (lastRowBounds = this._helper.getBoundsIfVisible(component, lastRow)) != null && location.y >= (bottom = lastRowBounds.y + lastRowBounds.height) && (lastNode = this._helper.getNodeForRow(component, lastRow)) != null) {
            pos = DomPositionFactory.after((Node)lastNode);
        }
        return pos;
    }

    @Override
    protected void findOtherClosePositions(ComponentType dropComponent, Point location, DomPosition closestPosition, List out) {
        if (closestPosition == null) {
            Document doc = this.getView().getDocument();
            if (doc != null) {
                out.add(DomPositionFactory.inside((Node)doc));
            }
        } else {
            Node node = closestPosition.getTargetNode();
            if (closestPosition.isInside()) {
                DomPosition sibling1 = this._helper.__getNearestSiblingPosition(dropComponent, node, location.y);
                if (sibling1 != null) {
                    out.add(sibling1);
                    if (sibling1.isAfter()) {
                        out.add(DomPositionFactory.before((Node)node));
                    } else {
                        out.add(DomPositionFactory.after((Node)node));
                    }
                }
            } else if (closestPosition.isBefore()) {
                DomPosition p = DomPositionFactory.createInsideOrAfterPosition((Node)node);
                out.add(p);
                if (!p.isAfter()) {
                    out.add(DomPositionFactory.after((Node)node));
                }
            } else if (closestPosition.isAfter()) {
                DomPosition p = DomPositionFactory.createInsideOrBeforePosition((Node)node);
                out.add(p);
                if (!p.isBefore()) {
                    out.add(DomPositionFactory.before((Node)node));
                }
            }
        }
    }

    protected SwingTreeListHelper getHelper() {
        return this._helper;
    }
}

