/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.xml.gui.swing.controls.Heading;

public class HeadingContainer
extends JPanel {
    public static final String PROPERTY_COLLAPSED = "collapsed";
    private static final Icon _sCollapsedIcon;
    private static final Icon _sExpandedIcon;
    private boolean _collapsableHorizontalSpace = false;
    private JPanel _contentContainer;
    private Heading _heading;
    private JLabel _icon;
    private JPanel _top;

    public HeadingContainer() {
        this((String)null);
    }

    public HeadingContainer(String heading) {
        this(heading, null);
    }

    public HeadingContainer(String heading, Component content) {
        this(heading, content, false);
    }

    public HeadingContainer(String heading, Component content, boolean collapsed) {
        this.setLayout(new BorderLayout(0, 5));
        this.setOpaque(false);
        this._heading = new Heading();
        this._heading.setSubHeading(true);
        this._icon = new JLabel();
        this._icon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (HeadingContainer.this.isCollapsable()) {
                    HeadingContainer.this.setCollapsed(!HeadingContainer.this.isCollapsed());
                }
            }
        });
        this._contentContainer = new JPanel(new BorderLayout());
        this._contentContainer.setOpaque(false);
        JPanel top = new JPanel(new BorderLayout(3, 3));
        this.setHeadingComponent(top);
        top.setOpaque(false);
        JPanel iconPanel = new JPanel(new BorderLayout());
        iconPanel.add("North", this._icon);
        iconPanel.setOpaque(false);
        top.add("West", iconPanel);
        top.add("Center", this._heading);
        this.add("North", top);
        this.add("Center", this._contentContainer);
        this.setCollapsable(true);
        this.setHeading(heading);
        this.setContent(content);
        this.setCollapsed(collapsed);
    }

    public String getHeading() {
        return this._heading.getLabel();
    }

    public JPanel getHeadingComponent() {
        return this._top;
    }

    public void setHeadingComponent(JPanel top) {
        this._top = top;
    }

    public void setHeading(String heading) {
        this._heading.setLabel(heading);
        this.revalidate();
        this.repaint();
    }

    public void setCollapsable(boolean collapsable) {
        if (collapsable != this.isCollapsable()) {
            this._icon.setVisible(collapsable);
            this._heading.setSubHeading(collapsable);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isCollapsable() {
        return this._icon == null ? true : this._icon.isVisible();
    }

    public void setCollapsableHorizontalSpace(boolean collapsableHorizontalSpace) {
        this._collapsableHorizontalSpace = collapsableHorizontalSpace;
    }

    public boolean isCollapsableHorizontalSpace() {
        return this._collapsableHorizontalSpace;
    }

    public Component getContent() {
        return this._contentContainer.getComponentCount() == 0 ? null : this._contentContainer.getComponent(0);
    }

    public void setContent(Component content) {
        this._contentContainer.removeAll();
        if (content != null) {
            this._contentContainer.add("Center", content);
        }
        this.revalidate();
        this.repaint();
    }

    public boolean isCollapsed() {
        return !this._contentContainer.isVisible();
    }

    public void setCollapsed(boolean collapsed) {
        this._icon.setIcon(collapsed ? _sCollapsedIcon : _sExpandedIcon);
        this._contentContainer.setVisible(!collapsed);
        if (this._collapsableHorizontalSpace) {
            this._heading.setHorizontal(!collapsed);
        }
        this._top.setPreferredSize(null);
        this.revalidate();
        this.repaint();
        this.firePropertyChange(PROPERTY_COLLAPSED, !collapsed, collapsed);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension headingSize = this._heading.getPreferredSize();
        Dimension contentSize = this._contentContainer.getPreferredSize();
        int height = this.isCollapsed() ? headingSize.height : headingSize.height + contentSize.height;
        Dimension d = new Dimension(Math.max(headingSize.width, contentSize.width), height + 5);
        return d;
    }

    static {
        Image i = ImageUtils.getImageResource(HeadingContainer.class, (String)"icons/downArrow.gif");
        _sExpandedIcon = new ImageIcon(i);
        i = ImageUtils.getImageResource(HeadingContainer.class, (String)"icons/rightArrow.gif");
        _sCollapsedIcon = new ImageIcon(i);
    }
}

