/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.gui.swing.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.gui.swing.action.XmlKeyConvertible;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.metadata.XmlMetadataConstants;
import oracle.bali.xml.metadata.structured.StructuredMetadataBean;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.convert.ConvertPlugin;
import oracle.bali.xml.model.convert.Convertible;
import oracle.bali.xml.util.NameToStringUtils;
import org.w3c.dom.Node;

public class ConvertMapPlugin
implements ConvertPlugin {
    protected XmlContext _context;
    protected final Map<XmlKey, Set<XmlKey>> _conversionMap = new HashMap<XmlKey, Set<XmlKey>>();
    private static final Logger _LOGGER = Logger.getLogger(ConvertMapPlugin.class.getName());

    public void init(XmlContext context, StructuredMetadataBean plugin) {
        this._context = context;
        XmlKey ownerNS = plugin.getOwnerNS();
        List children = plugin.getChildren();
        for (StructuredMetadataBean child : children) {
            String childValue;
            QualifiedName childName = child.getName();
            if (XmlMetadataConstants.MAPPING.equals((Object)childName)) {
                String source = child.getProperty(XmlMetadataConstants.SRC_ATTR);
                String target = child.getProperty(XmlMetadataConstants.TARGET_ATTR);
                if (source == null || target == null) continue;
                XmlKey sourceKey = this._parseXmlKey(ownerNS.getNamespace(), source);
                XmlKey targetKey = this._parseXmlKey(ownerNS.getNamespace(), target);
                if (sourceKey == null || targetKey == null) continue;
                this._addConversionEntry(sourceKey, targetKey);
                continue;
            }
            if (!XmlMetadataConstants.MAPPING_GROUP.equals((Object)childName) || (childValue = child.getValue()) == null) continue;
            this._parseXmlKeyList(ownerNS.getNamespace(), childValue);
        }
    }

    public List<Convertible> getConvertibles(Node node) {
        XmlKey nodeKey = this._context.getModel().getNodeXmlKey(node);
        if (this._conversionMap.containsKey(nodeKey)) {
            ArrayList<Convertible> convertibles = new ArrayList<Convertible>();
            for (XmlKey key : this._conversionMap.get(nodeKey)) {
                if (key.getNodeType() != 1) continue;
                convertibles.add(new XmlKeyConvertible(this._context, key));
            }
            return convertibles;
        }
        return Collections.emptyList();
    }

    protected void _parseXmlKeyList(String ownerNS, String xmlKeys) {
        HashSet<XmlKey> xmlKeySet = new HashSet<XmlKey>();
        String[] xmlKeyArray = xmlKeys.split("\\s");
        for (String xmlKeyStr : xmlKeyArray) {
            XmlKey xmlKey = this._parseXmlKey(ownerNS, xmlKeyStr);
            if (xmlKey == null) continue;
            xmlKeySet.add(xmlKey);
        }
        for (XmlKey key : xmlKeySet) {
            Set<Object> keys = null;
            keys = this._conversionMap.containsKey(key) ? this._conversionMap.get(key) : new HashSet();
            keys.addAll((Set)xmlKeySet.clone());
            keys.remove(key);
            this._conversionMap.put(key, keys);
        }
    }

    protected XmlKey _parseXmlKey(String ownerNS, String xmlKeyStr) {
        int[] array = new int[1];
        HashMap<Object, String> initialNamespaces = new HashMap<Object, String>();
        array[0] = 0;
        initialNamespaces.put(null, ownerNS);
        try {
            return NameToStringUtils.parseXmlKeyWithPrefixMappings(initialNamespaces, (CharSequence)xmlKeyStr, (int[])array);
        }
        catch (NameToStringUtils.ParseException e) {
            _LOGGER.log(Level.WARNING, "Unexpected Exception encountered from ParseXmlKey", e);
            return null;
        }
    }

    private void _addConversionEntry(XmlKey source, XmlKey target) {
        Set<XmlKey> keys = null;
        keys = this._conversionMap.containsKey(source) ? this._conversionMap.get(source) : new HashSet<XmlKey>();
        keys.add(target);
        this._conversionMap.put(source, keys);
    }
}

