/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.renderer;

import java.awt.Color;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.language.BaseStyle;
import oracle.javatools.editor.language.BuiltInStyles;
import oracle.javatools.editor.language.StyleRegistry;
import oracle.javatools.resource.BundleHelper;

public final class XMLStyles {
    public static final String XML_ELEMENT_NAME_STYLE = "xml-element-style";
    public static final String XML_ATTRIBUTE_NAME_STYLE = "xml-attribute-name-style";
    public static final String XML_ATTRIBUTE_VALUE_STYLE = "xml-attribute-value-style";
    public static final String XML_COMMENT_STYLE = "xml-comment-style";
    public static final String XML_DOCUMENT_TYPE_STYLE = "xml-document-type-style";
    public static final String XML_CDATA_STYLE = "xml-cdata-style";
    public static final String XML_TEXT_STYLE = "xml-text-style";
    public static final String XML_PROCESSING_INSTRUCTION_STYLE = "xml-processing-instruction-style";
    public static final String XML_SYMBOL_STYLE = "xml-symbol-style";
    public static final String[] STYLE_NAMES = new String[]{"xml-element-style", "xml-attribute-name-style", "xml-attribute-value-style", "xml-comment-style", "xml-document-type-style", "xml-cdata-style", "xml-text-style", "xml-processing-instruction-style", "xml-symbol-style"};
    public BaseStyle xmlPlainStyle;
    public BaseStyle xmlElementNameStyle;
    public BaseStyle xmlAttributeNameStyle;
    public BaseStyle xmlAttributeValueStyle;
    public BaseStyle xmlCommentStyle;
    public BaseStyle xmlDocumentTypeStyle;
    public BaseStyle xmlCDATAStyle;
    public BaseStyle xmlTextStyle;
    public BaseStyle xmlProcessingInstructionStyle;
    public BaseStyle xmlSymbolStyle;

    public XMLStyles(StyleRegistry styleRegistry) {
        this.reloadStyles(styleRegistry);
    }

    public void reloadStyles(StyleRegistry styleRegistry) {
        String name;
        BundleHelper resources = EditorProperties.getEditorBundle();
        BuiltInStyles builtInStyles = new BuiltInStyles(styleRegistry);
        this.xmlPlainStyle = builtInStyles.plainStyle;
        this.xmlCommentStyle = styleRegistry.lookupStyle(XML_COMMENT_STYLE);
        if (this.xmlCommentStyle == null) {
            name = resources.getString("XML_COMMENT_STYLE");
            this.xmlCommentStyle = styleRegistry.createStyle(XML_COMMENT_STYLE, name, "base-comment-style");
        }
        this.xmlDocumentTypeStyle = styleRegistry.lookupStyle(XML_DOCUMENT_TYPE_STYLE);
        if (this.xmlDocumentTypeStyle == null) {
            name = resources.getString("XML_DOCUMENT_TYPE_STYLE");
            this.xmlDocumentTypeStyle = styleRegistry.createStyle(XML_DOCUMENT_TYPE_STYLE, name, "base-comment-style", Color.darkGray);
        }
        this.xmlCDATAStyle = styleRegistry.lookupStyle(XML_CDATA_STYLE);
        if (this.xmlCDATAStyle == null) {
            name = resources.getString("XML_CDATA_STYLE");
            this.xmlCDATAStyle = styleRegistry.createStyle(XML_CDATA_STYLE, name, "base-plain-style");
        }
        this.xmlTextStyle = styleRegistry.lookupStyle(XML_TEXT_STYLE);
        if (this.xmlTextStyle == null) {
            name = resources.getString("XML_TEXT_STYLE");
            this.xmlTextStyle = styleRegistry.createStyle(XML_TEXT_STYLE, name, "base-plain-style");
        }
        this.xmlProcessingInstructionStyle = styleRegistry.lookupStyle(XML_PROCESSING_INSTRUCTION_STYLE);
        if (this.xmlProcessingInstructionStyle == null) {
            name = resources.getString("XML_PROCESSING_INSTRUCTION_STYLE");
            this.xmlProcessingInstructionStyle = styleRegistry.createStyle(XML_PROCESSING_INSTRUCTION_STYLE, name, "base-comment-style", Color.darkGray);
        }
        this.xmlSymbolStyle = styleRegistry.lookupStyle(XML_SYMBOL_STYLE);
        if (this.xmlSymbolStyle == null) {
            name = resources.getString("XML_SYMBOL_STYLE");
            this.xmlSymbolStyle = styleRegistry.createStyle(XML_SYMBOL_STYLE, name, "base-markup-style", Color.blue);
        }
        this.xmlElementNameStyle = styleRegistry.lookupStyle(XML_ELEMENT_NAME_STYLE);
        if (this.xmlElementNameStyle == null) {
            name = resources.getString("XML_ELEMENT_NAME_STYLE");
            this.xmlElementNameStyle = styleRegistry.createStyle(XML_ELEMENT_NAME_STYLE, name, "base-element-style");
        }
        this.xmlAttributeNameStyle = styleRegistry.lookupStyle(XML_ATTRIBUTE_NAME_STYLE);
        if (this.xmlAttributeNameStyle == null) {
            name = resources.getString("XML_ATTRIBUTE_NAME_STYLE");
            this.xmlAttributeNameStyle = styleRegistry.createStyle(XML_ATTRIBUTE_NAME_STYLE, name, "base-attribute-name-style");
        }
        this.xmlAttributeValueStyle = styleRegistry.lookupStyle(XML_ATTRIBUTE_VALUE_STYLE);
        if (this.xmlAttributeValueStyle == null) {
            name = resources.getString("XML_ATTRIBUTE_VALUE_STYLE");
            this.xmlAttributeValueStyle = styleRegistry.createStyle(XML_ATTRIBUTE_VALUE_STYLE, name, "base-attribute-value-style");
        }
    }
}

