/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.renderer;

import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.dom.buffer.lexer.XMLLexer;
import oracle.bali.xml.dom.buffer.lexer.XMLTokens;
import oracle.bali.xml.editor.renderer.XMLBlockRenderer;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.BlockRenderer;
import oracle.javatools.editor.language.LanguageSupport;
import oracle.javatools.editor.language.LexerDocumentRenderer;
import oracle.javatools.editor.language.LexerOffsetsCache;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.util.Pair;

public final class XMLDocumentRenderer
extends LexerDocumentRenderer
implements XMLTokens {
    public XMLDocumentRenderer(LanguageSupport support) {
        super(support);
    }

    protected BlockRenderer createBlockRenderer() {
        TextBuffer textBuffer = this.getTextBuffer();
        return new XMLBlockRenderer(textBuffer);
    }

    protected Lexer createLexer() {
        return new XMLLexer();
    }

    public boolean isMultiLineToken(int token) {
        switch (token) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return true;
            }
        }
        return false;
    }

    protected LexerOffsetsCache createOffsetsCache(LexerDocumentRenderer renderer) {
        return new XMLOffsetsCache(renderer);
    }

    public static class XMLOffsetsCache
    extends LexerOffsetsCache {
        private List<Pair<Integer, Integer>> _offsetsCache = new ArrayList<Pair<Integer, Integer>>();
        private int _cacheEndOffset = 0;

        public XMLOffsetsCache(LexerDocumentRenderer documentRenderer) {
            super(documentRenderer);
        }

        protected int findClosestOffsetInternal(Lexer lexer, LexerToken lexerToken, int offset) {
            this._ensureCachePopulated(lexer, lexerToken, offset);
            return this._findNearestTokenStart(offset);
        }

        protected void invalidateOffsetsInternal(int offset) {
            if (this._cacheEndOffset > offset) {
                Pair<Integer, Integer> pair;
                this._cacheEndOffset = this._findNearestTokenStart(offset);
                for (int i = this._offsetsCache.size() - 1; i >= 0 && (Integer)(pair = this._offsetsCache.get(i)).getSecond() >= this._cacheEndOffset; --i) {
                    if ((Integer)pair.getFirst() < this._cacheEndOffset) continue;
                    this._offsetsCache.remove(i);
                }
            }
        }

        private void _ensureCachePopulated(Lexer lexer, LexerToken lexerToken, int targetOffset) {
            if (targetOffset < this._cacheEndOffset) {
                return;
            }
            lexer.setTextBuffer((ReadTextBuffer)this.getDocumentRenderer().getTextBuffer());
            lexer.setPosition(this._cacheEndOffset);
            int lastTokenEndOffset = 0;
            while (lastTokenEndOffset < targetOffset) {
                int token = lexer.lex(lexerToken);
                lastTokenEndOffset = lexerToken.getEndOffset();
                if (token == 0) break;
                if (token != 17 && token != 13) continue;
                this._offsetsCache.add((Pair<Integer, Integer>)new Pair((Object)lexerToken.getStartOffset(), (Object)lexerToken.getEndOffset()));
            }
            this._cacheEndOffset = lastTokenEndOffset;
        }

        private int _findNearestTokenStart(int targetOffset) {
            Pair<Integer, Integer> pair;
            int offset = this._getPreviousStartOffset(targetOffset);
            for (int i = this._offsetsCache.size() - 1; i >= 0 && (Integer)(pair = this._offsetsCache.get(i)).getSecond() > offset; --i) {
                if ((Integer)pair.getFirst() > offset || offset >= (Integer)pair.getSecond()) continue;
                return (Integer)pair.getFirst();
            }
            return offset;
        }

        private int _getPreviousStartOffset(int offset) {
            int start;
            TextBuffer textBuffer = this.getDocumentRenderer().getTextBuffer();
            int size = textBuffer.getLength();
            int n = start = offset >= size ? size - 1 : offset;
            while (start > 0) {
                if (textBuffer.getChar(start) == '<') {
                    return start;
                }
                --start;
            }
            return 0;
        }
    }
}

