/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.editor.renderer;

import oracle.bali.xml.dom.buffer.lexer.XMLLexer;
import oracle.bali.xml.dom.buffer.lexer.XMLTokens;
import oracle.bali.xml.editor.renderer.XMLTagRenderer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.language.LexerBlockRenderer;
import oracle.javatools.editor.language.StyledFragmentsList;
import oracle.javatools.parser.Lexer;

public class XMLBlockRenderer
extends LexerBlockRenderer
implements XMLTokens {
    protected XMLTagRenderer tagRenderer;

    public XMLBlockRenderer(TextBuffer textBuffer) {
        super(textBuffer);
        this.tagRenderer = new XMLTagRenderer(textBuffer);
    }

    protected Lexer createLexer() {
        return new XMLLexer();
    }

    protected void renderToken(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        switch (token) {
            case 11: 
            case 12: 
            case 14: {
                int newClipStart = Math.max(tokenStart, clipStart);
                int newClipEnd = Math.min(tokenEnd, clipEnd);
                this.renderXMLTag(fragmentsList, token, tokenStart, tokenEnd, newClipStart, newClipEnd);
                break;
            }
            default: {
                super.renderToken(fragmentsList, token, tokenStart, tokenEnd, clipStart, clipEnd);
            }
        }
    }

    protected String mapTokenToStyleName(int token) {
        switch (token) {
            case 11: 
            case 12: 
            case 14: {
                throw new IllegalStateException("Should be sub-rendering tags");
            }
            case 15: {
                return "xml-processing-instruction-style";
            }
            case 13: {
                return "xml-comment-style";
            }
            case 18: {
                return "xml-document-type-style";
            }
            case 17: {
                return "xml-cdata-style";
            }
            case 16: {
                return "xml-text-style";
            }
        }
        return this.getDefaultStyleName();
    }

    protected void renderXMLTag(StyledFragmentsList fragmentsList, int token, int tokenStart, int tokenEnd, int clipStart, int clipEnd) {
        this.tagRenderer.renderBlock(fragmentsList, tokenStart, tokenEnd, clipStart, clipEnd);
    }
}

