/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import oracle.ewt.LookAndFeel;
import oracle.ewt.button.PushButton;
import oracle.ewt.lwAWT.BufferedFrame;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.util.WindowUtils;
import oracle.ewt.wizard.BaseWizard;
import oracle.ewt.wizard.WizardAdapter;
import oracle.ewt.wizard.WizardEvent;
import oracle.ewt.wizard.WizardListener;

public class WizardFrame
extends BufferedFrame {
    private BaseWizard _wizard;
    private boolean _cancelled;
    private Dimension _preferred;
    private WizardListener _listener;
    private static final int _BORDER_INSET = 13;
    private static final BorderPainter _sBorderPainter = new FixedBorderPainter(13, 13, 13, 13);

    public WizardFrame(BaseWizard baseWizard) {
        this(baseWizard, "");
    }

    public WizardFrame(BaseWizard baseWizard, String string) {
        super(string);
        this._wizard = baseWizard;
        this._listener = new WizListener();
        this.enableEvents(64L);
        this.setBackground(this.getUIDefaults().getColor(LookAndFeel.LIGHT_INTENSITY));
    }

    public BaseWizard getWizard() {
        return this._wizard;
    }

    public void setPreferredSize(int n, int n2) {
        this._preferred = new Dimension(n, n2);
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public void show() {
        if (this.isVisible()) {
            return;
        }
        BaseWizard baseWizard = this._wizard;
        if (baseWizard.getParent() != null) {
            throw new IllegalStateException();
        }
        this.add((Component)baseWizard, "Center");
        baseWizard.addWizardListener(this._listener);
        this.pack();
        if (this._preferred != null) {
            this.setSize(this._preferred);
        }
        WindowUtils.centerWindow(this);
        this._cancelled = false;
        super.show();
    }

    public BorderPainter getBorderPainter() {
        return _sBorderPainter;
    }

    protected void dismissFrame(boolean bl) {
        this._cancelled = bl;
        this.setVisible(false);
        this._wizard.removeWizardListener(this._listener);
        this.remove(this._wizard);
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        PushButton pushButton;
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201 && (pushButton = this._wizard._cancel).isEnabled()) {
            pushButton.simulatePush();
        }
    }

    private class WizListener
    extends WizardAdapter {
        private WizListener() {
        }

        public void wizardFinished(WizardEvent wizardEvent) {
            WizardFrame.this.dismissFrame(false);
        }

        public void wizardCanceled(WizardEvent wizardEvent) {
            WizardFrame.this.dismissFrame(true);
        }
    }
}

