/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.util;

import java.util.Locale;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.util.BIDIText;

public class StringUtils {
    public static final int MNEMONIC_INDEX_NONE = -1;
    public static final char CHAR_UNDEFINED;
    private static final char _MNEMONIC_INDICATOR = '&';

    public static int getMnemonicIndex(String string) {
        int n;
        if (string == null) {
            return -1;
        }
        int n2 = string.length() - 1;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2 && (n = string.indexOf(38, n3)) != -1 && n < n2) {
            if (string.charAt(n + 1) != '&') {
                return n - n4;
            }
            n3 = n + 2;
            ++n4;
        }
        return -1;
    }

    public static String stripMnemonic(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n <= 1) {
            return string;
        }
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.indexOf(38, n2);
            if (n3 < 0 || n3 >= n - 1) {
                if (stringBuffer == null) break;
                stringBuffer.append(string.substring(n2));
                break;
            }
            if (stringBuffer == null) {
                if (n3 == 0 && string.charAt(1) != '&') {
                    string = string.substring(1);
                    --n;
                    continue;
                }
                stringBuffer = new StringBuffer(n - 1);
            }
            stringBuffer.append(string.substring(n2, n3));
            stringBuffer.append(string.charAt(n3 + 1));
            n2 = n3 + 2;
        }
        if (stringBuffer == null) {
            return string;
        }
        return new String(stringBuffer);
    }

    public static boolean containsRightToLeft(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (!StringUtils._isRightToLeft(string.charAt(n2++))) continue;
            return true;
        }
        return false;
    }

    public static String getDisplayString(String string, PaintContext paintContext) {
        return StringUtils.getDisplayString(string, paintContext.getPaintLocale(), paintContext.getReadingDirection());
    }

    public static String getDisplayString(String string, Locale locale, int n) {
        if (string == null) {
            return null;
        }
        if (n == 1 && !StringUtils.containsRightToLeft(string)) {
            return string;
        }
        BIDIText bIDIText = new BIDIText(string, n, locale, true);
        return bIDIText.getVisualText();
    }

    public static int getDisplayMnemonicIndex(String string, PaintContext paintContext, int n) {
        return StringUtils.getDisplayMnemonicIndex(string, paintContext.getPaintLocale(), n, paintContext.getReadingDirection());
    }

    public static int getDisplayMnemonicIndex(String string, Locale locale, int n, int n2) {
        if (string == null) {
            return n;
        }
        if (n2 == 1 && !StringUtils.containsRightToLeft(string)) {
            return n;
        }
        BIDIText bIDIText = new BIDIText(string, n2, locale, false);
        string = bIDIText.getVisualText();
        int[] nArray = bIDIText.getLogicalOrder();
        if (nArray == null || n >= nArray.length) {
            return n;
        }
        return nArray[n];
    }

    private static boolean _isArabic(char c) {
        return c >= '\u0600' && c <= '\u06ff';
    }

    private static boolean _isHebrew(char c) {
        return c >= '\u0590' && c <= '\u05ff';
    }

    private static boolean _isRightToLeft(char c) {
        return StringUtils._isArabic(c) || StringUtils._isHebrew(c);
    }

    static {
        String string = System.getProperty("java.version");
        CHAR_UNDEFINED = string != null && string.startsWith("1.1") ? (char)'\u0000' : (char)65535;
    }
}

