/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.toolBar;

import java.awt.Image;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.graphics.ImageSet;
import oracle.ewt.toolBar.ToolBarButton;

public abstract class ToolBarToggleButton
extends ToolBarButton {
    private boolean _state;

    protected ToolBarToggleButton() {
    }

    protected ToolBarToggleButton(int n, Image image) {
        super(n, image);
    }

    protected ToolBarToggleButton(int n, ImageSet imageSet) {
        super(n, imageSet);
    }

    protected ToolBarToggleButton(int n, Image image, String string) {
        super(n, image, string);
    }

    protected ToolBarToggleButton(int n, ImageSet imageSet, String string) {
        super(n, imageSet, string);
    }

    public boolean getState() {
        return this._state;
    }

    public void setState(boolean bl) {
        if (this._state != bl) {
            this._state = bl;
            this.paintItem();
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            if (accessibleContext != null) {
                AccessibleState accessibleState = AccessibleState.CHECKED;
                accessibleContext.firePropertyChange("AccessibleState", bl ? null : accessibleState, bl ? accessibleState : null);
            }
        }
    }

    protected boolean isPressed() {
        return this.getState() != this.isArmed();
    }

    protected AccessibleContext createAccessibleContext() {
        return new ToggleAccess();
    }

    public class ToggleAccess
    extends ToolBarButton.ButtonAccess
    implements AccessibleValue {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (ToolBarToggleButton.this.getState()) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return IntegerUtils.getInteger((int)(ToolBarToggleButton.this.getState() ? 1 : 0));
        }

        public boolean setCurrentAccessibleValue(Number number) {
            ToolBarToggleButton.this.setState(number.intValue() != 0);
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return IntegerUtils.getInteger((int)0);
        }

        public Number getMaximumAccessibleValue() {
            return IntegerUtils.getInteger((int)1);
        }
    }
}

