/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.statusBar;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.PaintContextProxy;
import oracle.ewt.painter.Painter;
import oracle.ewt.statusBar.StatusBar;
import oracle.ewt.util.ImmInsets;

public abstract class StatusBarItem
extends PaintContextProxy
implements Accessible {
    public static final int DEFAULT_SIZE = -1;
    private StatusBar _parent;
    private int _x;
    private int _y;
    private int _width;
    private int _height;
    private int _minWidth;
    private boolean _expanding;
    private boolean _visible;
    private AccessibleContext _accessibleContext;

    public StatusBarItem() {
        this(-1, true);
    }

    public StatusBarItem(int n, boolean bl) {
        this._minWidth = n;
        this._expanding = bl;
        this._visible = true;
    }

    public Rectangle getBounds() {
        return new Rectangle(this._x, this._y, this._width, this._height);
    }

    public boolean isExpanding() {
        return this._expanding;
    }

    public StatusBar getParent() {
        return this._parent;
    }

    public void setVisible(boolean bl) {
        if (this._visible != bl) {
            this._visible = bl;
            this.invalidateParent(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(int n, int n2) {
        if (this.isVisible()) {
            StatusBarItem statusBarItem = this;
            synchronized (statusBarItem) {
                Point point = this.getLocation();
                Dimension dimension = this.getSize();
                return n >= point.x && n < point.x + dimension.width && n2 >= point.y && n2 < point.y + dimension.height;
            }
        }
        return false;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public Point getLocation() {
        return new Point(this._x, this._y);
    }

    public int getMinimumWidth() {
        if (this._minWidth != -1) {
            return this._minWidth;
        }
        Painter painter = this.getMinimumSizePainter();
        int n = painter != null ? painter.getMinimumSize((PaintContext)this).width : 0;
        return this.getOuterSize(n, true);
    }

    public int getMinimumHeight() {
        Painter painter = this.getMinimumSizePainter();
        int n = painter != null ? painter.getMinimumSize((PaintContext)this).height : 0;
        return this.getOuterSize(n, false);
    }

    public final Dimension getMinimumSize() {
        if (this._minWidth == -1) {
            this._minWidth = this.getMinimumWidth();
        }
        return new Dimension(this._minWidth, this.getMinimumHeight());
    }

    public void setLocation(int n, int n2) {
        this._x = n;
        this._y = n2;
    }

    public void setSize(int n, int n2) {
        this._width = n;
        this._height = n2;
    }

    public void setMinimumWidth(int n) {
        this._minWidth = n;
        if (this.isVisible() && this.getParent() != null) {
            this.invalidateParent(true);
        }
    }

    public void setParent(StatusBar statusBar) {
        this._parent = statusBar;
    }

    public Dimension getSize() {
        return new Dimension(this._width, this._height);
    }

    public int getPaintState() {
        return super.getPaintState() & 5;
    }

    public Object getPaintData(Object object) {
        return null;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (dimension.width > 0 && dimension.height > 0) {
            Point point = this.getLocation();
            int n = point.x;
            int n2 = point.y;
            int n3 = dimension.width;
            int n4 = dimension.height;
            BorderPainter borderPainter = this.getBorderPainter();
            if (borderPainter != null) {
                borderPainter.paint(this, graphics, n, n2, n3, n4);
                ImmInsets immInsets = borderPainter.getInsets(this);
                n += immInsets.left;
                n2 += immInsets.right;
                n3 -= immInsets.left + immInsets.right;
                n4 -= immInsets.top + immInsets.bottom;
            }
            this.getPainter().paint(this, graphics, n, n2, n3, n4);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this._accessibleContext == null) {
            this._accessibleContext = new Access();
        }
        return this._accessibleContext;
    }

    protected AccessibleContext accessAccessibleContext() {
        return this._accessibleContext;
    }

    protected PaintContext getPaintContext() {
        StatusBar statusBar = this.getParent();
        if (statusBar != null) {
            return statusBar.getPaintContext();
        }
        return null;
    }

    protected void invalidateParent(boolean bl) {
        StatusBar statusBar = this.getParent();
        if (bl) {
            statusBar.invalidate();
            statusBar.repaint();
        } else {
            statusBar.invalidate();
        }
    }

    protected void repaint() {
        StatusBar statusBar = this.getParent();
        if (statusBar != null && this.isVisible()) {
            statusBar.repaintInterior(this._x, this._y, this._width, this._height);
        }
    }

    protected void invalidate() {
        StatusBar statusBar = this.getParent();
        if (statusBar != null && this.isVisible()) {
            statusBar.invalidate();
        }
    }

    protected abstract Painter getPainter();

    protected BorderPainter getBorderPainter() {
        StatusBar statusBar = this.getParent();
        if (statusBar != null) {
            return statusBar.getStatusBarUI().getItemBorderPainter(statusBar);
        }
        return null;
    }

    protected Painter getMinimumSizePainter() {
        return this.getPainter();
    }

    protected int getOuterSize(int n, boolean bl) {
        BorderPainter borderPainter = this.getBorderPainter();
        if (borderPainter != null) {
            ImmInsets immInsets = this.getBorderPainter().getInsets(this);
            n = bl ? (n += immInsets.left + immInsets.right) : (n += immInsets.top + immInsets.bottom);
        }
        return n;
    }

    private class Access
    extends AccessibleContext
    implements AccessibleComponent {
        private Access() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public String getAccessibleName() {
            Object object;
            String string = this.accessibleName;
            if (string == null && (object = StatusBarItem.this.getPaintData(PaintContext.LABEL_KEY)) instanceof String) {
                string = (String)object;
            }
            return string;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            Accessible accessible = this.getAccessibleParent();
            if (accessible == null) {
                return null;
            }
            AccessibleStateSet accessibleStateSet = accessible.getAccessibleContext().getAccessibleStateSet();
            if (!this.isVisible()) {
                accessibleStateSet.remove(AccessibleState.VISIBLE);
                accessibleStateSet.remove(AccessibleState.SHOWING);
            }
            return accessibleStateSet;
        }

        public Accessible getAccessibleParent() {
            return StatusBarItem.this.getParent();
        }

        public int getAccessibleIndexInParent() {
            StatusBar statusBar = StatusBarItem.this.getParent();
            if (statusBar == null) {
                return -1;
            }
            return statusBar.getItemIndex(StatusBarItem.this);
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            StatusBar statusBar = StatusBarItem.this.getParent();
            if (statusBar == null) {
                return null;
            }
            return statusBar.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return StatusBarItem.this.getPaintBackground();
        }

        public void setBackground(Color color) {
        }

        public Color getForeground() {
            return StatusBarItem.this.getPaintForeground();
        }

        public void setForeground(Color color) {
        }

        public Cursor getCursor() {
            StatusBar statusBar = StatusBarItem.this.getParent();
            Cursor cursor = null;
            if (statusBar != null) {
                cursor = statusBar.getCursor();
            }
            if (cursor == null) {
                cursor = Cursor.getDefaultCursor();
            }
            return cursor;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return StatusBarItem.this.getPaintFont();
        }

        public void setFont(Font font) {
        }

        public FontMetrics getFontMetrics(Font font) {
            return this.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return (StatusBarItem.this.getPaintState() & 1) == 0;
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isVisible() {
            return StatusBarItem.this.isVisible();
        }

        public void setVisible(boolean bl) {
        }

        public boolean isShowing() {
            return this.isVisible() && StatusBarItem.this.getParent() != null && StatusBarItem.this.getParent().isShowing();
        }

        public boolean contains(Point point) {
            Point point2 = this.getLocation();
            return StatusBarItem.this.contains(point.x + point2.x, point.y + point2.y);
        }

        public Point getLocationOnScreen() {
            if (this.isShowing()) {
                Point point = StatusBarItem.this.getParent().getLocationOnScreen();
                Point point2 = this.getLocation();
                point.x += point2.x;
                point.y += point2.y;
                return point;
            }
            return null;
        }

        public Point getLocation() {
            StatusBar statusBar = StatusBarItem.this.getParent();
            if (statusBar == null) {
                return null;
            }
            Point point = StatusBarItem.this.getLocation();
            return statusBar.convertInteriorToOuter(point.x, point.y);
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            if (!this.isShowing()) {
                return null;
            }
            return StatusBarItem.this.getBounds();
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            return StatusBarItem.this.getSize();
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }
    }
}

