/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.slider;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.lwAWT.AbstractPainterComponent;
import oracle.ewt.meter.BoundedRangeModel;
import oracle.ewt.painter.Painter;
import oracle.ewt.plaf.SliderUI;
import oracle.ewt.slider.SliderInputHandler;

public class Slider
extends AbstractPainterComponent {
    private PropertyChangeListener _propertyListener;
    private BoundedRangeModel _model;
    private boolean _armed;

    public Slider() {
        this(null);
    }

    public Slider(BoundedRangeModel boundedRangeModel) {
        this.enableEvents(56L);
        this.setModel(boundedRangeModel);
        this.setAlignment(3);
    }

    public void setModel(BoundedRangeModel boundedRangeModel) {
        if (boundedRangeModel != this.getModel()) {
            if (this._model != null) {
                this._model.removePropertyChangeListener(this._propertyListener);
            }
            this._model = boundedRangeModel;
            this._propertyListener = null;
            if (this._model != null) {
                this._propertyListener = new _PropListener();
                this._model.addPropertyChangeListener(this._propertyListener);
            }
            this.repaint();
        }
    }

    public BoundedRangeModel getModel() {
        return this._model;
    }

    public Object getUIClassID() {
        return "SliderUI";
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected Object getPaintData(Object object) {
        Object object2 = null;
        object2 = object == null || object == "Model" ? this.getModel() : super.getPaintData(object);
        return object2;
    }

    protected final SliderUI getSliderUI() {
        return (SliderUI)this.getUI();
    }

    protected Painter getPainter() {
        return this.getSliderUI().getPainter(this);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        this._getInputHandler().processMouseEvent(mouseEvent, this);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        this._getInputHandler().processMouseMotionEvent(mouseEvent, this);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (keyEvent.isConsumed() || !this.isEnabled()) {
            return;
        }
        this._getInputHandler().processKeyEvent(keyEvent, this);
    }

    protected int getPaintState() {
        int n = super.getPaintState();
        if (this._getInputHandler().isArmed(this)) {
            n |= 2;
        }
        return n;
    }

    protected AccessibleContext createAccessibleContext() {
        return new Access();
    }

    private SliderInputHandler _getInputHandler() {
        return this.getSliderUI().getSliderInputHandler(this);
    }

    void __propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.repaint();
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null && "value".equals(propertyChangeEvent.getPropertyName())) {
            accessibleContext.firePropertyChange("AccessibleValue", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    private class Access
    extends AccessibleLWComponent
    implements AccessibleValue {
        public Access() {
            super(Slider.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.HORIZONTAL);
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SLIDER;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            BoundedRangeModel boundedRangeModel = Slider.this.getModel();
            return IntegerUtils.getInteger((int)(boundedRangeModel == null ? 0 : boundedRangeModel.getValue()));
        }

        public boolean setCurrentAccessibleValue(Number number) {
            BoundedRangeModel boundedRangeModel = Slider.this.getModel();
            if (boundedRangeModel == null) {
                return false;
            }
            boundedRangeModel.setValue(number.intValue());
            return true;
        }

        public Number getMinimumAccessibleValue() {
            BoundedRangeModel boundedRangeModel = Slider.this.getModel();
            return IntegerUtils.getInteger((int)(boundedRangeModel == null ? 0 : boundedRangeModel.getMinimum()));
        }

        public Number getMaximumAccessibleValue() {
            BoundedRangeModel boundedRangeModel = Slider.this.getModel();
            return IntegerUtils.getInteger((int)(boundedRangeModel == null ? 0 : boundedRangeModel.getMaximum()));
        }
    }

    private class _PropListener
    implements PropertyChangeListener {
        private _PropListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Slider.this.__propertyChange(propertyChangeEvent);
        }
    }
}

