/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.ewt.painter.AbstractWrappingPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public class AlignmentPainter
extends AbstractWrappingPainter {
    public AlignmentPainter(Painter painter) {
        super(painter);
    }

    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Rectangle rectangle = this._getPainterBounds(paintContext, n, n2, n3, n4);
        super.paint(paintContext, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Painter getPainterAt(PaintContext paintContext, int n, int n2, int n3, int n4, Painter painter) {
        Rectangle rectangle = this._getPainterBounds(paintContext, 0, 0, n, n2);
        return super.getPainterAt(paintContext, rectangle.width, rectangle.height, n3 - rectangle.x, n4 - rectangle.y, painter);
    }

    public int getRepaintFlags(PaintContext paintContext) {
        return super.getRepaintFlags(paintContext) | 0x800 | 0x1000;
    }

    public boolean isTransparent(PaintContext paintContext) {
        return true;
    }

    protected float getAlignmentX(PaintContext paintContext) {
        return paintContext.getInteriorAlignmentX();
    }

    protected float getAlignmentY(PaintContext paintContext) {
        return paintContext.getInteriorAlignmentY();
    }

    private Rectangle _getPainterBounds(PaintContext paintContext, int n, int n2, int n3, int n4) {
        float f = this.getAlignmentX(paintContext);
        float f2 = this.getAlignmentY(paintContext);
        Dimension dimension = this.getSize(paintContext, n3, n4);
        if (dimension.width > n3) {
            dimension.width = n3;
        } else {
            n += (int)((double)(n3 - dimension.width) * (double)f);
        }
        if (dimension.height > n4) {
            dimension.height = n4;
        } else {
            n2 += (int)((float)(n4 - dimension.height) * f2);
        }
        return new Rectangle(n, n2, dimension.width, dimension.height);
    }
}

