/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.lwAWT;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.lang.reflect.Method;
import oracle.ewt.lwAWT.DoubleBuffer2;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;

public class BalkingDoubleBuffer
implements DoubleBuffer2 {
    private Image _offscreenBuffer;
    private boolean _bufferLocked;
    private static boolean _IS_JDK1_2 = true;

    public synchronized Image getOffscreenBuffer(Component component) {
        int n;
        int n2;
        if (this._bufferLocked) {
            return null;
        }
        if (component instanceof LWComponent) {
            Rectangle rectangle = ((LWComponent)component).__bounds;
            n2 = rectangle.width;
            n = rectangle.height;
        } else {
            Dimension dimension = component.getSize();
            n2 = dimension.width;
            n = dimension.height;
        }
        return this.getOffscreenBuffer(component, n2, n);
    }

    public synchronized Image getOffscreenBuffer(Component component, int n, int n2) {
        if (this._bufferLocked) {
            return null;
        }
        Image image = this._offscreenBuffer;
        if (image == null || image.getWidth(component) < n || image.getHeight(component) < n2) {
            if (image != null) {
                this._fullyFlushImage(image);
                image = null;
            }
            try {
                image = component.createImage(n, n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._offscreenBuffer = image;
        if (image != null) {
            this._bufferLocked = true;
        }
        return image;
    }

    public synchronized void releaseOffscreenBuffer(Image image) {
        if (image == this._offscreenBuffer) {
            this._bufferLocked = false;
        } else {
            this._fullyFlushImage(image);
        }
    }

    public synchronized void flush() {
        if (this._bufferLocked) {
            this._bufferLocked = false;
        } else if (this._offscreenBuffer != null) {
            this._fullyFlushImage(this._offscreenBuffer);
        }
        this._offscreenBuffer = null;
    }

    private void _fullyFlushImage(Image image) {
        image.flush();
        if (!_IS_JDK1_2) {
            TaskScheduler.getDefaultTaskScheduler().schedule(GCTask.getInstance(), 100);
        }
    }

    static {
        try {
            Method method = Class.class.getMethod("getProtectionDomain", null);
            _IS_JDK1_2 = method != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            _IS_JDK1_2 = false;
        }
    }

    private static class GCTask
    implements Task {
        private static final GCTask _sInstance = new GCTask();

        private GCTask() {
        }

        public void runTask(TaskEvent taskEvent) {
            System.gc();
        }

        public static GCTask getInstance() {
            return _sInstance;
        }
    }
}

