/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.ewt.laf.oracle.OracleComponentUI;
import oracle.ewt.laf.oracle.OracleWindowBorder;
import oracle.ewt.layout.MaximumBorderLayout;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.laf.MouseWindowResizer;
import oracle.ewt.lwAWT.lwWindow.laf.TitleBar;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.plaf.WindowUI;

public class OracleWindowUI
extends OracleComponentUI
implements WindowUI,
PropertyChangeListener {
    private LWComponent _contentPane;
    private TitleBar _titleBar;
    private BorderPainter _borderPainter;
    private MouseWindowResizer _resizer;

    public OracleWindowUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    public BorderPainter getDefaultBorderPainter(LWComponent lWComponent) {
        return this._borderPainter;
    }

    public void installUI(LWComponent lWComponent) {
        LWMenuBar lWMenuBar;
        LWWindow lWWindow = (LWWindow)lWComponent;
        this._titleBar = new TitleBar(lWWindow);
        this._contentPane = new LWComponent();
        this._contentPane.setLayout(new MaximumBorderLayout());
        Component component = lWWindow.getContent();
        if (component != null) {
            this._contentPane.add("Center", component);
        }
        if ((lWMenuBar = lWWindow.getMenuBar()) != null) {
            this._contentPane.add("North", lWMenuBar);
        }
        lWWindow.setLayout(new MaximumBorderLayout());
        lWWindow.add("North", this._titleBar);
        lWWindow.add("Center", this._contentPane);
        this._resizer = new MouseWindowResizer(lWWindow);
        lWWindow.addMouseListener(this._resizer);
        lWWindow.addMouseMotionListener(this._resizer);
        lWWindow.addPropertyChangeListener(this);
        this._borderPainter = new OracleWindowBorder(lWWindow, this._titleBar);
        this._installMenuBarNavigation(lWWindow.getMenuBar());
    }

    public void uninstallUI(LWComponent lWComponent) {
        LWWindow lWWindow = (LWWindow)lWComponent;
        Component component = lWWindow.getContent();
        LWMenuBar lWMenuBar = lWWindow.getMenuBar();
        if (component != null) {
            this._contentPane.remove(component);
        }
        if (lWMenuBar != null) {
            this._contentPane.remove(lWMenuBar);
        }
        lWWindow.remove(this._contentPane);
        lWWindow.remove(this._titleBar);
        lWWindow.setLayout(null);
        lWWindow.removeMouseListener(this._resizer);
        lWWindow.removeMouseMotionListener(this._resizer);
        lWWindow.removePropertyChangeListener(this);
        this._uninstallMenuBarNavigation(lWWindow.getMenuBar());
        this._contentPane = null;
        this._titleBar = null;
        this._resizer = null;
        this._borderPainter = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        LWWindow lWWindow = (LWWindow)propertyChangeEvent.getSource();
        if (string.equals("content")) {
            Component component = (Component)propertyChangeEvent.getOldValue();
            Component component2 = (Component)propertyChangeEvent.getNewValue();
            if (component != null) {
                this._contentPane.remove(component);
            }
            if (component2 != null) {
                this._contentPane.add("Center", component2);
            }
            lWWindow.validate();
        } else if (string.equals("menubar")) {
            LWMenuBar lWMenuBar = (LWMenuBar)propertyChangeEvent.getOldValue();
            LWMenuBar lWMenuBar2 = (LWMenuBar)propertyChangeEvent.getNewValue();
            if (lWMenuBar != null) {
                this._contentPane.remove(lWMenuBar);
                this._uninstallMenuBarNavigation(lWMenuBar);
            }
            if (lWMenuBar2 != null) {
                this._contentPane.add("North", lWMenuBar2);
                this._installMenuBarNavigation(lWMenuBar2);
            }
            lWWindow.validate();
        }
    }

    private void _installMenuBarNavigation(LWMenuBar lWMenuBar) {
        LWMenuBar lWMenuBar2 = this._titleBar.getSystemMenuBar();
        if (lWMenuBar != null) {
            lWMenuBar.putClientProperty("_ewtNextMenuBar", lWMenuBar2);
            lWMenuBar2.putClientProperty("_ewtNextMenuBar", lWMenuBar);
        }
    }

    private void _uninstallMenuBarNavigation(LWMenuBar lWMenuBar) {
        if (lWMenuBar != null) {
            LWMenuBar lWMenuBar2 = this._titleBar.getSystemMenuBar();
            lWMenuBar.putClientProperty("_ewtNextMenuBar", null);
            lWMenuBar2.putClientProperty("_ewtNextMenuBar", null);
        }
    }
}

