/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.oracle;

import java.awt.Color;
import java.awt.Image;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.Appearance;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.grid.Grid;
import oracle.ewt.laf.oracle.OracleGridUI;
import oracle.ewt.laf.oracle.OraclePivotCellBorderPainter;
import oracle.ewt.laf.oracle.OracleSplitPanePainter;
import oracle.ewt.laf.oracle.OracleTableUI;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.painter.Painter;
import oracle.ewt.pivot.PivotHeader;
import oracle.ewt.plaf.PivotHeaderUI;
import oracle.ewt.table.SpreadTable;

public class OraclePivotHeaderUI
extends OracleTableUI
implements PivotHeaderUI {
    public OraclePivotHeaderUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    public void installUI(LWComponent lWComponent) {
        super.installUI(lWComponent);
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        SpreadTable spreadTable = (SpreadTable)lWComponent;
        Grid grid = spreadTable.getGrid();
        grid.setBackground(uIDefaults.getColor(LookAndFeel.CONTROL));
    }

    public Painter getDefaultHeaderItemPainter(LWComponent lWComponent, boolean bl) {
        return new OracleSplitPanePainter(bl, false);
    }

    public Image getDrillImage(LWComponent lWComponent) {
        return lWComponent.getUIDefaults().getImage("PivotHeader.drillImage");
    }

    public Image getDrilledImage(LWComponent lWComponent) {
        return lWComponent.getUIDefaults().getImage("PivotHeader.drilledImage");
    }

    public Appearance getDefaultAppearance(LWComponent lWComponent) {
        PivotHeader pivotHeader = (PivotHeader)lWComponent;
        Grid grid = pivotHeader.getGrid();
        OracleGridUI oracleGridUI = (OracleGridUI)grid.getUI();
        Appearance appearance = oracleGridUI.getDefaultAppearance(grid);
        UIDefaults uIDefaults = this.getUIDefaults(lWComponent);
        appearance.setForeground(uIDefaults.getColor(LookAndFeel.CONTROL_TEXT));
        appearance.setBackground(uIDefaults.getColor(LookAndFeel.CONTROL));
        appearance.setBorderPainter(new OraclePivotCellBorderPainter(pivotHeader));
        return appearance;
    }

    public Color getSwapForegroundColor(LWComponent lWComponent, Appearance appearance) {
        return this.getUIDefaults(lWComponent).getColor("darkIntensity");
    }

    public Color getSwapBackgroundColor(LWComponent lWComponent, Appearance appearance) {
        return ColorUtils.darkerShadeColor(appearance.getBackground());
    }
}

