/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.laf.generic;

import oracle.ewt.graphics.ImageStrip;
import oracle.ewt.laf.basic.AbstractComponentUI;
import oracle.ewt.laf.basic.DisablingPainter;
import oracle.ewt.laf.generic.GenericSelectionPainter;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.LWMenuItem;
import oracle.ewt.lwAWT.lwMenu.LWMenuItemContainer;
import oracle.ewt.lwAWT.lwMenu.laf.HorzMenuItemController;
import oracle.ewt.lwAWT.lwMenu.laf.KeyStrokePainter;
import oracle.ewt.lwAWT.lwMenu.laf.MenuItemController;
import oracle.ewt.lwAWT.lwMenu.laf.MenuItemPainter;
import oracle.ewt.lwAWT.lwMenu.laf.MenuSelColorChange;
import oracle.ewt.lwAWT.lwMenu.laf.MenuSelTextColorChange;
import oracle.ewt.lwAWT.lwMenu.laf.VertMenuItemController;
import oracle.ewt.painter.AndOrStatePainterSwitcher;
import oracle.ewt.painter.DirectionalBorderPainter;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.ImageSetPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.TruncatingTextPainter;
import oracle.ewt.plaf.MenuItemUI;

public class GenericMenuItemUI
extends AbstractComponentUI
implements MenuItemUI {
    protected static final Painter TEXT_PAINTER = GenericMenuItemUI.createDisablingPainter(new TruncatingTextPainter());
    protected static final Painter IMAGE_PAINTER = new ImageSetPainter();
    protected static final Painter ITEM_IMAGE_PAINTER = new FixedBorderPainter(IMAGE_PAINTER, 0, 2, 0, 2, false);
    protected static final Painter ITEM_LABEL_PAINTER = new FixedBorderPainter(TEXT_PAINTER, 0, 2, 0, 2, false);
    protected static final Painter ITEM_ACCELERATOR_PAINTER = new DirectionalBorderPainter(GenericMenuItemUI.createDisablingPainter(KeyStrokePainter.getPainter()), 0, 10, 0, 2, false);
    private MenuItemController _controller;
    private static final MenuItemPainter _MENU_ITEM_PAINTER = new MenuItemPainter(null, ITEM_IMAGE_PAINTER, ITEM_LABEL_PAINTER, ITEM_ACCELERATOR_PAINTER, null);
    private static final Painter _HORZ_PAINTER = GenericMenuItemUI.createHorizontalPainter(_MENU_ITEM_PAINTER);
    private static final Painter _VERT_PAINTER = GenericMenuItemUI.createPainter(_MENU_ITEM_PAINTER, false);

    public GenericMenuItemUI(LWComponent lWComponent) {
        super(lWComponent);
    }

    protected MenuItemPainter createStateMenuItem(LWComponent lWComponent, String string) {
        return new MenuItemPainter(new FixedBorderPainter(new ImageSetPainter(new ImageStrip(this.getUIDefaults(lWComponent).getImage(string), 11)), 0, 2, 0, 2), ITEM_IMAGE_PAINTER, ITEM_LABEL_PAINTER, ITEM_ACCELERATOR_PAINTER, null);
    }

    protected static Painter createPainter(Painter painter, boolean bl) {
        int n = 1;
        int n2 = 5;
        if (!bl) {
            n = 2;
            n2 = 2;
        }
        return new MenuSelColorChange(new GenericSelectionPainter(new MenuSelTextColorChange(new FixedBorderPainter(painter, n, n2, n, n2))));
    }

    protected static Painter createHorizontalPainter(Painter painter) {
        return new FixedBorderPainter(GenericMenuItemUI.createPainter(painter, true), 1, 0, 1, 0);
    }

    public static Painter createDisablingPainter(Painter painter) {
        return new AndOrStatePainterSwitcher(new DisablingPainter(painter), painter, 128, 0, 0, 0);
    }

    public MenuItemUI.MenuItemConstraints getConstraints(LWComponent lWComponent) {
        return this.getMenuItemPainter().getConstraints(lWComponent.getPaintContext());
    }

    public Painter getPainter(LWComponent lWComponent) {
        LWMenuItem lWMenuItem = (LWMenuItem)lWComponent;
        LWMenuItemContainer lWMenuItemContainer = lWMenuItem.getMenuItemContainer();
        if (lWMenuItemContainer != null && lWMenuItemContainer.getOrientation() == 0) {
            return this.getVerticalItemPainter();
        }
        return this.getHorizontalItemPainter();
    }

    public void componentAddNotify(LWComponent lWComponent) {
        this._installController(lWComponent);
    }

    public void componentRemoveNotify(LWComponent lWComponent) {
        this._uninstallController(lWComponent);
    }

    public void installUI(LWComponent lWComponent) {
        this._installController(lWComponent);
    }

    public void uninstallUI(LWComponent lWComponent) {
        this._uninstallController(lWComponent);
    }

    protected MenuItemPainter getMenuItemPainter() {
        return _MENU_ITEM_PAINTER;
    }

    protected Painter getHorizontalItemPainter() {
        return _HORZ_PAINTER;
    }

    protected Painter getVerticalItemPainter() {
        return _VERT_PAINTER;
    }

    protected MenuItemController getHorizontalItemController() {
        return new HorzMenuItemController();
    }

    protected MenuItemController getVerticalItemController() {
        return new VertMenuItemController();
    }

    private void _installController(LWComponent lWComponent) {
        LWMenuItem lWMenuItem;
        LWMenuItemContainer lWMenuItemContainer;
        if (this._controller == null && (lWMenuItemContainer = (lWMenuItem = (LWMenuItem)lWComponent).getMenuItemContainer()) != null) {
            this._controller = lWMenuItemContainer.getOrientation() == 1 ? this.getHorizontalItemController() : this.getVerticalItemController();
            this._controller.installController(lWMenuItem);
        }
    }

    private void _uninstallController(LWComponent lWComponent) {
        if (this._controller != null) {
            this._controller.uninstallController((LWMenuItem)lWComponent);
            this._controller = null;
        }
    }
}

