/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.imageCanvas;

import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import oracle.ewt.EwtComponent;
import oracle.ewt.painter.AlignmentPainter;
import oracle.ewt.painter.ImagePainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.scrolling.ScrollableException;

public class ImageCanvas
extends EwtComponent {
    public static final int DONT_SCALE = 0;
    public static final int PRESERVE_ASPECT_RATIO = 1;
    public static final int SCALE_TO_FIT = 2;
    private Image _image;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;
    private float _yAlign = 0.0f;
    private float _xAlign = 0.0f;
    private int _scalingMode = 0;
    private Painter _painter;
    private static final int _DEFAULT_SCALING = 0;
    private static final Painter _sPainter = ImageCanvas._createImagePainter(0);
    private static final int _MINIMUM_WIDTH = 10;
    private static final int _MINIMUM_HEIGHT = 10;

    public ImageCanvas() {
    }

    public ImageCanvas(Image image) {
        this._image = image;
    }

    public Image getImage() {
        return this._image;
    }

    public void setImage(Image image) {
        this._image = image;
        this.invalidateCanvas();
    }

    public void setScalingMode(int n) {
        if (n != this._scalingMode) {
            this._scalingMode = n;
            this._painter = n == 0 ? null : ImageCanvas._createImagePainter(n);
            this.repaint();
        }
    }

    public int getScalingMode() {
        return this._scalingMode;
    }

    public void setInteriorAlignmentX(float f) {
        this._xAlign = f;
    }

    public float getInteriorAlignmentX() {
        return this._xAlign;
    }

    public void setInteriorAlignmentY(float f) {
        this._yAlign = f;
    }

    public float getInteriorAlignmentY() {
        return this._yAlign;
    }

    public final boolean isHScrollable() {
        return true;
    }

    public final boolean isVScrollable() {
        return true;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 3) != 0) {
            this.invalidateCanvas();
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    public Dimension getMinimumSize() {
        int n = 0;
        int n2 = 0;
        if (this._image != null) {
            n = this._image.getWidth(this);
            n2 = this._image.getHeight(this);
        }
        if (n > 10) {
            n = 10;
        }
        if (n2 > 10) {
            n2 = 10;
        }
        return this.convertInnerToOuterSize(n, n2);
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        if (this._image != null) {
            n = this._image.getWidth(this);
            n2 = this._image.getHeight(this);
        }
        return this.convertInnerToOuterSize(n, n2);
    }

    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable != null) {
            throw new ScrollableException();
        }
        this._hAdjustable = adjustable;
    }

    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._vAdjustable != null) {
            throw new ScrollableException();
        }
        this._vAdjustable = adjustable;
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable == adjustable) {
            this._hAdjustable = null;
        } else if (this._vAdjustable == adjustable) {
            this._vAdjustable = null;
        } else {
            throw new ScrollableException();
        }
    }

    protected void paintCanvasInterior(Graphics graphics) {
        Dimension dimension = this.getCanvasSize();
        this.getPainter().paint(this.getPaintContext(), graphics, 0, 0, dimension.width, dimension.height);
    }

    protected Dimension layoutCanvas() {
        Dimension dimension = this.getInnerSize();
        if (this.getScalingMode() == 0 && this._image != null) {
            int n;
            int n2 = this._image.getWidth(this);
            if (n2 > dimension.width) {
                dimension.width = n2;
            }
            if ((n = this._image.getHeight(this)) > dimension.height) {
                dimension.height = n;
            }
        }
        return dimension;
    }

    protected Object getPaintData(Object object) {
        if (PaintContext.IMAGE_KEY.equals(object)) {
            return this._image;
        }
        return super.getPaintData(object);
    }

    protected int getRepaintFlags() {
        return super.getRepaintFlags() | this.getPainter().getRepaintFlags(this.getPaintContext());
    }

    protected Painter getPainter() {
        Painter painter = this._painter;
        if (painter == null) {
            painter = _sPainter;
        }
        return painter;
    }

    private static Painter _createImagePainter(int n) {
        ImagePainter imagePainter = new ImagePainter(PaintContext.IMAGE_KEY, n);
        imagePainter.setProgressiveLoading(true);
        return new AlignmentPainter(imagePainter);
    }
}

