/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.header;

final class GeometryManager {
    private int[] _itemPositions;
    private int[] _itemSizes;
    private int[] _dataSourceToVisible;
    private int[] _visibleToDataSource;
    private int _items;
    private int _visibleItems;
    private int _itemSize;
    private int _defaultSize;
    private int _separatorSize;
    private int _direction = 1;

    public GeometryManager(int n) {
        this._items = n;
        this._visibleItems = n;
        this._itemSize = 0;
    }

    public final int getItemPosition(int n) {
        if (this._itemPositions == null) {
            if (this._defaultSize == 0) {
                return 0;
            }
            if (this._direction == 2) {
                int n2 = (this._items - n - 1) * (this._defaultSize + this._separatorSize);
                return n2;
            }
            int n3 = n * (this._defaultSize + this._separatorSize);
            return n3;
        }
        return this._itemPositions[n];
    }

    public final int getItemAt(int n) {
        if (n > this._itemSize) {
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (this._itemPositions == null) {
            int n2 = this._defaultSize + this._separatorSize;
            if (n2 == 0) {
                return -1;
            }
            int n3 = n / n2;
            if (this._direction == 2) {
                if (n3 < this._items) {
                    return this._items - n3 - 1;
                }
                return 0;
            }
            if (n3 < this._items) {
                return n3;
            }
            return this._items - 1;
        }
        int n4 = this._separatorSize;
        for (int i = 0; i < this._items; ++i) {
            int n5 = this.convertVIndexToDSIndex(i);
            if (!this.isItemVisible(n5)) continue;
            int n6 = this._itemPositions[n5];
            int n7 = this.getItemSize(n5);
            if (n < n6 || n >= n6 + n7 + n4) continue;
            return n5;
        }
        return -1;
    }

    final int doLayout() {
        this._itemSize = this._layout();
        return this._itemSize;
    }

    public final int getTotalItemSize() {
        return this._itemSize;
    }

    public final void setDefaultItemSize(int n) {
        this._defaultSize = n;
    }

    public final int getDefaultItemSize() {
        return this._defaultSize;
    }

    public final void itemsAdded(int n, int n2) {
        if (this._itemPositions != null) {
            this._itemPositions = this._addToArray(this._itemPositions, n, n2);
        }
        if (this._itemSizes != null) {
            this._itemSizes = this._addToArray(this._itemSizes, n, n2);
            for (int i = n; i < n + n2; ++i) {
                this._itemSizes[i] = -1;
            }
        }
        if (this._dataSourceToVisible != null) {
            this._dataSourceToVisible = null;
            this._visibleToDataSource = null;
        }
        this._items += n2;
        this._visibleItems += n2;
    }

    public final void itemsRemoved(int n, int n2) {
        if (this._itemPositions != null) {
            this._itemPositions = this._removeFromArray(this._itemPositions, n, n2);
        }
        if (this._itemSizes != null) {
            this._itemSizes = this._removeFromArray(this._itemSizes, n, n2);
        }
        this._items -= n2;
        this._visibleItems = 0;
        for (int i = 0; i < this._items; ++i) {
            if (!this.isItemVisible(i)) continue;
            ++this._visibleItems;
        }
        if (this._dataSourceToVisible != null) {
            this._dataSourceToVisible = null;
            this._visibleToDataSource = null;
        }
    }

    public final void setItemVisible(int n, boolean bl) {
        if (this.isItemVisible(n) == bl) {
            return;
        }
        if (this._itemPositions == null) {
            this._createItemPositions();
        }
        if (!bl) {
            this._itemPositions[n] = -1;
            --this._visibleItems;
        } else {
            this._itemPositions[n] = 0;
            ++this._visibleItems;
        }
    }

    public final boolean isItemVisible(int n) {
        if (this._itemPositions == null) {
            return true;
        }
        return this._itemPositions[n] != -1;
    }

    public final void setItemVisibleIndex(int n, int n2) {
        int n3;
        int n4;
        if (this._visibleToDataSource == null) {
            if (n == n2) {
                return;
            }
            this._visibleToDataSource = new int[this._items];
            this._dataSourceToVisible = new int[this._items];
            if (this._direction == 2) {
                for (n4 = 0; n4 < this._items; ++n4) {
                    this._visibleToDataSource[n4] = this._items - n4 - 1;
                    this._dataSourceToVisible[n4] = this._items - n4 - 1;
                }
            } else {
                for (n4 = 0; n4 < this._items; ++n4) {
                    this._visibleToDataSource[n4] = n4;
                    this._dataSourceToVisible[n4] = n4;
                }
            }
            if (this._itemPositions == null) {
                this._createItemPositions();
            }
        }
        if ((n3 = this._dataSourceToVisible[n]) == n2) {
            return;
        }
        if (n3 > n2) {
            n4 = n2;
            int n5 = n3 - n4;
            System.arraycopy(this._visibleToDataSource, n4, this._visibleToDataSource, n4 + 1, n5);
        } else {
            n4 = n3 + 1;
            int n6 = n2 - n3;
            System.arraycopy(this._visibleToDataSource, n4, this._visibleToDataSource, n4 - 1, n6);
        }
        this._visibleToDataSource[n2] = n;
        this._updateDataSourceToVisible();
    }

    public final void setItemSize(int n, int n2) {
        if (this._itemSizes == null) {
            this._createItemSizes();
        }
        this._itemSizes[n] = n2;
    }

    public final int getItemSize(int n) {
        if (this._itemSizes == null) {
            return this._defaultSize;
        }
        int n2 = this._itemSizes[n];
        return n2 == -1 ? this._defaultSize : n2;
    }

    public final void setSeparatorSize(int n) {
        this._separatorSize = n;
    }

    public final int getSeparatorSize() {
        return this._separatorSize;
    }

    public final int getVisibleItemCount() {
        return this._visibleItems;
    }

    public final int convertDSIndexToVIndex(int n) {
        if (this._dataSourceToVisible == null) {
            if (this._direction == 2) {
                return this._items - n - 1;
            }
            return n;
        }
        return this._dataSourceToVisible[n];
    }

    public final int convertVIndexToDSIndex(int n) {
        if (this._visibleToDataSource == null) {
            if (this._direction == 2) {
                return this._items - n - 1;
            }
            return n;
        }
        return this._visibleToDataSource[n];
    }

    public boolean hasOrderChanged() {
        return this._visibleToDataSource != null;
    }

    public final void setReadingDirection(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException();
        }
        if (this._direction == n) {
            return;
        }
        this._direction = n;
        if (this._items != 0 && this._visibleToDataSource != null) {
            for (int i = 0; i <= this._items / 2; ++i) {
                int n2 = this._visibleToDataSource[i];
                this._visibleToDataSource[i] = this._visibleToDataSource[this._items - i - 1];
                this._visibleToDataSource[this._items - i - 1] = n2;
            }
            this._updateDataSourceToVisible();
        }
        this._layout();
    }

    private int[] _addToArray(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 + n2];
        if (n != 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n != n3) {
            System.arraycopy(nArray, n, nArray2, n + n2, n3 - n);
        }
        return nArray2;
    }

    private int[] _removeFromArray(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3 - n2];
        if (n != 0) {
            System.arraycopy(nArray, 0, nArray2, 0, n);
        }
        if (n3 - n2 != n) {
            System.arraycopy(nArray, n + n2, nArray2, n, n3 - (n + n2));
        }
        return nArray2;
    }

    private void _updateDataSourceToVisible() {
        int n = 0;
        while (n < this._items) {
            int n2 = this._visibleToDataSource[n];
            this._dataSourceToVisible[n2] = n++;
        }
    }

    private void _updateVisibleToDataSource() {
        int n = 0;
        while (n < this._items) {
            int n2 = this._dataSourceToVisible[n];
            this._visibleToDataSource[n2] = n++;
        }
    }

    private void _createItemSizes() {
        this._itemSizes = new int[this._items];
        for (int i = 0; i < this._items; ++i) {
            this._itemSizes[i] = -1;
        }
    }

    private void _createItemPositions() {
        this._itemPositions = new int[this._items];
    }

    private int _layout() {
        if (this._itemSizes == null && this._itemPositions == null) {
            if (this._defaultSize == 0) {
                return 0;
            }
            return (this._defaultSize + this._separatorSize) * this._visibleItems;
        }
        if (this._itemPositions == null) {
            this._createItemPositions();
        }
        int n = 0;
        int n2 = this._separatorSize == 0 ? 0 : this._separatorSize;
        for (int i = 0; i < this._items; ++i) {
            int n3 = this.convertVIndexToDSIndex(i);
            if (!this.isItemVisible(n3)) {
                this._itemPositions[n3] = -1;
                continue;
            }
            this._itemPositions[n3] = n;
            n += this.getItemSize(n3);
            n += n2;
        }
        return n;
    }
}

