/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.graphics;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

class ImageLoader
implements ImageObserver {
    private Image _image;
    private int _status;

    public ImageLoader(Image image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this._image = image;
    }

    public synchronized void start() {
        Toolkit.getDefaultToolkit().prepareImage(this._image, -1, -1, this);
    }

    public synchronized boolean waitFor() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this._status |= toolkit.checkImage(this._image, -1, -1, this);
        while ((this._status & 0xF0) == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return (this._status & 0x30) != 0;
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        this._status |= n;
        if ((n & 0xF0) != 0) {
            this.notifyAll();
            return false;
        }
        return true;
    }
}

