/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dialog.directory;

import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.MessageFormat;
import oracle.ewt.alert.Alert;
import oracle.ewt.dialog.directory.DirectoryDialog;
import oracle.ewt.dialog.directory.DirectoryDrive;
import oracle.ewt.dialog.directory.DirectoryTree;
import oracle.ewt.dialog.directory.FileUtils;
import oracle.ewt.lwAWT.LWChoice;

class DriveChangeListener
implements ItemListener {
    private DirectoryDialog _dialog;
    private DirectoryTree _dirTree;
    private static String _NO_DIRECTORY_KEY = "NO_DIRECTORY";
    private static String _KEY_NO_DIR_TITLE = "TITLE_NO_DIRECTORY";

    public DriveChangeListener(DirectoryDialog directoryDialog, DirectoryTree directoryTree) {
        this._dialog = directoryDialog;
        this._dirTree = directoryTree;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getID() == 701 && itemEvent.getStateChange() == 1 && itemEvent.getSource() instanceof LWChoice) {
            LWChoice lWChoice = (LWChoice)itemEvent.getSource();
            DirectoryDrive[] directoryDriveArray = this._dialog.getDrives();
            DirectoryDrive directoryDrive = directoryDriveArray[lWChoice.getSelectedIndex()];
            if (directoryDrive.exists()) {
                this._dirTree.setDirectory(directoryDrive, false);
            } else {
                this._runDirectoryAlert(_NO_DIRECTORY_KEY, directoryDrive);
                File file = this._dirTree.getRootDirectory();
                for (int i = 0; i < directoryDriveArray.length; ++i) {
                    if (!FileUtils.areRootDirectoriesEqual(file, directoryDriveArray[i])) continue;
                    lWChoice.select(i);
                    break;
                }
            }
        }
    }

    private void _runDirectoryAlert(String string, File file) {
        String string2 = System.getProperty("java.version");
        String string3 = System.getProperty("os.name");
        if (string2 != null && string2.startsWith("1.3") && string3 != null && string3.indexOf("Windows") != -1) {
            return;
        }
        Alert alert = new Alert((Frame)this._dialog.getParent(), this._getDirectoryMessage(string, file), 0, 1);
        alert.setTitle(this._dialog._getMessage(_KEY_NO_DIR_TITLE));
        alert.setCenterOver(this._dialog);
        alert.runAlert();
    }

    private String _getDirectoryMessage(String string, File file) {
        String string2 = this._dialog._getMessage(string);
        Object[] objectArray = new Object[]{file.getPath()};
        return MessageFormat.format(string2, objectArray);
    }
}

