/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dialog.directory;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.accessibility.AccessibleContext;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeRootItem;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.dTree.DTreeSimpleParent;
import oracle.ewt.dTree.DTreeSimpleRoot;
import oracle.ewt.dialog.directory.DirectoryDialog;
import oracle.ewt.dialog.directory.DirectoryDrive;
import oracle.ewt.dialog.directory.DirectoryFilter;
import oracle.ewt.dialog.directory.DirectoryItem;
import oracle.ewt.dialog.directory.DirectoryParentItemFactory;
import oracle.ewt.dialog.directory.DirectoryRootItem;
import oracle.ewt.dialog.directory.FileDataSource;
import oracle.ewt.dialog.directory.FileUtils;
import oracle.ewt.plaf.ComponentUI;
import oracle.ewt.plaf.TreeUI;

class DirectoryTree
extends DTree {
    public static final String ROOT_DIRECTORY_PROPERTY = "rootDirectory";
    public static final int SET_SUCCEEDED = 0;
    public static final int SET_WRITE_FAILED = 1;
    public static final int SET_CREATE_FAILED = 2;
    public static final int SET_FAILED = 3;
    public static final int SET_PARTIAL_SUCCESS = 4;
    private DirectoryDialog _dialog;
    private File _directory;
    private DirectoryItem _rootDirectoryItem;
    private PropertyChangeSupport _propSupport;
    private Image _directoryImage;

    public DirectoryTree(DirectoryDialog directoryDialog) {
        this._dialog = directoryDialog;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this._propSupport == null) {
            this._propSupport = new PropertyChangeSupport(this);
        }
        this._propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final File getDirectory() {
        DirectoryItem directoryItem = this.getDirectoryItem();
        if (directoryItem == null) {
            return null;
        }
        return directoryItem.getDirectory();
    }

    public DirectoryDialog getDirectoryDialog() {
        return this._dialog;
    }

    public DirectoryItem getDirectoryItem() {
        DTreeItem dTreeItem;
        DTreeItem dTreeItem2;
        DTreeRange dTreeRange;
        DTreeSelection dTreeSelection = this.getSelection();
        DTreeRangeSet dTreeRangeSet = dTreeSelection.getSelectionRanges();
        if (dTreeRangeSet.getCount() == 1 && (dTreeRange = dTreeRangeSet.getRange(0)).getCount() == 1 && (dTreeItem2 = (dTreeItem = dTreeRange.getParent()).getItem(dTreeRange.getStartIndex())) instanceof DirectoryItem) {
            DirectoryItem directoryItem = (DirectoryItem)dTreeItem2;
            return directoryItem;
        }
        return null;
    }

    public File getRootDirectory() {
        return this._rootDirectoryItem == null ? null : this._rootDirectoryItem.getDirectory();
    }

    public int setDirectory(File file, boolean bl) {
        DTreeItem dTreeItem;
        File file2;
        File[] fileArray = this._getPaths(file);
        if (fileArray.length == 0) {
            return 3;
        }
        DirectoryDrive[] directoryDriveArray = this._dialog.getDrives();
        if (!FileUtils.isDirectory(file) && directoryDriveArray != null && directoryDriveArray.length > 0 && !FileUtils.__isWindowsDrive(fileArray[0].getPath()) && (file2 = this._findDirectory(file, fileArray, directoryDriveArray)) != null) {
            file = file2;
            fileArray = this._getPaths(file);
        }
        file2 = fileArray[0];
        File file3 = this.getRootDirectory();
        if (!file2.exists()) {
            if (bl && !file2.mkdir()) {
                return 2;
            }
            return 3;
        }
        if (file3 == null || !FileUtils.areRootDirectoriesEqual(file3, file2)) {
            FileDataSource fileDataSource = new FileDataSource(this._dialog, file2, DirectoryFilter.getInstance());
            this._rootDirectoryItem = new DirectoryRootItem(file2.getPath(), this.__getDirectoryIcon(), fileDataSource, DirectoryParentItemFactory.getInstance());
            dTreeItem = new DTreeSimpleRoot();
            ((DTreeSimpleParent)dTreeItem).addItem(this._rootDirectoryItem);
            this.setRoot((DTreeRootItem)dTreeItem);
            if (this._propSupport != null) {
                this._propSupport.firePropertyChange(ROOT_DIRECTORY_PROPERTY, file3, file2);
            }
        }
        dTreeItem = this._rootDirectoryItem;
        for (int i = 1; i < fileArray.length; ++i) {
            int n;
            DirectoryItem directoryItem;
            File file4;
            File file5 = fileArray[i];
            dTreeItem.setExpanded(true);
            if (!(!bl && !file5.exists() || (file4 = (directoryItem = dTreeItem).createDirectory(FileUtils.getName(file5))) != null && file4.exists())) {
                if (!fileArray[i - 1].canWrite()) {
                    return 1;
                }
                return 2;
            }
            int n2 = dTreeItem.getItemCount();
            for (n = 0; n < n2; ++n) {
                File file6;
                DTreeItem dTreeItem2 = dTreeItem.getItem(n);
                if (!(dTreeItem2 instanceof DirectoryItem) || !FileUtils.areDirectoriesEqual(file6 = ((DirectoryItem)dTreeItem2).getDirectory(), file5)) continue;
                dTreeItem = dTreeItem2;
                break;
            }
            if (n != n2) continue;
            this._selectItem(dTreeItem);
            return 4;
        }
        if (dTreeItem != null) {
            this._selectItem(dTreeItem);
        }
        return 0;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this._propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAccessibleName(String string) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.setAccessibleName(string);
        }
    }

    public AccessibleContext createAccessibleContext() {
        AccessibleContext accessibleContext = super.createAccessibleContext();
        accessibleContext.setAccessibleName(this._dialog.getMessage());
        return accessibleContext;
    }

    protected void setUI(ComponentUI componentUI) {
        super.setUI((TreeUI)componentUI);
        this._directoryImage = null;
    }

    Image __getDirectoryIcon() {
        if (this._directoryImage == null) {
            this._directoryImage = this.getUIDefaults().getImage("FileChooser.folder");
        }
        return this._directoryImage;
    }

    private File _findDirectory(File file, File[] fileArray, DirectoryDrive[] directoryDriveArray) {
        String string = fileArray[0].getPath();
        if (string.length() == 1 && string.charAt(0) == File.separatorChar) {
            if (fileArray.length > 1) {
                string = fileArray[1].getPath();
            } else {
                return null;
            }
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.charAt(0) == File.separatorChar) {
            string = string.substring(1);
        }
        for (int i = 0; i < directoryDriveArray.length; ++i) {
            File file2;
            String string2 = directoryDriveArray[i].getPath();
            if (!FileUtils.__hasTrailingSeparator(string2)) {
                string2 = FileUtils.__addTrailingSeparator(string2);
            }
            if (this._isSuppressedDrive(string2) || !FileUtils.isDirectory(file2 = new File(string2 + string))) continue;
            String string3 = file.getPath();
            if (string3.charAt(0) == File.separatorChar) {
                string3 = string3.substring(1);
            }
            return new File(string2 + string3);
        }
        return null;
    }

    private boolean _isSuppressedDrive(String string) {
        return string.equals("A:\\") || string.equals("B:\\");
    }

    private File[] _getPaths(File file) {
        boolean bl = false;
        File[] fileArray = new File[]{};
        while (file != null) {
            File[] fileArray2 = new File[fileArray.length + 1];
            System.arraycopy(fileArray, 0, fileArray2, 1, fileArray.length);
            fileArray = fileArray2;
            fileArray[0] = file;
            String string = FileUtils.getParent(file);
            if (string == null) break;
            file = new File(string);
        }
        return fileArray;
    }

    private void _selectItem(DTreeItem dTreeItem) {
        dTreeItem.setExpanded(true);
        DTreeSelection dTreeSelection = this.getSelection();
        dTreeSelection.selectItem(dTreeItem);
        this.makeVisible(dTreeItem);
    }
}

