/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import java.util.Enumeration;
import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemEvent;
import oracle.ewt.dTree.DTreeRange;
import oracle.ewt.dTree.DTreeRangeSet;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.event.Cancelable;

public class DTreeMultipleSelection
implements DTreeSelection {
    private DTree _tree;
    private DTreeRangeSet _ranges;
    private DTreeItem _anchor;

    public DTreeMultipleSelection() {
        this._setRangeSet(new DTreeRangeSet());
    }

    public void setTree(DTree dTree) {
        if (dTree != this._tree) {
            this._setRangeSet(null);
            this._tree = dTree;
            this._setRangeSet(new DTreeRangeSet());
            this._anchor = null;
        }
    }

    public boolean extendSelection(DTreeItem dTreeItem) {
        if (this._tree != null && this._tree.getRoot() == dTreeItem) {
            return false;
        }
        DTreeRange[] dTreeRangeArray = new DTreeRange[1];
        int n = 0;
        DTreeItem dTreeItem2 = this._getAnchor();
        DTreeItem dTreeItem3 = null;
        DTreeItem dTreeItem4 = null;
        if (DTree.isItemBefore(dTreeItem2, dTreeItem)) {
            dTreeItem3 = dTreeItem2;
            dTreeItem4 = dTreeItem;
        } else {
            dTreeItem3 = dTreeItem;
            dTreeItem4 = dTreeItem2;
        }
        Enumeration enumeration = this._tree.getExpandedEnumeration();
        while (enumeration.hasMoreElements()) {
            Object object;
            DTreeItem dTreeItem5 = (DTreeItem)enumeration.nextElement();
            if (dTreeItem4 == dTreeItem5 || DTree.isItemBefore(dTreeItem4, dTreeItem5) || DTree.isItemBefore(dTreeItem5, dTreeItem3) && !DTree.isItemDescendent(dTreeItem3, dTreeItem5)) continue;
            int n2 = 0;
            int n3 = 0;
            if (dTreeItem3 == dTreeItem5 || DTree.isItemBefore(dTreeItem3, dTreeItem5)) {
                n2 = 0;
            } else if (dTreeItem3.getParent() == dTreeItem5) {
                n2 = dTreeItem3.getIndex();
            } else {
                object = dTreeItem3.getParent();
                while (object.getParent() != dTreeItem5) {
                    object = object.getParent();
                }
                n2 = object.getIndex() + 1;
            }
            if (!DTree.isItemDescendent(dTreeItem4, dTreeItem5)) {
                n3 = dTreeItem5.getItemCount() - n2;
            } else {
                object = dTreeItem4;
                while (object.getParent() != dTreeItem5) {
                    object = object.getParent();
                }
                n3 = object.getIndex() - n2 + 1;
            }
            object = new DTreeRange(dTreeItem5, n2, n3);
            if (n == dTreeRangeArray.length) {
                DTreeRange[] dTreeRangeArray2 = new DTreeRange[n * 2];
                System.arraycopy(dTreeRangeArray, 0, dTreeRangeArray2, 0, n);
                dTreeRangeArray = dTreeRangeArray2;
            }
            dTreeRangeArray[n] = object;
            ++n;
        }
        if (dTreeRangeArray.length != n) {
            DTreeRange[] dTreeRangeArray3 = new DTreeRange[n];
            System.arraycopy(dTreeRangeArray, 0, dTreeRangeArray3, 0, n);
            dTreeRangeArray = dTreeRangeArray3;
        }
        DTreeRangeSet dTreeRangeSet = new DTreeRangeSet();
        dTreeRangeSet.addRanges(dTreeRangeArray);
        return this._setSelectionRanges(dTreeRangeSet, dTreeItem);
    }

    public boolean getHasSelection() {
        return this._ranges.getCount() > 0;
    }

    public DTreeRangeSet getSelectionRanges() {
        return (DTreeRangeSet)this._ranges.clone();
    }

    public DTree getTree() {
        return this._tree;
    }

    public boolean isSelected(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = dTreeItem.getParent();
        int n = dTreeItem.getIndex();
        for (int i = 0; i < this._ranges.getCount(); ++i) {
            DTreeRange dTreeRange = this._ranges.getRange(i);
            if (!dTreeRange.contains(dTreeItem2, n)) continue;
            return true;
        }
        return false;
    }

    public void itemCollapsing(DTreeItemEvent dTreeItemEvent) {
        DTreeItem dTreeItem = dTreeItemEvent.getItem();
        DTreeRangeSet dTreeRangeSet = this.getSelectionRanges();
        DTreeRangeSet dTreeRangeSet2 = new DTreeRangeSet();
        for (int i = 0; i < dTreeRangeSet.getCount(); ++i) {
            DTreeRange dTreeRange = dTreeRangeSet.getRange(i);
            if (DTree.isItemDescendent(dTreeRange.getParent(), dTreeItem)) continue;
            dTreeRangeSet2.addRange(dTreeRange);
        }
        if (!this.setSelectionRanges(dTreeRangeSet2)) {
            ((Cancelable)((Object)dTreeItemEvent)).cancel();
        }
    }

    public void itemsAdded(DTreeItem dTreeItem, int n, int n2) {
    }

    public void itemsRemoved(DTreeItem dTreeItem, int n, int n2) {
    }

    public boolean selectItem(DTreeItem dTreeItem) {
        boolean bl;
        if (this._tree != null && this._tree.getRoot() == dTreeItem) {
            return false;
        }
        DTreeRangeSet dTreeRangeSet = new DTreeRangeSet();
        if (dTreeItem != null) {
            dTreeRangeSet.addRange(new DTreeRange(dTreeItem.getParent(), dTreeItem.getIndex(), 1));
        }
        if (bl = this._setSelectionRanges(dTreeRangeSet, dTreeItem)) {
            this._setAnchor(dTreeItem);
        }
        return bl;
    }

    public boolean setSelectionRanges(DTreeRangeSet dTreeRangeSet) {
        return this._setSelectionRanges(dTreeRangeSet, null);
    }

    public boolean toggleItem(DTreeItem dTreeItem) {
        if (this._tree != null && this._tree.getRoot() == dTreeItem) {
            return false;
        }
        DTreeRangeSet dTreeRangeSet = this.getSelectionRanges();
        DTreeRangeSet dTreeRangeSet2 = null;
        if (!this.isSelected(dTreeItem)) {
            dTreeRangeSet2 = this.getSelectionRanges();
            dTreeRangeSet2.addRange(new DTreeRange(dTreeItem.getParent(), dTreeItem.getIndex(), 1));
        } else {
            DTreeItem dTreeItem2 = dTreeItem.getParent();
            int n = dTreeItem.getIndex();
            dTreeRangeSet2 = new DTreeRangeSet();
            for (int i = 0; i < dTreeRangeSet.getCount(); ++i) {
                DTreeRange dTreeRange = dTreeRangeSet.getRange(i);
                if (!dTreeRange.contains(dTreeItem2, n)) {
                    dTreeRangeSet2.addRange(dTreeRange);
                    continue;
                }
                int n2 = dTreeRange.getStartIndex();
                int n3 = dTreeRange.getCount();
                if (n > n2) {
                    dTreeRangeSet2.addRange(new DTreeRange(dTreeItem2, n2, n - n2));
                }
                if (n >= n2 + n3 - 1) continue;
                dTreeRangeSet2.addRange(new DTreeRange(dTreeItem2, n + 1, n2 + n3 - (n + 1)));
            }
        }
        if (this._tree.selectionChanging(dTreeRangeSet, dTreeRangeSet2)) {
            return false;
        }
        this._setRangeSet(dTreeRangeSet2);
        this._setFocusedItem(dTreeItem);
        this._setAnchor(dTreeItem);
        this._tree.selectionChanged(dTreeRangeSet, dTreeRangeSet2);
        return true;
    }

    private DTreeItem _getAnchor() {
        if (this._anchor == null) {
            this._anchor = this._tree.getRoot();
        }
        return this._anchor;
    }

    private void _setAnchor(DTreeItem dTreeItem) {
        this._anchor = dTreeItem;
    }

    private void _setFocusedItem(DTreeItem dTreeItem) {
        if (dTreeItem != null) {
            DTree dTree = this.getTree();
            dTree.setFocusedItem(dTreeItem);
        }
    }

    private boolean _setSelectionRanges(DTreeRangeSet dTreeRangeSet, DTreeItem dTreeItem) {
        DTreeRangeSet dTreeRangeSet2 = this.getSelectionRanges();
        DTreeRangeSet dTreeRangeSet3 = (DTreeRangeSet)dTreeRangeSet.clone();
        if (dTreeRangeSet2.equals(dTreeRangeSet)) {
            return true;
        }
        if (this._tree.selectionChanging(dTreeRangeSet2, dTreeRangeSet3)) {
            return false;
        }
        this._setRangeSet(dTreeRangeSet3);
        this._setFocusedItem(dTreeItem);
        this._tree.selectionChanged(dTreeRangeSet2, dTreeRangeSet3);
        return true;
    }

    private void _setRangeSet(DTreeRangeSet dTreeRangeSet) {
        DTree dTree;
        if (dTreeRangeSet != this._ranges && (dTree = this.getTree()) != null) {
            if (this._ranges != null) {
                dTree.__removeRangeSet(this._ranges);
            }
            this._ranges = dTreeRangeSet;
            if (this._ranges != null) {
                dTree.__addRangeSet(this._ranges);
            }
        }
    }
}

