/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.color;

import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Locale;
import oracle.ewt.color.BaseColorEditor;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.spinBox.NumericSpinBox;
import oracle.ewt.spinBox.SpinBoxEvent;
import oracle.ewt.spinBox.SpinBoxListener;
import oracle.ewt.util.StringUtils;

class RGBComponent
extends BaseColorEditor {
    private static final Insets _INSETS = new Insets(0, 0, 3, 3);
    private static final String _KEY_RED = "COLORCHOOSER.RED_LABEL";
    private static final String _KEY_GREEN = "COLORCHOOSER.GREEN_LABEL";
    private static final String _KEY_BLUE = "COLORCHOOSER.BLUE_LABEL";
    private static final String _KEY_RED_DESC = "COLORCHOOSER.RED_DESCRIPTION";
    private static final String _KEY_GREEN_DESC = "COLORCHOOSER.GREEN_DESCRIPTION";
    private static final String _KEY_BLUE_DESC = "COLORCHOOSER.BLUE_DESCRIPTION";
    private boolean _ignoreEvents;
    private LWLabel _redLabel;
    private LWLabel _blueLabel;
    private LWLabel _greenLabel;
    private NumericSpinBox _red;
    private NumericSpinBox _green;
    private NumericSpinBox _blue;

    public RGBComponent() {
        Listener listener = new Listener();
        this._red = new NumericSpinBox(0, 255);
        this._red.addSpinBoxListener(listener);
        this._green = new NumericSpinBox(0, 255);
        this._green.addSpinBoxListener(listener);
        this._blue = new NumericSpinBox(0, 255);
        this._blue.addSpinBoxListener(listener);
        this._redLabel = new LWLabel("");
        this._redLabel.setLabelFor(this._red);
        this._greenLabel = new LWLabel("");
        this._greenLabel.setLabelFor(this._green);
        this._blueLabel = new LWLabel("");
        this._blueLabel.setLabelFor(this._blue);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = _INSETS;
        gridBagLayout.setConstraints(this._redLabel, gridBagConstraints);
        this.add(this._redLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._red, gridBagConstraints);
        this.add(this._red);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._greenLabel, gridBagConstraints);
        this.add(this._greenLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._green, gridBagConstraints);
        this.add(this._green);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this._blueLabel, gridBagConstraints);
        this.add(this._blueLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this._blue, gridBagConstraints);
        this.add(this._blue);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._redLabel.setEnabled(bl);
        this._blueLabel.setEnabled(bl);
        this._greenLabel.setEnabled(bl);
        this._red.setEnabled(bl);
        this._green.setEnabled(bl);
        this._blue.setEnabled(bl);
    }

    protected void colorChanged(Color color) {
        this._ignoreEvents = true;
        int[] nArray = ColorUtils.colorToRGB(color);
        this._red.setIntValue(nArray[0]);
        this._green.setIntValue(nArray[1]);
        this._blue.setIntValue(nArray[2]);
        this._ignoreEvents = false;
    }

    protected void updateLabels(Locale locale) {
        String string = RGBComponent.__getTranslatedString(locale, _KEY_RED);
        this._redLabel.setText(StringUtils.stripMnemonic(string));
        this._redLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        string = RGBComponent.__getTranslatedString(locale, _KEY_GREEN);
        this._greenLabel.setText(StringUtils.stripMnemonic(string));
        this._greenLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
        string = RGBComponent.__getTranslatedString(locale, _KEY_BLUE);
        this._blueLabel.setText(StringUtils.stripMnemonic(string));
        this._blueLabel.setMnemonicIndex(StringUtils.getMnemonicIndex(string));
    }

    protected void updateAccessibleNames() {
        String string = this.__getTranslatedString(_KEY_RED_DESC);
        this._red.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_GREEN_DESC);
        this._green.getAccessibleContext().setAccessibleName(string);
        string = this.__getTranslatedString(_KEY_BLUE_DESC);
        this._blue.getAccessibleContext().setAccessibleName(string);
    }

    private void _updateColor() {
        this.storeColor(ColorUtils.rgbToColor(this._red.getIntValue(), this._green.getIntValue(), this._blue.getIntValue()));
    }

    private class Listener
    implements SpinBoxListener {
        private Listener() {
        }

        public void spinBoxValueChanged(SpinBoxEvent spinBoxEvent) {
            if (!RGBComponent.this._ignoreEvents) {
                RGBComponent.this._updateColor();
            }
        }
    }
}

