/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.access;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.access.AccessibleUtils;

public class AccessibleComponentImpl
extends AccessibleContext
implements AccessibleComponent {
    private Component _component;
    private ContainerListener _accessibleContainerHandler;
    private static FocusListener _sAccessibleFocusHandler;
    private boolean _isFocusHandlerAdded;

    public AccessibleComponentImpl(Component component) {
        this._component = component;
        if (this._component instanceof Container) {
            this._accessibleContainerHandler = new AccessibleContainerHandler();
            ((Container)this._component).addContainerListener(this._accessibleContainerHandler);
        }
    }

    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.AWT_COMPONENT;
    }

    public AccessibleStateSet getAccessibleStateSet() {
        return AccessibleUtils.getAccessibleStateSet(this._component);
    }

    public Accessible getAccessibleParent() {
        if (this.accessibleParent != null) {
            return this.accessibleParent;
        }
        Container container = this._component.getParent();
        if (container instanceof Accessible) {
            return (Accessible)((Object)container);
        }
        return null;
    }

    public int getAccessibleIndexInParent() {
        return AccessibleUtils.getAccessibleIndexInParent(this._component);
    }

    public int getAccessibleChildrenCount() {
        return AccessibleUtils.getAccessibleChildrenCount(this._component);
    }

    public Accessible getAccessibleChild(int n) {
        return AccessibleUtils.getAccessibleChild(this._component, n);
    }

    public Locale getLocale() {
        return this._component.getLocale();
    }

    public AccessibleComponent getAccessibleComponent() {
        return this;
    }

    public Color getBackground() {
        return this._component.getBackground();
    }

    public void setBackground(Color color) {
        this._component.setBackground(color);
    }

    public Color getForeground() {
        return this._component.getForeground();
    }

    public void setForeground(Color color) {
        this._component.setForeground(color);
    }

    public Cursor getCursor() {
        Cursor cursor = this._component.getCursor();
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        return cursor;
    }

    public void setCursor(Cursor cursor) {
        this._component.setCursor(cursor);
    }

    public Font getFont() {
        return this._component.getFont();
    }

    public void setFont(Font font) {
        this._component.setFont(font);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this._component.getFontMetrics(font);
    }

    public boolean isEnabled() {
        return this._component.isEnabled();
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        this._component.setEnabled(bl);
        if (bl != bl2) {
            this._firePropertyChange(bl, AccessibleState.ENABLED);
        }
    }

    public boolean isVisible() {
        return this._component.isVisible();
    }

    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        this._component.setVisible(bl);
        if (bl != bl2) {
            this._firePropertyChange(bl, AccessibleState.VISIBLE);
        }
    }

    public boolean isShowing() {
        return this._component.isShowing();
    }

    public boolean contains(Point point) {
        return this._component.contains(point);
    }

    public Point getLocationOnScreen() {
        if (this._component.isShowing()) {
            return this._component.getLocationOnScreen();
        }
        return null;
    }

    public Point getLocation() {
        return this._component.getLocation();
    }

    public void setLocation(Point point) {
        this._component.setLocation(point);
    }

    public Rectangle getBounds() {
        return this._component.getBounds();
    }

    public void setBounds(Rectangle rectangle) {
        this._component.setBounds(rectangle);
    }

    public Dimension getSize() {
        return this._component.getSize();
    }

    public void setSize(Dimension dimension) {
        this._component.setSize(dimension);
    }

    public Accessible getAccessibleAt(Point point) {
        return AccessibleUtils.getAccessibleAt(this._component, point);
    }

    public boolean isFocusTraversable() {
        return this._component.isFocusTraversable();
    }

    public void requestFocus() {
        this._component.requestFocus();
    }

    public void addFocusListener(FocusListener focusListener) {
        this._component.addFocusListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this._component.removeFocusListener(focusListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (!this._isFocusHandlerAdded) {
            Component component = this.getComponent();
            component.addFocusListener(AccessibleComponentImpl._sGetAccessibleFocusHandler());
            this._isFocusHandlerAdded = true;
        }
        super.addPropertyChangeListener(propertyChangeListener);
    }

    protected Component getComponent() {
        return this._component;
    }

    private static FocusListener _sGetAccessibleFocusHandler() {
        if (_sAccessibleFocusHandler == null) {
            _sAccessibleFocusHandler = new AccessibleFocusHandler();
        }
        return _sAccessibleFocusHandler;
    }

    private void _firePropertyChange(boolean bl, Object object) {
        this.firePropertyChange("AccessibleState", bl ? null : object, bl ? object : null);
    }

    private static class AccessibleFocusHandler
    implements FocusListener {
        private AccessibleFocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Accessible accessible = (Accessible)((Object)focusEvent.getComponent());
            AccessibleContext accessibleContext = accessible.getAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            Accessible accessible = (Accessible)((Object)focusEvent.getComponent());
            AccessibleContext accessibleContext = accessible.getAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }
    }

    private class AccessibleContainerHandler
    implements ContainerListener {
        private AccessibleContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof Accessible) {
                AccessibleComponentImpl.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)component)).getAccessibleContext());
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof Accessible) {
                AccessibleComponentImpl.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)component)).getAccessibleContext(), null);
            }
        }
    }
}

