/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.macros;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.macros.MacroHandler;
import oracle.ideimpl.macros.MacrosArb;

public class EnvMacroHandler
implements MacroHandler {
    private static Map<String, String> envvars;
    private static List<String> names;

    public EnvMacroHandler() {
        envvars = System.getenv();
        names = new ArrayList<String>(envvars.keySet());
    }

    @Override
    public String getQualifier() {
        return "env";
    }

    @Override
    public String getQualifierDescription() {
        return MacrosArb.get("ENVIRONMENT_VARS");
    }

    @Override
    public String getValue(Context context, String name) {
        return envvars.get(name);
    }

    @Override
    public String getDescription(Context context, String string) {
        return MacrosArb.get("NO_DESCRIPTION_AVAILABLE");
    }

    @Override
    public List<String> getNames(Context context) {
        return names;
    }

    @Override
    public List<String> getPathMacroNames(Context context) {
        return names;
    }

    @Override
    public boolean requiresContext(String name) {
        return false;
    }
}

