/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.tree.lazy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.AnimatedCellIcon;
import oracle.javatools.ui.tree.lazy.LazyParent;
import oracle.javatools.ui.tree.lazy.LazyParentNode;
import oracle.javatools.ui.tree.lazy.LazyProgressController;

public final class LazyProgressNode<T>
extends DefaultMutableTreeNode
implements TreeNode {
    public static final Icon PROCESSING_ICON = new AnimatedCellIcon(OracleIcons.getIcon((String)"nodeprocessing_anim.gif"));
    private SwingWorker<List<T>, Object> childWorker;
    private WorkerListener workerListener = new WorkerListener();
    private DefaultTreeModel treeModel;
    private LazyProgressController controller;
    private String progressText;
    private boolean fetching = false;

    LazyProgressNode(DefaultTreeModel treeModel, LazyParent lazyParent, LazyProgressController controller) {
        super(lazyParent);
        this.treeModel = treeModel;
        this.controller = controller;
    }

    @Override
    public boolean isLeaf() {
        if (!this.fetching) {
            this.fetchChildren();
        }
        return super.isLeaf();
    }

    private void fetchChildren() {
        this.fetching = true;
        LazyParent parent = (LazyParent)this.getUserObject();
        this.childWorker = parent.getChildWorker();
        if (this.childWorker == null) {
            return;
        }
        this.childWorker.execute();
        try {
            this.childWorker.get(250L, TimeUnit.MILLISECONDS);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LazyProgressNode.this.done();
                }
            });
        }
        catch (InterruptedException e) {
            this.fetching = false;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            if (this.controller != null) {
                this.controller.addFetchingNode(this);
            }
            this.childWorker.addPropertyChangeListener(this.workerListener);
        }
    }

    void cancel() {
        this.childWorker.cancel(true);
        this.fetching = false;
    }

    private void done() {
        this.childWorker.removePropertyChangeListener(this.workerListener);
        if (this.controller != null) {
            this.controller.removeFetchingNode(this);
        }
        if (this.childWorker.isCancelled()) {
            this.fetching = false;
            return;
        }
        try {
            MutableTreeNode parent = (MutableTreeNode)this.getParent();
            int i = 0;
            for (T child : this.childWorker.get()) {
                DefaultMutableTreeNode childNode = child instanceof LazyParent ? new LazyParentNode(this.treeModel, (LazyParent)child, this.controller) : new DefaultMutableTreeNode(child);
                this.treeModel.insertNodeInto(childNode, parent, i++);
            }
            this.treeModel.removeNodeFromParent(this);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String toString() {
        if (this.fetching && this.childWorker != null) {
            return "" + this.childWorker.getProgress() + "%";
        }
        return "Not Loading";
    }

    public int getProgress() {
        return this.childWorker != null ? this.childWorker.getProgress() : 0;
    }

    public String getProgressText() {
        return this.progressText;
    }

    private class WorkerListener
    implements PropertyChangeListener {
        private WorkerListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if ("state".equals(event.getPropertyName()) && SwingWorker.StateValue.DONE == event.getNewValue()) {
                LazyProgressNode.this.done();
                if (LazyProgressNode.this.controller != null) {
                    LazyProgressNode.this.controller.removeFetchingNode(LazyProgressNode.this);
                }
            }
            if ("progress".equals(event.getPropertyName())) {
                LazyProgressNode.this.treeModel.nodeChanged(LazyProgressNode.this);
            }
            if ("progressText".equals(event.getPropertyName())) {
                LazyProgressNode.this.progressText = (String)event.getNewValue();
                LazyProgressNode.this.treeModel.nodeChanged(LazyProgressNode.this);
            }
        }
    }
}

