/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.javatools.ui.AttributedStringBuilder;
import oracle.javatools.ui.SuperLabel;

public abstract class SuperTreeCellRenderer<T>
implements TreeCellRenderer {
    private static final Border DEFAULT_FOCUS_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("Tree.selectionBorderColor")), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    private static final Border DEFAULT_NO_FOCUS_BORDER;
    protected static Border noFocusBorder;
    protected static Border focusBorder;
    private SuperLabel label = new SuperLabel();
    private JLabel iconLabel = new JLabel();
    private JPanel content = new JPanel(new LayoutM());
    private Color textSelectionColor = UIManager.getColor("Tree.selectionForeground");
    private Color backgroundSelectionColor = UIManager.getColor("Tree.selectionBackground");

    public SuperTreeCellRenderer() {
        this.content.setOpaque(false);
        this.content.add((Component)this.iconLabel, "Before");
        this.content.add(this.label);
    }

    public void setTextSelectionColor(Color textSelectionColor) {
        this.textSelectionColor = textSelectionColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor != null ? this.textSelectionColor : Color.GREEN;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    @Override
    public final JComponent getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
        this.cellSetup(tree, value, isSelected, expanded, leaf, row, cellHasFocus);
        AttributedString text = this.getCellText(tree, value, isSelected, expanded, leaf, row, cellHasFocus);
        if (text == null) {
            this.label.setText("");
        } else {
            this.label.setAttributedText(text);
        }
        this.iconLabel.setIcon(this.getCellIcon(tree, value, isSelected, expanded, leaf, row, cellHasFocus));
        return this.content;
    }

    public abstract Icon getCellIcon(JTree var1, T var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);

    public abstract AttributedString getCellText(JTree var1, T var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);

    protected void cellSetup(JTree tree, T value, boolean selected, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
        this.label.setComponentOrientation(tree.getComponentOrientation());
        Color bg = null;
        Color fg = null;
        JTree.DropLocation dropLocation = tree.getDropLocation();
        fg = dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row ? this.getTextSelectionColor() : (selected ? this.getTextSelectionColor() : tree.getForeground());
        if (selected) {
            this.label.setBackground(bg == null ? this.getBackgroundSelectionColor() : bg);
            this.label.setForeground(fg == null ? this.getTextSelectionColor() : fg);
            this.label.setOpaque(true);
        } else {
            this.label.setBackground(tree.getBackground());
            this.label.setForeground(tree.getForeground());
            this.label.setOpaque(false);
        }
        if (value instanceof Icon) {
            this.iconLabel.setIcon((Icon)value);
            this.label.setText("");
        } else {
            this.iconLabel.setIcon(null);
            this.label.setText(value == null ? "" : value.toString());
        }
        this.label.setEnabled(tree.isEnabled());
        this.label.setFont(tree.getFont());
        Border border = null;
        border = cellHasFocus ? focusBorder : noFocusBorder;
        this.label.setBorder(border);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        JTree tree = new JTree();
        tree.setCellRenderer(new SuperTreeCellRenderer<DefaultMutableTreeNode>(){

            @Override
            public AttributedString getCellText(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
                Color color = Color.GREEN;
                if (row == 1) {
                    color = Color.BLUE;
                }
                if (row == 2) {
                    color = Color.RED;
                }
                if (selected) {
                    color = this.getTextSelectionColor();
                }
                String text = value.getUserObject().toString();
                AttributedStringBuilder asb = new AttributedStringBuilder(text, TextAttribute.FOREGROUND, color);
                HashMap<TextAttribute, Serializable> attrs = new HashMap<TextAttribute, Serializable>();
                attrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                attrs.put(TextAttribute.SIZE, Integer.valueOf(10));
                attrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_EXTRA_LIGHT);
                if (selected) {
                    attrs.put(TextAttribute.FOREGROUND, this.getTextSelectionColor());
                }
                asb.append(" (java.lang.fruit)", attrs);
                return asb.toAttributedString();
            }

            @Override
            public Icon getCellIcon(JTree tree, DefaultMutableTreeNode value, boolean selected, boolean expanded, boolean leaf, int row, boolean cellHasFocus) {
                if (leaf) {
                    return UIManager.getIcon("FileChooser.homeFolderIcon");
                }
                return null;
            }
        });
        tree.setRowHeight(18);
        f.add(new JScrollPane(tree));
        f.setSize(400, 600);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    static {
        noFocusBorder = DEFAULT_NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        focusBorder = DEFAULT_FOCUS_BORDER;
    }

    private class LayoutM
    implements LayoutManager {
        private final int iconTextGap = 2;

        private LayoutM() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension iconD = SuperTreeCellRenderer.this.iconLabel.getPreferredSize();
            Dimension textD = SuperTreeCellRenderer.this.label.getPreferredSize();
            return new Dimension(iconD.width + 2 + textD.width + 1, Math.max(iconD.height, textD.height));
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension iconD = SuperTreeCellRenderer.this.iconLabel.getMinimumSize();
            Dimension textD = SuperTreeCellRenderer.this.label.getMinimumSize();
            return new Dimension(iconD.width + 2 + textD.width + 1, Math.max(iconD.height, textD.height));
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension iconD = SuperTreeCellRenderer.this.iconLabel.getPreferredSize();
            Dimension textD = SuperTreeCellRenderer.this.label.getPreferredSize();
            int iconYOff = 0;
            int textYOff = 0;
            if (parent.getHeight() > textD.height) {
                textYOff = (parent.getHeight() - textD.height) / 2;
            }
            if (parent.getHeight() > iconD.height) {
                iconYOff = (parent.getHeight() - iconD.height) / 2;
            }
            SuperTreeCellRenderer.this.iconLabel.setBounds(0, iconYOff, iconD.width, iconD.height);
            SuperTreeCellRenderer.this.label.setBounds(iconD.width + 2, textYOff, textD.width, textD.height);
        }
    }
}

