/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.themes;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import oracle.javatools.ui.themes.Painter;

public final class LinearGradientPainter
implements Painter {
    private final int _direction;
    private final float[] _fractions;
    private final Color[] _colors;
    private BufferedImage _cache;

    public LinearGradientPainter(Color startColor, Color endColor, int direction) {
        this._direction = direction;
        this._fractions = new float[]{0.0f, 1.0f};
        this._colors = new Color[]{startColor, endColor};
    }

    public LinearGradientPainter(float[] fractions, Color[] colors, int direction) {
        this._direction = direction;
        this._fractions = fractions;
        this._colors = colors;
    }

    @Override
    public void paint(Graphics g, int x, int y, int w, int h) {
        boolean vertical;
        boolean bl = vertical = this._direction == 1;
        if (this._cache == null || (vertical ? this._cache.getHeight() != h : this._cache.getWidth() != w)) {
            this._cache = new BufferedImage(vertical ? 2 : w, vertical ? h : 2, 2);
            GradientPaint paint = new GradientPaint(0.0f, 0.0f, this._colors[0], vertical ? 0.0f : (float)w, vertical ? (float)h : 0.0f, this._colors[1], true);
            Graphics2D g2d = this._cache.createGraphics();
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, vertical ? 2 : w, vertical ? h : 2);
            g2d.dispose();
        }
        g.drawImage(this._cache, x, y, w, h, null);
    }

    public void paint(Graphics2D g2, Shape shape) {
        boolean vertical = this._direction == 1;
        Rectangle bounds = shape.getBounds();
        LinearGradientPaint paint = new LinearGradientPaint(0.0f, 0.0f, vertical ? 0.0f : (float)bounds.width, vertical ? (float)bounds.height : 0.0f, this._fractions, this._colors, MultipleGradientPaint.CycleMethod.REPEAT);
        Paint oldPaint = g2.getPaint();
        g2.setPaint(paint);
        g2.fill(shape);
        g2.setPaint(oldPaint);
    }

    public void draw(Graphics2D g2, Shape shape) {
        boolean vertical = this._direction == 1;
        Rectangle bounds = shape.getBounds();
        LinearGradientPaint paint = new LinearGradientPaint(0.0f, 0.0f, vertical ? 0.0f : (float)bounds.width, vertical ? (float)bounds.height : 0.0f, this._fractions, this._colors, MultipleGradientPaint.CycleMethod.REPEAT);
        Paint oldPaint = g2.getPaint();
        g2.setPaint(paint);
        g2.draw(shape);
        g2.setPaint(oldPaint);
    }
}

