/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.Action;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.javatools.ui.table.ColumnSelector;
import oracle.javatools.ui.table.ColumnSelectorScrollPaneLayout;
import oracle.javatools.ui.table.DisplayableTable;
import oracle.javatools.ui.table.EditableTableModel;
import oracle.javatools.ui.table.GenericTableCellRenderer;
import oracle.javatools.ui.table.GenericTableHeaderRenderer;
import oracle.javatools.ui.table.RolloverTableHandler;
import oracle.javatools.ui.table.SelectAllComponent;

public class TableHelper {
    private static final int _DC_THRESHOLD = 3;
    private static final int _MIN_COL_WIDTH = 5;
    private static final int _DEFAULT_ROW_HEIGHT = 19;
    private static final Dimension SORT_ICON_SIZE = new Dimension(9, 5);
    private static final String _COL_SEL_PROPERTY = "columnSelector";
    private static final String _NO_ENTRY_LABEL = "noEntryLabel";
    private static final String _PREV_PREF_SIZE = "__GT_No_Entry_Prev_Pref_Size";
    private static final String _PREF_SIZE_SET_FLAG = "__GT_No_Entry_Pref_Size_Flag";
    private static final String _RESIZE_COL_ON_DOUBLE_CLICK = "Resize_Column_On_Double_Click";
    private static final String _VISIBLE_ROW_COUNT = "visibleRowCount";
    private static final String _COLUMN_HEADER_SELECTION = "columnHeaderSelection";
    private static PropertyChangeListener _sColSelListener;
    private static PropertyChangeListener _sprefSizeChanger;
    private static MouseListener _sDoubleClickListener;
    private static MouseAdapter _sColHeaderSelector;
    private static PropertyChangeListener _sColHeaderChanger;
    private static Icon _sSortIconDown;
    private static Icon _sSortIconUp;
    private static TransferHandler _sPasteTableTransferHandler;
    private static TransferHandler _sTableTransferHandler;

    public static void setColumnSelectorAvailable(JTable table, boolean isAvailable) {
        boolean oldValue = TableHelper.isColumnSelectorAvailable(table);
        if (oldValue != isAvailable) {
            table.putClientProperty(_COL_SEL_PROPERTY, isAvailable);
            if (isAvailable) {
                TableHelper._sAddColumnSelector(table);
                table.addPropertyChangeListener("ancestor", TableHelper._sGetColumnSelectorListener());
            } else {
                TableHelper._sRemoveColumnSelector(table);
                table.removePropertyChangeListener("ancestor", TableHelper._sGetColumnSelectorListener());
            }
        }
    }

    public static boolean isColumnSelectorAvailable(JTable table) {
        return Boolean.TRUE.equals(table.getClientProperty(_COL_SEL_PROPERTY));
    }

    public static void setSelectColumnsAction(JTable table, Action selectColumn) {
        TableHelper.getColumnSelector(table).setSelectColumnsAction(selectColumn);
    }

    public static Action getSelectColumnsAction(JTable table) {
        return TableHelper.getColumnSelector(table).getSelectColumnsAction();
    }

    public static void setColumnSelectorActions(JTable table, Action ... actions) {
        TableHelper.getColumnSelector(table).setColumnSelectorActions(actions);
    }

    public static Action[] getColumnSelectorActions(JTable table) {
        return TableHelper.getColumnSelector(table).getColumnSelectorActions();
    }

    public static void setHiddenColumns(JTable table, int ... hiddenColumns) {
        ColumnSelector cs = TableHelper.getColumnSelector(table);
        cs.setHiddenColumns(hiddenColumns);
    }

    public static int[] getHiddenColumns(JTable table) {
        ColumnSelector cs = TableHelper.getColumnSelector(table);
        return cs.getHiddenColumns();
    }

    public static void setHiddenColumnsVisible(JTable table, int ... columns) {
        ColumnSelector cs = TableHelper.getColumnSelector(table);
        cs.setHiddenColumnsVisible(columns);
    }

    public static void setColumnSelectorToolTipText(JTable table, String text) {
        ColumnSelector cs = TableHelper.getColumnSelector(table);
        cs.setToolTipText(text);
    }

    public static String getColumnSelectorToolTipText(JTable table) {
        ColumnSelector cs = TableHelper.getColumnSelector(table);
        return cs.getToolTipText();
    }

    public static void setNoEntryInstructionText(final JTable table, String text) {
        if (text == null || "".equals(text)) {
            TableHelper._sRemoveNoEntryInstructionText(table);
        } else {
            JLabel label = (JLabel)table.getClientProperty(_NO_ENTRY_LABEL);
            if (label != null) {
                label.setText(text);
                label.setSize(label.getPreferredSize());
                return;
            }
            TableHelper._createNoEntryLabel(table, text);
            int count = table.getModel().getRowCount();
            if (count == 0) {
                TableHelper._sAddNoEntryInstructionText(table, text);
            }
            final TableModelListener modelListener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    int count = table.getModel().getRowCount();
                    if (count == 0) {
                        TableHelper._sAddNoEntryInstructionText(table, TableHelper.getNoEntryInstructionText(table));
                    } else {
                        TableHelper._sMakeNoEntryInvisible(table);
                    }
                }
            };
            table.getModel().addTableModelListener(modelListener);
            table.addPropertyChangeListener("model", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent pe) {
                    int count;
                    TableModel newModel;
                    TableModel oldModel = (TableModel)pe.getOldValue();
                    if (oldModel != null) {
                        oldModel.removeTableModelListener(modelListener);
                    }
                    if ((newModel = (TableModel)pe.getNewValue()) != null) {
                        newModel.addTableModelListener(modelListener);
                    }
                    if ((count = newModel.getRowCount()) == 0) {
                        TableHelper._sAddNoEntryInstructionText(table, TableHelper.getNoEntryInstructionText(table));
                    } else {
                        TableHelper._sMakeNoEntryInvisible(table);
                    }
                }
            });
        }
    }

    public static String getNoEntryInstructionText(JTable table) {
        JLabel label = (JLabel)table.getClientProperty(_NO_ENTRY_LABEL);
        if (label == null) {
            return null;
        }
        return label.getText();
    }

    public static void installGenericTableRenderer(JTable table) {
        table.setDefaultRenderer(Object.class, new GenericTableCellRenderer(table.getDefaultRenderer(Object.class)));
        table.setDefaultRenderer(Number.class, new GenericTableCellRenderer(table.getDefaultRenderer(Number.class)));
        table.setDefaultRenderer(Float.class, new GenericTableCellRenderer(table.getDefaultRenderer(Float.class)));
        table.setDefaultRenderer(Double.class, new GenericTableCellRenderer(table.getDefaultRenderer(Double.class)));
        table.setDefaultRenderer(Date.class, new GenericTableCellRenderer(table.getDefaultRenderer(Date.class)));
        table.setDefaultRenderer(Icon.class, new GenericTableCellRenderer(table.getDefaultRenderer(Icon.class)));
        table.setDefaultRenderer(ImageIcon.class, new GenericTableCellRenderer(table.getDefaultRenderer(ImageIcon.class)));
        table.setDefaultRenderer(Boolean.class, new GenericTableCellRenderer(table.getDefaultRenderer(Boolean.class)));
        int colCount = table.getColumnCount();
        TableColumnModel colModel = table.getColumnModel();
        for (int i = 0; i < colCount; ++i) {
            TableColumn tableColum = colModel.getColumn(i);
            TableCellRenderer renderer = tableColum.getCellRenderer();
            if (renderer == null) {
                renderer = table.getDefaultRenderer(table.getColumnClass(i));
            }
            if (renderer == null || renderer instanceof GenericTableCellRenderer) continue;
            tableColum.setCellRenderer(new GenericTableCellRenderer(renderer));
        }
        JTableHeader header = table.getTableHeader();
        if (header != null) {
            header.setDefaultRenderer(new GenericTableHeaderRenderer());
        }
    }

    public static void setResizeColumnOnDoubleClick(JTable table, boolean isOn) {
        if (isOn != TableHelper.isResizeColumnOnDoubleClick(table)) {
            JTableHeader tableHeader = table.getTableHeader();
            if (isOn && tableHeader.getResizingAllowed()) {
                table.putClientProperty(_RESIZE_COL_ON_DOUBLE_CLICK, isOn);
                tableHeader.addMouseListener(TableHelper._sGetResizeOnDoubleClickListener());
            } else {
                table.putClientProperty(_RESIZE_COL_ON_DOUBLE_CLICK, false);
                tableHeader.removeMouseListener(TableHelper._sGetResizeOnDoubleClickListener());
            }
        }
    }

    public static boolean isResizeColumnOnDoubleClick(JTable table) {
        return Boolean.TRUE.equals(table.getClientProperty(_RESIZE_COL_ON_DOUBLE_CLICK));
    }

    public static void sizeTableToContents(JTable table) {
        TableHelper.sizeTableToContents(table, null);
    }

    public static void sizeTableToContents(JTable table, Object[] prototypeValues) {
        TableColumnModel colModel = table.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            colModel.getColumn(i).setPreferredWidth(TableHelper.sizeColumnToContents(table, i, false, -1, prototypeValues));
        }
    }

    public static void sizeColumnToContents(JTable table, int col, int sampleSize) {
        TableColumn column = table.getColumnModel().getColumn(col);
        column.setPreferredWidth(TableHelper.sizeColumnToContents(table, col, false, sampleSize, null));
    }

    public static int getCellWidth(JTable table, Object value, int row, int col) {
        TableCellRenderer cellRenderer = table.getCellRenderer(row, col);
        if (cellRenderer != null && value != null) {
            return cellRenderer.getTableCellRendererComponent((JTable)table, (Object)value, (boolean)false, (boolean)false, (int)row, (int)col).getPreferredSize().width;
        }
        return 0;
    }

    public static void sizeColumnToMaximumWidth(JTable table, int x) {
        JTableHeader tableHeader = table.getTableHeader();
        int targetColumn = -1;
        TableColumnModel colModel = tableHeader.getColumnModel();
        for (int i = 0; i < colModel.getColumnCount(); ++i) {
            Rectangle columnRect = tableHeader.getHeaderRect(i);
            int cx = columnRect.x;
            if (x >= cx - 3 && x <= cx + 3 && i > 0) {
                targetColumn = i - 1;
                break;
            }
            cx = columnRect.x + columnRect.width;
            if (x < cx - 3 || x > cx + 3) continue;
            targetColumn = i;
            break;
        }
        if (targetColumn != -1) {
            int modelColumn = table.convertColumnIndexToModel(targetColumn);
            int maxWidth = 5;
            TableModel model = table.getModel();
            for (int i = 0; i < model.getRowCount(); ++i) {
                Object value = model.getValueAt(i, modelColumn);
                TableCellRenderer renderer = table.getCellRenderer(i, targetColumn);
                Component c = renderer.getTableCellRendererComponent(table, value, false, false, i, targetColumn);
                maxWidth = Math.max(c.getPreferredSize().width, maxWidth);
            }
            colModel.getColumn(targetColumn).setPreferredWidth(maxWidth);
            tableHeader.resizeAndRepaint();
        }
    }

    public static int sizeColumnToContents(JTable table, int col, boolean sortCol, int sampleSize, Object[] prototypeValues) {
        TableCellRenderer cellRenderer;
        int n;
        JTableHeader tableHeader = table.getTableHeader();
        TableColumnModel colModel = table.getColumnModel();
        TableColumn column = colModel.getColumn(col);
        int maxWidth = 5;
        int modelIndex = column.getModelIndex();
        TableCellRenderer headerRenderer = null;
        if (headerRenderer == null) {
            headerRenderer = column.getHeaderRenderer();
        }
        if (headerRenderer == null && tableHeader != null) {
            headerRenderer = tableHeader.getDefaultRenderer();
        }
        if (headerRenderer != null) {
            maxWidth = headerRenderer.getTableCellRendererComponent((JTable)table, (Object)column.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)col).getPreferredSize().width;
            if (sortCol) {
                maxWidth += TableHelper.SORT_ICON_SIZE.width + 5;
            }
        }
        TableModel tableModel = table.getModel();
        int n2 = n = sampleSize > -1 ? Math.min(sampleSize, table.getRowCount()) : table.getRowCount();
        if (prototypeValues != null && prototypeValues[col] != null && (cellRenderer = table.getDefaultRenderer(tableModel.getColumnClass(modelIndex))) != null) {
            maxWidth = Math.max(cellRenderer.getTableCellRendererComponent((JTable)table, (Object)prototypeValues[col], (boolean)false, (boolean)false, (int)0, (int)col).getPreferredSize().width, maxWidth);
        }
        for (int j = 0; j < n; ++j) {
            Object value = tableModel.getValueAt(j, col);
            maxWidth = Math.max(TableHelper.getCellWidth(table, value, j, col), maxWidth);
        }
        return maxWidth += table.getIntercellSpacing().width;
    }

    public static void setVisibleRows(JTable table, JScrollPane sp, int rows) {
        Dimension size = sp.getPreferredSize();
        size.height = table.getTableHeader().getPreferredSize().height + table.getInsets().top + table.getInsets().bottom + sp.getInsets().top + sp.getInsets().bottom;
        size.height += rows * table.getRowHeight() + table.getRowMargin();
        sp.setPreferredSize(size);
        sp.revalidate();
        Container parent = sp.getParent();
        if (parent instanceof JComponent) {
            ((JComponent)sp.getParent()).revalidate();
        } else {
            parent.invalidate();
            parent.validate();
        }
    }

    public static void setPreferredVisibleRowCount(JTable table, int visibleRowCount) {
        visibleRowCount = Math.max(visibleRowCount, -1);
        table.putClientProperty(_VISIBLE_ROW_COUNT, visibleRowCount);
        if (visibleRowCount == -1) {
            table.setPreferredScrollableViewportSize(null);
        } else {
            Dimension size = table.getPreferredSize();
            int actualCount = table.getRowCount();
            int height = 0;
            if (visibleRowCount > actualCount) {
                height += (visibleRowCount - actualCount) * table.getRowHeight();
                visibleRowCount = actualCount;
            }
            Rectangle r = table.getCellRect(visibleRowCount - 1, 0, true);
            size.height = height + r.y + r.height;
            table.setPreferredScrollableViewportSize(size);
        }
    }

    public static int getPreferredVisibleRowCount(JTable table) {
        return (Integer)table.getClientProperty(_VISIBLE_ROW_COUNT);
    }

    public static int getDefaultRowHeight() {
        return 19;
    }

    public static void setColumnHeaderSelectionEnabled(JTable table, boolean select) {
        JTableHeader colHeader = table.getTableHeader();
        if (select) {
            if (colHeader != null) {
                colHeader.addMouseListener(TableHelper._sGetColHeaderSelListener());
                colHeader.addMouseMotionListener(TableHelper._sGetColHeaderSelListener());
            }
            table.addPropertyChangeListener("tableHeader", TableHelper._sGetColHeaderChangeListener());
        } else {
            if (colHeader != null) {
                colHeader.removeMouseListener(TableHelper._sGetColHeaderSelListener());
                colHeader.removeMouseMotionListener(TableHelper._sGetColHeaderSelListener());
            }
            table.removePropertyChangeListener("tableHeader", TableHelper._sGetColHeaderChangeListener());
        }
        table.putClientProperty(_COLUMN_HEADER_SELECTION, select);
    }

    public static boolean isColumnHeaderSelectionEnabled(JTable table) {
        return Boolean.TRUE.equals(table.getClientProperty(_COLUMN_HEADER_SELECTION));
    }

    public static void setSelectAllEnabled(JTable table, JScrollPane pane, boolean enable) {
        if (enable) {
            pane.setCorner("UPPER_LEFT_CORNER", new SelectAllComponent(table));
        } else {
            Component comp = pane.getCorner("UPPER_LEFT_CORNER");
            if (comp instanceof SelectAllComponent) {
                SelectAllComponent selAll = (SelectAllComponent)comp;
                selAll.dispose();
                pane.setCorner("UPPER_LEFT_CORNER", null);
            }
        }
    }

    public static boolean isSelectAllEnabled(JTable table) {
        JScrollPane pane = TableHelper.getTableScrollPane(table);
        if (pane != null) {
            return pane.getCorner("UPPER_LEFT_CORNER") instanceof SelectAllComponent;
        }
        return false;
    }

    public static void setRolloverHighlightingEnabled(JTable table, boolean enable) {
        RolloverTableHandler.setRolloverHighlightingEnabled(table, enable);
    }

    public static boolean isRolloverHighlightingEnabled(JTable table) {
        return RolloverTableHandler.isRolloverHighlightingEnabled(table);
    }

    public static void installTableTransferHandler(JTable table, boolean supportsPaste) {
        if (supportsPaste) {
            table.setTransferHandler(TableHelper._sGetPasteTableTransferHandler());
        } else {
            table.setTransferHandler(TableHelper._sGetTableTransferHandler());
        }
    }

    public static String getTruncatedCellValue(JTable table, int row, int col) {
        int modelColumn = table.convertColumnIndexToModel(col);
        int modelRow = table.convertRowIndexToModel(row);
        Object o = table.getModel().getValueAt(modelRow, modelColumn);
        if (o != null) {
            TableCellRenderer renderer = table.getCellRenderer(row, col);
            Component c = renderer.getTableCellRendererComponent(table, o, false, false, row, col);
            Rectangle cellRect = table.getCellRect(row, col, false);
            Dimension rendererDim = c.getPreferredSize();
            if (cellRect.width < rendererDim.width) {
                String tip;
                String string = tip = c instanceof JLabel ? ((JLabel)c).getText() : o.toString();
                if (tip.length() != 0) {
                    return tip;
                }
            }
        }
        return null;
    }

    public static void stopCellEditing(JTable table) {
        TableCellEditor editor;
        if (table.isEditing() && (editor = table.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
    }

    public static Icon getSortIconUp() {
        if (_sSortIconUp == null) {
            _sSortIconUp = new SortIconUp();
        }
        return _sSortIconUp;
    }

    public static Icon getSortIconDown() {
        if (_sSortIconDown == null) {
            _sSortIconDown = new SortIconDown();
        }
        return _sSortIconDown;
    }

    static int getNoEntryDefaultHeight(JTable table) {
        return table.getRowHeight() * 2;
    }

    static void addColumn(JTable table, Object colName, Object[] columnData) {
        TableModel model = table.getModel();
        if (table.getAutoCreateColumnsFromModel()) {
            TableColumnModel colModel = table.getColumnModel();
            int colCount = colModel.getColumnCount();
            int[] newModelCols = new int[colCount + 1];
            for (int i = 0; i < colCount; ++i) {
                newModelCols[i] = colModel.getColumn(i).getModelIndex();
            }
            newModelCols[colCount] = model.getColumnCount();
            if (model instanceof EditableTableModel) {
                ((EditableTableModel)((Object)model)).addColumn(colName, columnData);
            } else {
                ((DefaultTableModel)model).addColumn(colName, columnData);
            }
            colCount = colModel.getColumnCount();
            TableColumn[] newColumns = new TableColumn[newModelCols.length];
            for (int i = 0; i < newColumns.length - 1; ++i) {
                newColumns[i] = colModel.getColumn(newModelCols[i]);
            }
            newColumns[newColumns.length - 1] = colModel.getColumn(colCount - 1);
            while (colModel.getColumnCount() > 0) {
                colModel.removeColumn(colModel.getColumn(0));
            }
            for (int jj = 0; jj < newColumns.length; ++jj) {
                table.addColumn(newColumns[jj]);
            }
        } else {
            if (model instanceof EditableTableModel) {
                ((EditableTableModel)((Object)model)).addColumn(null, null);
            } else {
                ((DefaultTableModel)model).addColumn(null);
            }
            TableColumn column = new TableColumn(model.getColumnCount() - 1);
            table.addColumn(column);
        }
    }

    static void removeColumn(JTable table, int[] modelIndices) {
        TableModel model = table.getModel();
        if (!(model instanceof EditableTableModel) || modelIndices == null || modelIndices.length == 0) {
            return;
        }
        if (table.getAutoCreateColumnsFromModel()) {
            int i;
            int i2;
            TableColumnModel colModel = table.getColumnModel();
            int colCount = colModel.getColumnCount();
            int[] newModelCols = new int[colCount - modelIndices.length];
            int remCount = 0;
            int k = 0;
            for (i2 = 0; i2 < colCount; ++i2) {
                int modelIndex = colModel.getColumn(i2).getModelIndex();
                boolean add = true;
                for (int j = 0; j < modelIndices.length; ++j) {
                    if (modelIndex != modelIndices[j]) continue;
                    add = false;
                    ++remCount;
                    break;
                }
                if (!add) continue;
                newModelCols[k++] = modelIndex - remCount;
            }
            for (i2 = modelIndices.length - 1; i2 >= 0; --i2) {
                int modelIndex = modelIndices[i2];
                ((EditableTableModel)((Object)model)).removeColumn(modelIndex);
            }
            colCount = colModel.getColumnCount();
            TableColumn[] newColumns = new TableColumn[newModelCols.length];
            for (i = 0; i < newColumns.length; ++i) {
                newColumns[i] = colModel.getColumn(newModelCols[i]);
            }
            while (colModel.getColumnCount() > 0) {
                colModel.removeColumn(colModel.getColumn(0));
            }
            for (i = 0; i < newColumns.length; ++i) {
                table.addColumn(newColumns[i]);
            }
        } else {
            for (int i = modelIndices.length - 1; i >= 0; --i) {
                int modelIndex = modelIndices[i];
                ((EditableTableModel)((Object)model)).removeColumn(modelIndex);
            }
        }
    }

    static JScrollPane getTableScrollPane(JTable table) {
        JScrollPane pane;
        JViewport viewport;
        Container sp;
        Container p = table.getParent();
        if (p instanceof JViewport && (sp = p.getParent()) instanceof JScrollPane && (viewport = (pane = (JScrollPane)sp).getViewport()) != null && viewport.getView() == table) {
            return pane;
        }
        return null;
    }

    static ColumnSelector getColumnSelector(JTable table) {
        ColumnSelector cs = (ColumnSelector)((Object)table.getClientProperty("__GT___ColumnSelector"));
        if (cs == null) {
            cs = new ColumnSelector(table);
            table.putClientProperty("__GT___ColumnSelector", (Object)cs);
        }
        return cs;
    }

    private static void _sAddColumnSelector(JTable table) {
        JScrollPane pane = TableHelper.getTableScrollPane(table);
        if (pane != null) {
            LayoutManager layout;
            Component comp = pane.getCorner("UPPER_RIGHT_CORNER");
            if (!(comp instanceof ColumnSelector)) {
                pane.setCorner("UPPER_RIGHT_CORNER", (Component)((Object)TableHelper.getColumnSelector(table)));
            }
            if (!((layout = pane.getLayout()) instanceof ColumnSelectorScrollPaneLayout)) {
                pane.setLayout(new ColumnSelectorScrollPaneLayout((ScrollPaneLayout)pane.getLayout()));
            }
        }
    }

    private static void _sRemoveColumnSelector(JTable table) {
        JScrollPane pane = TableHelper.getTableScrollPane(table);
        if (pane != null) {
            Component comp;
            LayoutManager layout = pane.getLayout();
            if (layout instanceof ColumnSelectorScrollPaneLayout) {
                pane.setLayout(((ColumnSelectorScrollPaneLayout)layout).getBaseLayout());
            }
            if ((comp = pane.getCorner("UPPER_RIGHT_CORNER")) instanceof ColumnSelector) {
                pane.setCorner("UPPER_RIGHT_CORNER", null);
            }
        }
    }

    private static PropertyChangeListener _sGetColumnSelectorListener() {
        if (_sColSelListener == null) {
            _sColSelListener = new ColumnSelectorListener();
        }
        return _sColSelListener;
    }

    private static JLabel _createNoEntryLabel(JTable table, String text) {
        JLabel label = (JLabel)table.getClientProperty(_NO_ENTRY_LABEL);
        if (label == null) {
            label = new JLabel(text);
            label.setEnabled(false);
            label.setOpaque(false);
            label.setBorder(new EmptyBorder(0, 7, 0, 0));
            table.putClientProperty(_NO_ENTRY_LABEL, label);
        } else {
            label.setText(text);
        }
        return label;
    }

    private static void _sAddNoEntryInstructionText(JTable table, String text) {
        boolean isPrefSizeSet;
        if (text == null || "".equals(text)) {
            return;
        }
        JLabel label = TableHelper._createNoEntryLabel(table, text);
        if (label.getParent() != table) {
            table.add((Component)label, 0);
        }
        label.setLocation(0, 0);
        label.setSize(label.getPreferredSize());
        Dimension currPrefSize = table.getPreferredSize();
        boolean bl = isPrefSizeSet = table.isPreferredSizeSet() && !Boolean.TRUE.equals(table.getClientProperty(_PREF_SIZE_SET_FLAG));
        if (isPrefSizeSet) {
            currPrefSize = table.getPreferredSize();
            table.putClientProperty(_PREV_PREF_SIZE, currPrefSize);
        }
        if (currPrefSize == null) {
            currPrefSize.width = table.getWidth();
            currPrefSize.height = table.getHeight();
        }
        table.setPreferredSize(new Dimension(Math.max(currPrefSize.width, label.getWidth()), Math.max(currPrefSize.height, label.getHeight())));
        if (isPrefSizeSet) {
            table.addPropertyChangeListener("preferredSize", TableHelper._sGetPrefSizeChanger());
        } else {
            table.putClientProperty(_PREF_SIZE_SET_FLAG, Boolean.TRUE);
        }
        table.revalidate();
        table.repaint();
    }

    private static void _sRemoveNoEntryInstructionText(JTable table) {
        TableHelper._sMakeNoEntryInvisible(table);
        JLabel label = (JLabel)table.getClientProperty(_NO_ENTRY_LABEL);
        if (label != null) {
            table.putClientProperty(_NO_ENTRY_LABEL, null);
        }
    }

    private static void _sMakeNoEntryInvisible(JTable table) {
        JLabel label = (JLabel)table.getClientProperty(_NO_ENTRY_LABEL);
        if (label != null && label.getParent() == table) {
            table.remove(label);
            Dimension oldPrefSize = (Dimension)table.getClientProperty(_PREV_PREF_SIZE);
            table.setPreferredSize(oldPrefSize);
            table.putClientProperty(_PREF_SIZE_SET_FLAG, null);
            table.removePropertyChangeListener("preferredSize", TableHelper._sGetPrefSizeChanger());
            table.revalidate();
            table.repaint();
        }
    }

    private static PropertyChangeListener _sGetPrefSizeChanger() {
        if (_sprefSizeChanger == null) {
            _sprefSizeChanger = new PrefSizeChangeListener();
        }
        return _sprefSizeChanger;
    }

    private static MouseListener _sGetResizeOnDoubleClickListener() {
        if (_sDoubleClickListener == null) {
            _sDoubleClickListener = new DoubleClickListener();
        }
        return _sDoubleClickListener;
    }

    private static MouseAdapter _sGetColHeaderSelListener() {
        if (_sColHeaderSelector == null) {
            _sColHeaderSelector = new ColumnHeaderSelector();
        }
        return _sColHeaderSelector;
    }

    private static PropertyChangeListener _sGetColHeaderChangeListener() {
        if (_sColHeaderChanger == null) {
            _sColHeaderChanger = new ColHeaderChanger();
        }
        return _sColHeaderChanger;
    }

    private static TransferHandler _sGetPasteTableTransferHandler() {
        if (_sPasteTableTransferHandler == null) {
            _sPasteTableTransferHandler = new TableTransferHandler(true);
        }
        return _sPasteTableTransferHandler;
    }

    private static TransferHandler _sGetTableTransferHandler() {
        if (_sTableTransferHandler == null) {
            _sTableTransferHandler = new TableTransferHandler(false);
        }
        return _sTableTransferHandler;
    }

    private static class BasicTransferable
    implements Transferable,
    UIResource {
        protected String plainData;
        protected String htmlData;
        private static DataFlavor[] htmlFlavors;
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;

        public BasicTransferable(String plainData, String htmlData) {
            this.plainData = plainData;
            this.htmlData = htmlData;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            int nRicher = richerFlavors != null ? richerFlavors.length : 0;
            int nHTML = this.isHTMLSupported() ? htmlFlavors.length : 0;
            int nPlain = this.isPlainSupported() ? plainFlavors.length : 0;
            int nString = this.isPlainSupported() ? stringFlavors.length : 0;
            int nFlavors = nRicher + nHTML + nPlain + nString;
            DataFlavor[] flavors = new DataFlavor[nFlavors];
            int nDone = 0;
            if (nRicher > 0) {
                System.arraycopy(richerFlavors, 0, flavors, nDone, nRicher);
                nDone += nRicher;
            }
            if (nHTML > 0) {
                System.arraycopy(htmlFlavors, 0, flavors, nDone, nHTML);
                nDone += nHTML;
            }
            if (nPlain > 0) {
                System.arraycopy(plainFlavors, 0, flavors, nDone, nPlain);
                nDone += nPlain;
            }
            if (nString > 0) {
                System.arraycopy(stringFlavors, 0, flavors, nDone, nString);
            }
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isRicherFlavor(flavor)) {
                return this.getRicherData(flavor);
            }
            if (this.isHTMLFlavor(flavor)) {
                String data = this.getHTMLData();
                String string = data = data == null ? "" : data;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(data.getBytes());
                }
            } else if (this.isPlainFlavor(flavor)) {
                String data = this.getPlainData();
                String string = data = data == null ? "" : data;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new ByteArrayInputStream(data.getBytes());
                }
            } else if (this.isStringFlavor(flavor)) {
                String data = this.getPlainData();
                data = data == null ? "" : data;
                return data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        protected boolean isRicherFlavor(DataFlavor flavor) {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            int nFlavors = richerFlavors != null ? richerFlavors.length : 0;
            for (int i = 0; i < nFlavors; ++i) {
                if (!richerFlavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected DataFlavor[] getRicherFlavors() {
            return null;
        }

        protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
            return null;
        }

        protected boolean isHTMLFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = htmlFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isHTMLSupported() {
            return this.htmlData != null;
        }

        protected String getHTMLData() {
            return this.htmlData;
        }

        protected boolean isPlainFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = plainFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected String getPlainData() {
            return this.plainData;
        }

        protected boolean isStringFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = stringFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        static {
            try {
                htmlFlavors = new DataFlavor[3];
                BasicTransferable.htmlFlavors[0] = new DataFlavor("text/html;class=java.lang.String");
                BasicTransferable.htmlFlavors[1] = new DataFlavor("text/html;class=java.io.Reader");
                BasicTransferable.htmlFlavors[2] = new DataFlavor("text/html;charset=unicode;class=java.io.InputStream");
                plainFlavors = new DataFlavor[3];
                BasicTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                BasicTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                BasicTransferable.plainFlavors[2] = new DataFlavor("text/plain;charset=unicode;class=java.io.InputStream");
                stringFlavors = new DataFlavor[2];
                BasicTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                BasicTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            }
            catch (ClassNotFoundException cle) {
                cle.printStackTrace();
            }
        }
    }

    private static class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        private boolean _paste;

        public TableTransferHandler(boolean paste) {
            this._paste = paste;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c instanceof JTable) {
                int[] cols;
                int counter;
                int[] rows;
                JTable table = (JTable)c;
                if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                    return null;
                }
                if (!table.getRowSelectionAllowed()) {
                    int rowCount = table.getRowCount();
                    rows = new int[rowCount];
                    for (counter = 0; counter < rowCount; ++counter) {
                        rows[counter] = counter;
                    }
                } else {
                    rows = table.getSelectedRows();
                }
                if (!table.getColumnSelectionAllowed()) {
                    int colCount = table.getColumnCount();
                    cols = new int[colCount];
                    for (counter = 0; counter < colCount; ++counter) {
                        cols[counter] = counter;
                    }
                } else {
                    cols = table.getSelectedColumns();
                }
                if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
                    return null;
                }
                StringBuffer plainBuf = new StringBuffer();
                StringBuffer htmlBuf = new StringBuffer();
                htmlBuf.append("<html>\n<body>\n<table>\n");
                for (int row = 0; row < rows.length; ++row) {
                    htmlBuf.append("<tr>\n");
                    for (int col = 0; col < cols.length; ++col) {
                        Object obj = table.getValueAt(rows[row], cols[col]);
                        String val = null;
                        if (obj != null && table instanceof DisplayableTable) {
                            val = ((DisplayableTable)((Object)table)).convertValueToText(obj, true, false, row, col);
                        }
                        if (val == null) {
                            val = obj == null ? "" : obj.toString();
                        }
                        plainBuf.append(val + "\t");
                        htmlBuf.append("  <td>" + val + "</td>\n");
                    }
                    plainBuf.deleteCharAt(plainBuf.length() - 1).append("\n");
                    htmlBuf.append("</tr>\n");
                }
                plainBuf.deleteCharAt(plainBuf.length() - 1);
                htmlBuf.append("</table>\n</body>\n</html>");
                return new BasicTransferable(plainBuf.toString(), htmlBuf.toString());
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (!this._paste) {
                return super.importData(comp, t);
            }
            if (comp instanceof JTable) {
                JTable table = (JTable)comp;
                TableModel tModel = table.getModel();
                if (!(tModel instanceof EditableTableModel) && !(tModel instanceof DefaultTableModel)) {
                    return false;
                }
                try {
                    DataFlavor[] flavors;
                    String plainData = null;
                    for (DataFlavor f : flavors = BasicTransferable.stringFlavors) {
                        if (!t.isDataFlavorSupported(f)) continue;
                        plainData = (String)t.getTransferData(f);
                        break;
                    }
                    if (plainData == null || "".equals(plainData)) {
                        return false;
                    }
                    if (!table.getCellSelectionEnabled()) {
                        if (table.getRowSelectionAllowed()) {
                            int mCount = tModel.getRowCount();
                            String[] rowData = plainData.split("\n");
                            for (int i = 0; i < rowData.length; ++i) {
                                Object[] cellData = rowData[i].split("\t");
                                if (tModel instanceof EditableTableModel) {
                                    ((EditableTableModel)((Object)tModel)).addRow(cellData);
                                } else {
                                    ((DefaultTableModel)tModel).addRow(cellData);
                                }
                                int viewIndex = table.convertRowIndexToView(mCount++);
                                table.addRowSelectionInterval(viewIndex, viewIndex);
                            }
                        } else if (table.getColumnSelectionAllowed()) {
                            ArrayList colList = new ArrayList(0);
                            int mCount = tModel.getRowCount();
                            String[] rowData = plainData.split("\n");
                            for (int i = 0; i < rowData.length; ++i) {
                                String[] cellData = rowData[i].split("\t");
                                for (int j = 0; j < cellData.length; ++j) {
                                    ArrayList<String> dataList;
                                    ArrayList<String> arrayList = dataList = j < colList.size() ? (ArrayList<String>)colList.get(j) : null;
                                    if (dataList == null) {
                                        dataList = new ArrayList<String>(mCount);
                                        colList.add(j, dataList);
                                    }
                                    dataList.add(cellData[j]);
                                }
                            }
                            int colCount = colList.size();
                            if (colCount != 0) {
                                int cCount = tModel.getColumnCount();
                                for (int i = 0; i < colCount; ++i) {
                                    TableHelper.addColumn(table, null, ((ArrayList)colList.get(i)).toArray());
                                    int viewIndex = table.convertColumnIndexToView(cCount++);
                                    table.addColumnSelectionInterval(viewIndex, viewIndex);
                                }
                            }
                        }
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    private static class ColHeaderChanger
    implements PropertyChangeListener {
        private ColHeaderChanger() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            if ("tableHeader".equals(pe.getPropertyName())) {
                JTableHeader newHeader;
                JTableHeader oldHeader = (JTableHeader)pe.getOldValue();
                if (oldHeader != null) {
                    oldHeader.removeMouseListener(TableHelper._sGetColHeaderSelListener());
                    oldHeader.removeMouseMotionListener(TableHelper._sGetColHeaderSelListener());
                }
                if ((newHeader = (JTableHeader)pe.getNewValue()) != null) {
                    newHeader.addMouseListener(TableHelper._sGetColHeaderSelListener());
                    newHeader.addMouseMotionListener(TableHelper._sGetColHeaderSelListener());
                }
            }
        }
    }

    private static class ColumnHeaderSelector
    extends MouseAdapter {
        private ColumnHeaderSelector() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            JTableHeader colHeader = (JTableHeader)me.getComponent();
            JTable table = colHeader.getTable();
            if (table.isEnabled() && me.getButton() == 1) {
                int col;
                colHeader.requestFocus();
                boolean selectAllRow = false;
                if (table.getColumnSelectionAllowed() && (col = colHeader.columnAtPoint(me.getPoint())) != -1) {
                    boolean anchorSelected;
                    ListSelectionModel selModel = table.getColumnModel().getSelectionModel();
                    int anchorIndex = Math.min(selModel.getAnchorSelectionIndex(), table.getColumnCount());
                    if (anchorIndex == -1) {
                        anchorIndex = 0;
                        anchorSelected = false;
                    } else {
                        anchorSelected = selModel.isSelectedIndex(anchorIndex);
                    }
                    if (me.isControlDown()) {
                        if (me.isShiftDown()) {
                            if (anchorSelected) {
                                selModel.addSelectionInterval(anchorIndex, col);
                                selectAllRow = true;
                            } else {
                                selModel.removeSelectionInterval(anchorIndex, col);
                            }
                        } else if (selModel.isSelectedIndex(col)) {
                            selModel.removeSelectionInterval(col, col);
                        } else {
                            selModel.addSelectionInterval(col, col);
                            selectAllRow = true;
                        }
                    } else if (me.isShiftDown()) {
                        selModel.setSelectionInterval(anchorIndex, col);
                        selectAllRow = true;
                    } else {
                        DefaultRowSorter drs;
                        RowSorter<? extends TableModel> rs;
                        if (!selModel.isSelectedIndex(col) && (rs = table.getRowSorter()) != null && rs instanceof DefaultRowSorter && (drs = (DefaultRowSorter)rs).isSortable(col)) {
                            drs.setSortable(col, false);
                            colHeader.putClientProperty("__GT_Disable_Sorting", col);
                        }
                        selModel.setSelectionInterval(col, col);
                        selectAllRow = true;
                    }
                    if (selectAllRow && table.getCellSelectionEnabled()) {
                        table.getSelectionModel().addSelectionInterval(0, Math.max(table.getRowCount() - 1, 0));
                    }
                }
            }
        }

        @Override
        public void mouseClicked(final MouseEvent me) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this._reEnableSorting(me);
                }
            });
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            this._reEnableSorting(me);
        }

        private void _reEnableSorting(MouseEvent me) {
            JTable table;
            RowSorter<? extends TableModel> rs;
            JTableHeader colHeader = (JTableHeader)me.getComponent();
            Object sortCol = colHeader.getClientProperty("__GT_Disable_Sorting");
            if (sortCol != null && (rs = (table = colHeader.getTable()).getRowSorter()) != null && rs instanceof DefaultRowSorter) {
                ((DefaultRowSorter)table.getRowSorter()).setSortable((Integer)sortCol, true);
                colHeader.putClientProperty("__GT_Disable_Sorting", null);
            }
        }
    }

    private static class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            JTableHeader tableHeader = (JTableHeader)me.getSource();
            if (tableHeader.getTable().isEnabled() && me.getClickCount() == 2 && me.getButton() == 1) {
                TableHelper.sizeColumnToMaximumWidth(tableHeader.getTable(), me.getX());
            }
        }
    }

    private static class SortIconUp
    implements Icon {
        private SortIconUp() {
        }

        @Override
        public int getIconHeight() {
            return SORT_ICON_SIZE.height;
        }

        @Override
        public int getIconWidth() {
            return SORT_ICON_SIZE.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(x, y + 5, x + 9, y + 5);
            g.drawLine(x + 1, y + 4, x + 8, y + 4);
            g.drawLine(x + 2, y + 3, x + 7, y + 3);
            g.drawLine(x + 3, y + 2, x + 6, y + 2);
            g.drawLine(x + 4, y + 1, x + 5, y + 1);
        }
    }

    private static class SortIconDown
    implements Icon {
        private SortIconDown() {
        }

        @Override
        public int getIconHeight() {
            return SORT_ICON_SIZE.height;
        }

        @Override
        public int getIconWidth() {
            return SORT_ICON_SIZE.width;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(UIManager.getColor("controlShadow"));
            g.drawLine(x, y + 1, x + 9, y + 1);
            g.drawLine(x + 1, y + 2, x + 8, y + 2);
            g.drawLine(x + 2, y + 3, x + 7, y + 3);
            g.drawLine(x + 3, y + 4, x + 6, y + 4);
            g.drawLine(x + 4, y + 5, x + 5, y + 5);
        }
    }

    private static class PrefSizeChangeListener
    implements PropertyChangeListener {
        private PrefSizeChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            JTable table = (JTable)pe.getSource();
            table.putClientProperty(TableHelper._PREV_PREF_SIZE, pe.getNewValue());
        }
    }

    private static class ColumnSelectorListener
    implements PropertyChangeListener {
        private ColumnSelectorListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            JTable table = (JTable)pe.getSource();
            if (pe.getOldValue() != null) {
                TableHelper._sRemoveColumnSelector(table);
            }
            if (pe.getNewValue() != null) {
                TableHelper._sAddColumnSelector(table);
            }
        }
    }
}

