/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.jdesktop.animation.timing.Cycle;
import org.jdesktop.animation.timing.Envelope;
import org.jdesktop.animation.timing.TimingController;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.ObjectModifier;
import org.jdesktop.animation.timing.interpolation.PropertyRange;

final class SlideTip {
    private static final int BALLOON_LAYER = JLayeredPane.POPUP_LAYER + 20;
    private Direction _direction;
    private boolean _isVisible = false;
    private JLabel _tipText = new JLabel(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Composite old = g2d.getComposite();
            try {
                AlphaComposite rule = AlphaComposite.getInstance(3, 0.8f);
                g2d.setComposite(rule);
                g2d.setColor(UIManager.getColor("ToolTip.background"));
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                super.paintComponent(g);
            }
            finally {
                g2d.setComposite(old);
            }
        }
    };

    public SlideTip() {
        this._tipText.setBackground(UIManager.getColor("ToolTip.background"));
        this._tipText.setForeground(UIManager.getColor("ToolTip.foreground"));
        this._tipText.setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("ToolTip.border"), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
    }

    public void setText(String text) {
        this._tipText.setText(text);
    }

    public String getText() {
        return this._tipText.getText();
    }

    public void setIcon(Icon icon) {
        this._tipText.setIcon(icon);
    }

    public Icon getIcon() {
        return this._tipText.getIcon();
    }

    public void setDirection(Direction direction) {
        this._direction = direction;
    }

    public Direction getDirection() {
        return this._direction;
    }

    public void show(int offset, final Component c, int hideAfterInMs) {
        if (this._isVisible) {
            return;
        }
        JLayeredPane pane = SlideTip.getLayeredPane(c);
        if (pane == null) {
            throw new IllegalArgumentException("Cannot find layered pane for " + c);
        }
        this._isVisible = true;
        pane.add((Component)this._tipText, (Object)BALLOON_LAYER);
        Point basePos = SlideTip.getPositionInLayeredPane(c);
        Rectangle startBounds = new Rectangle(basePos.x + offset, basePos.y + c.getHeight(), this._tipText.getPreferredSize().width, 0);
        Rectangle endBounds = new Rectangle(basePos.x + offset, basePos.y + c.getHeight(), this._tipText.getPreferredSize().width, this._tipText.getPreferredSize().height);
        this._tipText.setBounds(basePos.x, basePos.y + c.getHeight(), this._tipText.getPreferredSize().width, 0);
        PropertyRange heightRange = PropertyRange.createPropertyRangeRectangle((String)"bounds", (Rectangle[])new Rectangle[]{startBounds, endBounds});
        ObjectModifier modifier = new ObjectModifier((Object)this._tipText, heightRange);
        TimingController animation = new TimingController(new Cycle(1000, 30), new Envelope(1.0, 0, Envelope.RepeatBehavior.FORWARD, Envelope.EndBehavior.HOLD), (TimingTarget)modifier);
        animation.start();
        if (hideAfterInMs > 0) {
            Timer t = new Timer(hideAfterInMs, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    SlideTip.this.hide(c);
                }
            });
            t.setRepeats(false);
            t.start();
        }
    }

    public void show(Component c) {
        this.show(0, c, -1);
    }

    private void hide(final Component c) {
        Rectangle b = this._tipText.getBounds();
        Rectangle endBounds = new Rectangle(b.x, b.y, b.width, 0);
        Rectangle startBounds = this._tipText.getBounds();
        PropertyRange heightRange = PropertyRange.createPropertyRangeRectangle((String)"bounds", (Rectangle[])new Rectangle[]{startBounds, endBounds});
        ObjectModifier modifier = new ObjectModifier((Object)this._tipText, heightRange);
        TimingController animation = new TimingController(new Cycle(1000, 30), new Envelope(1.0, 0, Envelope.RepeatBehavior.FORWARD, Envelope.EndBehavior.HOLD), (TimingTarget)modifier){

            public void end() {
                super.end();
                JLayeredPane pane = SlideTip.getLayeredPane(c);
                pane.remove(SlideTip.this._tipText);
                pane.repaint();
                SlideTip.this._isVisible = false;
            }
        };
        animation.start();
    }

    private static JLayeredPane getLayeredPane(Component target) {
        Window ancestor = SwingUtilities.getWindowAncestor(target);
        JLayeredPane layeredPane = null;
        if (ancestor instanceof JFrame) {
            layeredPane = ((JFrame)ancestor).getLayeredPane();
        } else if (ancestor instanceof JDialog) {
            layeredPane = ((JDialog)ancestor).getLayeredPane();
        }
        return layeredPane;
    }

    private static Point getPositionInLayeredPane(Component c) {
        Point p = new Point();
        p.x = c.getLocation().x;
        p.y = c.getLocation().y;
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            Point parentLoc = parent.getLocation();
            p.x += parentLoc.x;
            p.y += parentLoc.y;
            if (parent instanceof JLayeredPane) break;
        }
        return p;
    }

    public static enum Direction {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

