/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.plaf.synth.SynthLookAndFeel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.javatools.ui.search.SearchFieldUI;
import oracle.javatools.ui.search.SearchProgress;

final class BasicSearchFieldUI
extends SearchFieldUI {
    private static final Color PROGRESS_BAR_COLOR = new Color(206, 223, 247);
    private static final int INDETERMINATE_RECT_WIDTH = 50;
    private static final Color BORDER_COLOR = new Color(132, 130, 132);
    private static final Insets BORDER_INSETS = new Insets(2, 8, 2, 8);

    BasicSearchFieldUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicSearchFieldUI();
    }

    @Override
    public JPanel createSearchPanel() {
        JPanel searchPanel = new JPanel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void paintComponent(Graphics g) {
                SearchProgress progress = BasicSearchFieldUI.this.getSearchField().getSearchProgress();
                Graphics2D g2d = (Graphics2D)g;
                int height = this.getHeight();
                int width = this.getWidth();
                Object oldAAValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                try {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    GeneralPath areaPath = new GeneralPath();
                    areaPath.append(new Arc2D.Double(0.0, 0.0, BORDER_INSETS.left * 2 - 1, height - 1, 90.0, 180.0, 0), true);
                    areaPath.lineTo(0 + width - BORDER_INSETS.right - 2, 0 + height - 1);
                    areaPath.append(new Arc2D.Double(0 + width - BORDER_INSETS.right * 2 - 1, 0.0, BORDER_INSETS.right * 2 - 1, height - 1, 270.0, 180.0, 0), true);
                    areaPath.lineTo(0 + BORDER_INSETS.left, 0.0f);
                    g2d.setColor(UIManager.getColor("TextArea.background"));
                    g2d.fill(areaPath);
                    if (progress != null) {
                        Shape oldClip = g2d.getClip();
                        try {
                            g2d.setClip(areaPath);
                            g.setColor(PROGRESS_BAR_COLOR);
                            if (progress.isDeterminate()) {
                                double pctComplete = (double)progress.getProgress() / (double)progress.getTotalSteps();
                                int progressBarWidth = (int)((double)width * pctComplete);
                                g.fillRect(0, 0, progressBarWidth, height);
                            } else if (BasicSearchFieldUI.this.getSearchField().getIndeterminateValue() >= 0.0f) {
                                int x = (int)((float)width * BasicSearchFieldUI.this.getSearchField().getIndeterminateValue());
                                g.fillRect(x, 0, 50, height);
                            }
                        }
                        finally {
                            g2d.setClip(oldClip);
                        }
                    }
                    g2d.setColor(BORDER_COLOR);
                    g2d.draw(areaPath);
                }
                finally {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAAValue);
                }
                super.paintComponent(g);
            }
        };
        searchPanel.setBorder(new EmptyBorder(BORDER_INSETS));
        searchPanel.setOpaque(false);
        return searchPanel;
    }

    @Override
    public void configureTextField(PromptedTextField field) {
        LookAndFeel laf = UIManager.getLookAndFeel();
        if (laf instanceof SynthLookAndFeel) {
            field.setUI(new BasicTextFieldUI());
        }
        field.setOpaque(false);
        field.setBorder(null);
    }

    @Override
    public void configureSearchButton(JButton button) {
    }

    @Override
    public Icon getCancelIcon(boolean enabled) {
        return OracleIcons.getIcon((String)"delete.png");
    }

    @Override
    public Icon getPreviousIcon(boolean enabled) {
        if (enabled) {
            return OracleIcons.getIcon((String)"previous.png");
        }
        return null;
    }

    @Override
    public Icon getFindNextIcon(boolean enable) {
        if (enable) {
            return OracleIcons.getIcon((String)"next.png");
        }
        return null;
    }

    @Override
    public Icon getSearchIcon(Icon baseIcon, boolean enabled) {
        if (enabled) {
            return new PopupIndicator(baseIcon, baseIcon.getIconWidth() > 0);
        }
        return baseIcon;
    }

    @Override
    public Icon getSearchPopupIcon() {
        return OracleIcons.getIcon((String)"search.png");
    }

    @Override
    public Icon getSearchDefaultIcon() {
        return OracleIcons.getIcon((String)"quick_query.png");
    }

    @Override
    public Icon getSearchingIcon() {
        return OracleIcons.getIcon((String)"terminate.png");
    }

    @Override
    public Icon getSearchHaveTextIcon() {
        return OracleIcons.getIcon((String)"quick_query.png");
    }

    @Override
    public Border getPreviousBorder() {
        return null;
    }

    @Override
    public Border getNextBorder() {
        return null;
    }

    private static final class PopupIndicator
    implements Icon {
        private static final int GAP = 2;
        private static final int SIZE = 4;
        private final Icon _baseIcon;
        private final Polygon _inner = new Polygon();
        private final boolean _gapLeft;

        public PopupIndicator(Icon baseIcon, boolean gapLeft) {
            this._baseIcon = baseIcon;
            this._inner.addPoint(0, 0);
            this._inner.addPoint(2, 2);
            this._inner.addPoint(4, 0);
            this._gapLeft = gapLeft;
        }

        @Override
        public int getIconHeight() {
            return Math.max(this._inner.getBounds().height, this._baseIcon.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return 2 + this._inner.getBounds().width + this._baseIcon.getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this._baseIcon.paintIcon(c, g, x, y);
            if (c.isEnabled()) {
                this.paint(g, this._baseIcon.getIconWidth() + (this._gapLeft ? 2 : 0), y + this.getIconHeight() / 2 - this._inner.getBounds().height / 2, c.getForeground());
            } else {
                this.paint(g, this._baseIcon.getIconWidth() + (this._gapLeft ? 2 : 0), y + this.getIconHeight() / 2 - this._inner.getBounds().height / 2, c.getBackground().darker());
            }
        }

        private void paint(Graphics g, int x, int y, Color color) {
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(color);
            g.fillPolygon(this._inner);
            g.drawPolygon(this._inner);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }
}

