/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.plaf.theme;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import oracle.javatools.ui.breadcrumbs.AttributedBreadcrumb;
import oracle.javatools.ui.breadcrumbs.Breadcrumb;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsButton;
import oracle.javatools.ui.breadcrumbs.BreadcrumbsButtonUI;
import oracle.javatools.ui.simplestyle.StyledTextRenderer;
import oracle.javatools.ui.themes.LinearGradientPainter;

public final class ThemedBreadcrumbsButtonUI
extends BreadcrumbsButtonUI {
    private static final LinearGradientPainter normalFill;
    private static final LinearGradientPainter rolloverFill;
    private static final LinearGradientPainter pressedFill;
    private static final LinearGradientPainter arrowFill;
    private static final LinearGradientPainter normalLine;
    private static final LinearGradientPainter rolloverLine;
    private static final LinearGradientPainter pressedLine;
    private static final Color focusLine;
    private static final Color textColor;

    public static ComponentUI createUI(JComponent c) {
        return new ThemedBreadcrumbsButtonUI();
    }

    @Override
    protected void paintBackground(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        super.paintBackground(b, g2, shape);
        if (!(b.getModel().isArmed() || b.getModel().isPressed() || b.getModel().isRollover() || b.getModel().isSelected())) {
            normalFill.paint(g2, shape);
        }
    }

    @Override
    protected void paintBorder(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        if (b.isFocusOwner()) {
            return;
        }
        LinearGradientPainter painter = normalLine;
        if (b.getModel().isPressed()) {
            painter = pressedLine;
        } else if (b.getModel().isRollover()) {
            painter = rolloverLine;
        }
        painter.draw(g2, shape);
    }

    @Override
    protected void paintFocus(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        g2.setColor(focusLine);
        g2.setStroke(new BasicStroke(1.5f, 1, 1));
        g2.draw(shape);
        g2.setStroke(lineStroke);
    }

    @Override
    protected void paintRollover(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        rolloverFill.paint(g2, shape);
    }

    @Override
    protected void paintSelection(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        super.paintSelection(b, g2, shape);
    }

    @Override
    protected void paintPressed(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        pressedFill.paint(g2, shape);
    }

    @Override
    protected void paintText(BreadcrumbsButton b, Graphics2D g2, Shape shape) {
        AttributedBreadcrumb attributedBreadcrumb;
        Breadcrumb breadcrumb = b.getBreadcrumb();
        AttributedBreadcrumb attributedBreadcrumb2 = attributedBreadcrumb = breadcrumb instanceof AttributedBreadcrumb ? (AttributedBreadcrumb)((Object)breadcrumb) : null;
        if (attributedBreadcrumb != null && attributedBreadcrumb.hasAttribute(AttributedBreadcrumb.Attribute.FOREGROUND_COLOR)) {
            g2.setColor((Color)attributedBreadcrumb.getAttribute(AttributedBreadcrumb.Attribute.FOREGROUND_COLOR));
        } else {
            g2.setColor(textColor);
        }
        StyledTextRenderer.renderText(b, g2, b.getStyledText(), b.getInsets().left + 2, b.getInsets().top);
    }

    @Override
    public Icon getPeersIcon() {
        return DownIcon.INSTANCE;
    }

    static {
        focusLine = new Color(245, 165, 16);
        textColor = new Color(45, 58, 84);
        float[] fractions = new float[]{0.0f, 0.03f, 0.24f, 0.4f, 1.0f};
        Color[] colors = new Color[]{new Color(0, 0, 0, 10), new Color(0, 0, 0, 10), new Color(0, 0, 0, 20), new Color(0, 0, 0, 35), new Color(0, 0, 0, 20)};
        normalFill = new LinearGradientPainter(fractions, colors, 1);
        fractions = new float[]{0.0f, 0.03f, 0.24f, 0.4f, 1.0f};
        colors = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 2), new Color(0, 0, 0, 10), new Color(0, 0, 0, 2)};
        rolloverFill = new LinearGradientPainter(fractions, colors, 1);
        fractions = new float[]{0.0f, 0.3f, 0.37f, 0.44f, 0.95f, 1.0f};
        colors = new Color[]{new Color(207, 224, 241), new Color(199, 218, 238), new Color(186, 210, 234), new Color(190, 212, 235), new Color(198, 218, 238), new Color(198, 218, 238)};
        pressedFill = new LinearGradientPainter(fractions, colors, 1);
        fractions = new float[]{0.0f, 0.2f, 1.0f};
        colors = new Color[]{new Color(124, 158, 195), new Color(107, 137, 177), new Color(90, 115, 158)};
        arrowFill = new LinearGradientPainter(fractions, colors, 1);
        fractions = new float[]{0.0f, 1.0f};
        colors = new Color[]{new Color(168, 178, 195), new Color(198, 202, 209)};
        normalLine = new LinearGradientPainter(fractions, colors, 1);
        fractions = new float[]{0.0f, 1.0f};
        colors = new Color[]{new Color(197, 202, 210), new Color(214, 217, 22)};
        rolloverLine = new LinearGradientPainter(fractions, colors, 1);
        fractions = new float[]{0.0f, 0.12f, 1.0f};
        colors = new Color[]{new Color(187, 194, 205), new Color(187, 202, 205), new Color(188, 210, 232)};
        pressedLine = new LinearGradientPainter(fractions, colors, 1);
    }

    private static class DownIcon
    implements Icon {
        private static final DownIcon INSTANCE = new DownIcon();
        private static final GeneralPath shape = new GeneralPath();

        private DownIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.translate(x, y + 1);
            g.setColor(UIManager.getColor("Label.foreground"));
            arrowFill.paint(g2, shape);
            g2.translate(-x, -y - 1);
        }

        @Override
        public int getIconWidth() {
            return 8;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }

        static {
            shape.moveTo(0.0f, 2.0f);
            shape.lineTo(7.0f, 2.0f);
            shape.lineTo(3.0f, 6.0f);
        }
    }
}

