/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.overview;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.UIManager;
import oracle.javatools.ui.overview.Overview;
import oracle.javatools.ui.overview.OverviewListener;
import oracle.javatools.ui.overview.OverviewMark;
import oracle.javatools.ui.overview.OverviewMarkRenderingHints;

final class OverviewComponent<T extends Number, M extends OverviewMark<T>>
extends JPanel {
    private int breadth = 12;
    private static final int minMarkDepth = 6;
    static final int INSET = 1;
    private int markBreadth = this.breadth - 1 - 1 - 1;
    private static final int UNKOWN_VERTICAL_ADJUSTMENT = 3;
    private final Overview<T, M> overview;
    private final Map<M, Rectangle> markRects = new HashMap<M, Rectangle>();
    static final Color DEFAULT_COLOR = UIManager.getColor("TextPane.background");
    private static final Stroke LINE_STROKE = new BasicStroke(1.0f);
    private static final Stroke DOTTED_STROKE = new BasicStroke(0.75f, 0, 0, 1.0f, new float[]{1.0f, 2.0f}, 0.0f);

    OverviewComponent(Overview<T, M> overview) {
        this.setBackground(DEFAULT_COLOR);
        this.overview = overview;
        this.buildMarkRects();
        overview.addOverviewListener(new OverviewListener<M>(){

            @Override
            public void markAdded(M mark) {
                OverviewComponent.this.addMark(mark);
            }

            @Override
            public void markRemoved(M mark) {
                OverviewComponent.this.removeMark(mark);
            }

            @Override
            public void markClicked(M mark) {
            }

            @Override
            public void overviewClicked(float relativeLocation) {
            }

            @Override
            public void overviewPopup(float relativeLocation, MouseEvent me) {
            }
        });
        overview.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("overviewEND") || evt.getPropertyName().equals("overviewSTART")) {
                    OverviewComponent.this.buildMarkRects();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OverviewComponent.this.buildMarkRects();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point p = e.getPoint();
                if (OverviewComponent.this.marksAtPoint(p).isEmpty()) {
                    OverviewComponent.this.setCursor(Cursor.getDefaultCursor());
                } else {
                    OverviewComponent.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }
        });
    }

    void setThin(boolean makeThin) {
        this.breadth = makeThin ? 6 : 12;
        this.markBreadth = this.breadth - 1 - 1;
        this.invalidate();
    }

    @Override
    public final Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        if (this.overview.getOrientation() == Overview.Orientation.VERTICAL) {
            d.width = this.breadth;
        } else {
            d.height = this.breadth;
        }
        return d;
    }

    @Override
    public final Dimension getMinimumSize() {
        Dimension d = super.getMinimumSize();
        if (this.overview.getOrientation() == Overview.Orientation.VERTICAL) {
            d.width = this.breadth;
        } else {
            d.height = this.breadth;
        }
        return d;
    }

    @Override
    public final Dimension getMaximumSize() {
        Dimension d = super.getMaximumSize();
        if (this.overview.getOrientation() == Overview.Orientation.VERTICAL) {
            d.width = this.breadth;
        } else {
            d.height = this.breadth;
        }
        return d;
    }

    Rectangle markToRect(M mark) {
        return this.markRects.get(mark);
    }

    Set<M> marksAtPoint(Point p) {
        p.y -= 3;
        HashSet<OverviewMark> marks = new HashSet<OverviewMark>();
        for (Float priority : this.overview.getPriorities()) {
            for (OverviewMark mark : this.overview.getMarks(priority)) {
                Rectangle rectangle = this.markRects.get(mark);
                if (rectangle == null || !rectangle.contains(p)) continue;
                marks.add(mark);
            }
        }
        return marks;
    }

    M markAtPoint(Point p) {
        p.y -= 3;
        List<Float> priorities = this.overview.getPriorities();
        Collections.sort(priorities, Collections.reverseOrder());
        for (Float priority : priorities) {
            for (OverviewMark mark : this.overview.getMarks(priority)) {
                Rectangle rectangle = this.markRects.get(mark);
                if (rectangle == null || !rectangle.contains(p)) continue;
                return (M)mark;
            }
        }
        return null;
    }

    void buildMarkRects() {
        this.markRects.clear();
        for (Float priority : this.overview.getPriorities()) {
            Collection<M> marks = this.overview.getMarks(priority);
            for (OverviewMark mark : marks) {
                this.addMark(mark);
            }
        }
        this.repaint();
    }

    private void addMark(M mark) {
        int componentRange = this.getComponentRange();
        float o = 0.0f - ((Number)this.overview.getStart()).floatValue();
        float max = o + ((Number)this.overview.getEnd()).floatValue();
        int s = (int)((((Number)mark.getStart()).floatValue() + o) * (float)componentRange / max);
        int e = (int)((((Number)mark.getEnd()).floatValue() + o) * (float)componentRange / max);
        int d = Math.max(6, e - s);
        Rectangle rect = this.overview.getOrientation() == Overview.Orientation.VERTICAL ? new Rectangle(1, s, this.markBreadth, d) : new Rectangle(s, 1, d, this.markBreadth);
        this.markRects.put(mark, rect);
        this.repaint();
    }

    private void removeMark(M mark) {
        this.markRects.remove(mark);
        this.repaint();
    }

    private int getComponentRange() {
        int componentRange = this.overview.getOrientation() == Overview.Orientation.VERTICAL ? this.getHeight() : this.getWidth();
        componentRange = componentRange - 6 - 1;
        return componentRange;
    }

    float pointToRelativeLocation(Point p) {
        float componentRange = this.getComponentRange();
        float location = this.overview.getOrientation() == Overview.Orientation.VERTICAL ? (float)p.y : (float)p.x;
        float relativeLocation = (location -= 3.0f) / componentRange;
        relativeLocation = Math.max(0.0f, Math.min(1.0f, relativeLocation));
        return relativeLocation;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        this.paintMarks(g2);
    }

    private void paintMarks(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Float priority : this.overview.getPriorities()) {
            Collection<M> marks = this.overview.getMarks(priority);
            ArrayList<Rectangle> borders = new ArrayList<Rectangle>(marks.size());
            for (OverviewMark mark : marks) {
                boolean isDottedLine;
                OverviewMarkRenderingHints hints;
                OverviewMarkRenderingHints overviewMarkRenderingHints = hints = mark instanceof OverviewMarkRenderingHints ? (OverviewMarkRenderingHints)((Object)mark) : null;
                Rectangle rect = this.markRects.get(mark);
                if (rect == null) continue;
                boolean isThin = hints != null && hints.getValue(OverviewMarkRenderingHints.Hint.THIN) == Boolean.TRUE;
                boolean isVert = this.overview.getOrientation() == Overview.Orientation.VERTICAL;
                int width = Math.max(1, rect.width - (isVert ? 0 : 2));
                int height = Math.max(1, rect.height - (isVert ? 2 : 0));
                int x = rect.x + (isVert ? 0 : 1);
                int y = rect.y + (isVert ? 1 : 0);
                Color color = mark.getColor();
                g2.setColor(color);
                boolean isLine = hints != null && hints.getValue(OverviewMarkRenderingHints.Hint.LINE) == Boolean.TRUE;
                boolean bl = isDottedLine = hints != null && hints.getValue(OverviewMarkRenderingHints.Hint.DOTTED_LINE) == Boolean.TRUE;
                if (isLine || isDottedLine) {
                    int n = isDottedLine ? 2 : 1;
                    Stroke stroke = g2.getStroke();
                    g2.setStroke(isDottedLine ? DOTTED_STROKE : LINE_STROKE);
                    g2.drawLine(x, y, width += n, y += height / 2);
                    g2.drawLine(x, y - 1, width, y - 1);
                    g2.setStroke(stroke);
                    continue;
                }
                if (color != null) {
                    g2.fillRect(x, y, width, height);
                }
                Color color2 = color = color != null ? color.darker() : Color.DARK_GRAY;
                if (hints == null || hints.getValue(OverviewMarkRenderingHints.Hint.BORDERLESS) != Boolean.TRUE) {
                    g2.setColor(color);
                }
                borders.add(new Rectangle(x, y, width, height));
            }
            for (Rectangle rect : borders) {
                g2.drawLine(rect.x, rect.y + rect.height, rect.x + rect.width, rect.y + rect.height);
                g2.drawLine(rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + rect.height);
            }
        }
    }

    int getBreadth() {
        return this.breadth;
    }

    int getMarkBreadth() {
        return this.markBreadth;
    }
}

