/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.infotip.templates;

import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import oracle.javatools.ui.HyperlinkButton;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BasicTemplate;

public final class ActionTemplate
extends BasicTemplate {
    public ActionTemplate(Icon icon, String title, JComponent detailComponent, Action action) {
        this(icon, title, detailComponent, action, InfoTipStyles.DEFAULT);
    }

    public ActionTemplate(Icon icon, String title, JComponent detailComponent, Action action, InfoTipStyles infoTipStyle) {
        super(new JPanel());
        this.content.setLayout((LayoutManager)new MigLayout("ins 0, gapx 2, gapy 0, hidemode 3, fill, nogrid"));
        this.content.setOpaque(false);
        if (infoTipStyle == null) {
            infoTipStyle = InfoTipStyles.DEFAULT;
        }
        Insets ins = infoTipStyle.getBorderInsets();
        this.content.setBorder(BorderFactory.createEmptyBorder(ins.top, ins.left, ins.bottom, ins.right));
        if (icon != null || title != null) {
            JLabel titleLabel = new JLabel(title);
            titleLabel.setIcon(icon);
            titleLabel.setForeground(infoTipStyle.getItemTextColor());
            titleLabel.setFont(infoTipStyle.getItemTitleFont());
            Insets titleIns = infoTipStyle.getItemTitleInsets();
            titleLabel.setBorder(BorderFactory.createEmptyBorder(titleIns.top, titleIns.left, titleIns.bottom, titleIns.right));
            this.content.add(titleLabel);
        }
        if (detailComponent != null) {
            detailComponent.setOpaque(false);
            this.content.add((Component)detailComponent, "gapleft 1, grow, newline");
        }
        if (action != null) {
            HyperlinkButton actionButton = new HyperlinkButton(action);
            actionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActionTemplate.this.fireActionPerformed("closeInfotipCommand");
                }
            });
            this.content.add((Component)actionButton, "newline");
        }
    }

    @Override
    public JComponent getContent() {
        return this.content;
    }
}

