/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.javatools.ui.checklist.ContentElement;

public final class TaskContentProvider {
    private String _reqTitle;
    private List<String> _reqs;
    private Image _image;
    private String _description;
    private String _summHeader;
    private List<String> _summary;
    private ArrayList<ContentElement> _contentElement = new ArrayList();
    private PropertyChangeSupport _propertySupport;

    public void setRequirementHeaderLabel(String headerLabel) {
        String oldTitle = this._reqTitle;
        if (headerLabel != oldTitle) {
            this._reqTitle = headerLabel;
            this.firePropertyChange("requirementHeaderLabel", oldTitle, this._reqTitle);
        }
    }

    public String getRequirementsHeaderLabel() {
        return this._reqTitle;
    }

    public void setRequirements(List<String> requirements) {
        List<String> oldReqs = this._reqs;
        if (requirements != oldReqs) {
            this._reqs = requirements;
            this.firePropertyChange("requirements", oldReqs, this._reqs);
        }
    }

    public List<String> getRequirements() {
        return this._reqs;
    }

    public void setRequirements(String headerLabel, List<String> requirements) {
        this.setRequirementHeaderLabel(headerLabel);
        this.setRequirements(requirements);
    }

    public void setImage(Image image) {
        Image oldIm = this.getImage();
        if (image != oldIm) {
            this._image = image;
            this.firePropertyChange("image", oldIm, this._image);
        }
    }

    public Image getImage() {
        return this._image;
    }

    public void setDescription(String description) {
        String oldDes = this._description;
        if (description != oldDes) {
            this._description = description;
            this.firePropertyChange("description", oldDes, this._description);
        }
    }

    public String getDescription() {
        return this._description;
    }

    public void setSummaryHeaderLabel(String headerLabel) {
        String oldTitle = this._summHeader;
        if (headerLabel != oldTitle) {
            this._summHeader = headerLabel;
            this.firePropertyChange("summaryHeaderLabel", oldTitle, this._summHeader);
        }
    }

    public String getSummaryHeaderLabel() {
        return this._summHeader;
    }

    public void setSummary(List<String> summary) {
        List<String> oldSummary = this._summary;
        if (summary != oldSummary) {
            this._summary = summary;
            this.firePropertyChange("summary", oldSummary, this._summary);
        }
    }

    public List<String> getSummary() {
        return this._summary;
    }

    public void setSummary(String headerLabel, List<String> summary) {
        this.setSummaryHeaderLabel(headerLabel);
        this.setSummary(summary);
    }

    public void addContentElement(ContentElement element) {
        this._contentElement.add(element);
        this.firePropertyChange("contentElementAdded", null, element);
    }

    public ContentElement addContentElement(String id, ContentElement.Type type, String label, Icon icon, String target, String hint) {
        ContentElement elem = new ContentElement(id, type, label, icon, target, hint);
        this.addContentElement(elem);
        return elem;
    }

    public void removeContentElement(ContentElement elem) {
        this._contentElement.remove(elem);
        this.firePropertyChange("contentElementRemoved", elem, null);
    }

    public ContentElement[] getContentElements() {
        return this._contentElement.toArray(new ContentElement[0]);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

