/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import oracle.bali.ewt.imageCanvas.ImageCanvas;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.Header;
import oracle.javatools.ui.HeaderEvent;
import oracle.javatools.ui.HeaderListener;
import oracle.javatools.ui.HeaderPanel;
import oracle.javatools.ui.RichHintLabel;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.checklist.ChecklistHelper;
import oracle.javatools.ui.checklist.ContentActionEvent;
import oracle.javatools.ui.checklist.ContentActionListener;
import oracle.javatools.ui.checklist.ContentElement;
import oracle.javatools.ui.checklist.Step;
import oracle.javatools.ui.checklist.StepContent;
import oracle.javatools.ui.checklist.TaskContentProvider;

public final class TaskContent
extends JPanel
implements StepContent {
    private static final String _INFO_KEY = "_LinkInfoKey";
    private static final Border _BORDER = BorderFactory.createEmptyBorder(8, 8, 8, 8);
    private Step _step;
    private TaskContentProvider _provider;
    private HeaderPanel _preqPanel;
    private RichHintLabel _descLabel;
    private HeaderPanel _summaryPanel;
    private SubstepButton _gotoSubstep;
    private Component _reqComp;
    private ImageComponent _canvas;
    private Component _descriptionArea;
    private Component _controlPanel;
    private Component _helpPanel;
    private Component _summary;
    private boolean _reqDirty = true;
    private boolean _imageDirty = true;
    private boolean _descriptionDirty = true;
    private boolean _summaryDirty = true;
    private boolean _gotoDirty = true;
    private ScrollListener _scrollListener = new ScrollListener();
    private HashMap<ContentElement, Component> _linkElementComps;

    public TaskContent(Step node) {
        this(node, new TaskContentProvider());
    }

    public TaskContent(Step node, TaskContentProvider provider) {
        super(new ContentLayout());
        this.setBorder(_BORDER);
        this.setBackground(Color.white);
        this._step = node;
        this._step.addPropertyChangeListener(new StepListener());
        this._setProvider(provider);
    }

    @Override
    public Step getStep() {
        return this._step;
    }

    public TaskContentProvider getTaskContentProvider() {
        return this._provider;
    }

    public void setRequirementComponent(Component comp) {
        Component oldComp = this.getRequirementComponent();
        if (comp != oldComp) {
            if (oldComp != null) {
                this.remove(oldComp);
            }
            this._reqComp = comp;
            if (this._reqComp != null) {
                this.add(this._reqComp, (Object)ContentLayout.Position.TOP_LEFT);
            }
            this.firePropertyChange("requirementComponent", oldComp, this._reqComp);
            this.revalidate();
        }
    }

    public Component getRequirementComponent() {
        return this._reqComp;
    }

    public void setDescriptionComponent(Component desc) {
        Component oldDesc = this.getDescriptionComponent();
        if (oldDesc != desc) {
            if (oldDesc != null) {
                this.remove(oldDesc);
            }
            this._descriptionArea = desc;
            if (this._descriptionArea != null) {
                this.add(this._descriptionArea, (Object)ContentLayout.Position.CENTER);
            }
            this.firePropertyChange("descriptionComponent", oldDesc, this._descriptionArea);
            this.revalidate();
        }
    }

    public Component getDescriptionComponent() {
        return this._descriptionArea;
    }

    public void setControlPanel(Component actionPanel) {
        Component oldPanel = this.getControlPanel();
        if (oldPanel != actionPanel) {
            if (oldPanel != null) {
                this.remove(oldPanel);
            }
            this._controlPanel = actionPanel;
            if (this._controlPanel != null) {
                this.add(this._controlPanel, (Object)ContentLayout.Position.TOP_RIGHT);
            }
            this.firePropertyChange("controlPanel", oldPanel, this._controlPanel);
            this.revalidate();
        }
    }

    public Component getControlPanel() {
        return this._controlPanel;
    }

    public void addActionControl(Action action) {
        this._addActionComponet(new JButton(action));
    }

    public void addActionControl(Component comp) {
        this._addActionComponet(comp);
    }

    public void removeActionControl(Action action) {
        int count = this._getActionPanel().getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = this._getActionPanel().getComponent(i);
            if (!(c instanceof AbstractButton) || ((AbstractButton)c).getAction() != action) continue;
            this.removeActionControl(c);
        }
    }

    public void removeActionControl(Component comp) {
        this._getActionPanel().remove(comp);
    }

    public void setHelpPanel(Component helpPanel) {
        Component oldPanel = this.getHelpPanel();
        if (oldPanel != helpPanel) {
            if (oldPanel != null) {
                this.remove(oldPanel);
            }
            this._helpPanel = helpPanel;
            if (this._helpPanel != null) {
                this.add(this._helpPanel, (Object)ContentLayout.Position.CENTER_RIGHT);
            }
            this.firePropertyChange("helpPanel", oldPanel, this._helpPanel);
            this.revalidate();
        }
    }

    public Component getHelpPanel() {
        return this._helpPanel;
    }

    public void setSummaryComponent(Component comp) {
        Component oldSummary = this.getSummaryComponent();
        if (comp != oldSummary) {
            if (oldSummary != null) {
                this.remove(oldSummary);
            }
            this._summary = comp;
            if (this._summary != null) {
                this.add(this._summary, (Object)ContentLayout.Position.BOTTOM);
            }
            this.firePropertyChange("summaryComponent", oldSummary, this._summary);
            this.revalidate();
        }
    }

    public Component getSummaryComponent() {
        return this._summary;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public synchronized void addContentActionListener(ContentActionListener l) {
        this.listenerList.add(ContentActionListener.class, l);
    }

    @Override
    public synchronized void removeContentActionListener(ContentActionListener l) {
        this.listenerList.remove(ContentActionListener.class, l);
    }

    public synchronized ContentActionListener[] getContentActionListeners() {
        return (ContentActionListener[])this.listenerList.getListeners(ContentActionListener.class);
    }

    @Override
    public void setLayout(LayoutManager lm) {
        if (!(lm instanceof ContentLayout)) {
            throw new IllegalArgumentException("Client should not call setLayout");
        }
        super.setLayout(lm);
    }

    protected void fireContentActionPerformed(ContentElement elem) {
        Object[] listeners = this.listenerList.getListenerList();
        ContentActionEvent event = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContentActionListener.class) continue;
            if (event == null) {
                event = new ContentActionEvent(this, elem);
            }
            ((ContentActionListener)listeners[i + 1]).contentActionPerformed(event);
        }
    }

    private static String _sGetDefaultRequirementLabel() {
        return UIBundle.get("CHECKLIST_PREREQUISITES");
    }

    private static String _sGetDefaultSummaryLabel() {
        return UIBundle.get("CHECKLIST_NEXT_STEPS");
    }

    private void _setProvider(TaskContentProvider provider) {
        this._provider = provider;
        if (this._step.isExpanded()) {
            this._stepExpanded();
        }
        this._provider.addPropertyChangeListener(new ProviderListener());
    }

    private void _stepExpanded() {
        ContentElement[] elems;
        if (this._reqDirty) {
            this._updateRequirements();
            this._reqDirty = false;
        }
        if (this._imageDirty) {
            this._updateImage();
            this._imageDirty = false;
        }
        if (this._descriptionDirty) {
            this._updateDescription();
            this._descriptionDirty = false;
        }
        if (this._summaryDirty) {
            this._updateSummary();
            this._summaryDirty = false;
        }
        for (ContentElement element : elems = this._provider.getContentElements()) {
            if (this._linkElementComps != null && this._linkElementComps.containsKey(element)) continue;
            this._addContentElement(element);
        }
        if (this._gotoDirty) {
            this._updateGoToSubsteps();
            this._gotoDirty = false;
        }
    }

    private HeaderPanel _createHeaderPanel(int top, int bottom, boolean expand) {
        HeaderPanel<RichHintLabel> p = new HeaderPanel<RichHintLabel>();
        p.getHeader().setLevel(Header.Level.DIALOG);
        p.getHeader().setExpanded(expand);
        p.getHeader().getComponent(1).setForeground(new Color(77, 77, 77));
        RichHintLabel pane = ChecklistHelper.createLinkLabel();
        p.setHostedComponent(pane);
        p.getHeader().setBorder(BorderFactory.createEmptyBorder());
        ((JComponent)p.getHostedComponent()).setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        p.setBorder(BorderFactory.createEmptyBorder(top, 0, bottom, 12));
        p.getHeader().addHeaderListener(new HeaderListener(){

            @Override
            public void headerExpanded(HeaderEvent he) {
                TaskContent.this.getStep().setSelected(true);
            }

            @Override
            public void headerCollapsed(HeaderEvent event) {
                TaskContent.this.getStep().setSelected(true);
            }
        });
        this._addFocusListenersToSubComps(p, this._scrollListener);
        return p;
    }

    private void _addFocusListenersToSubComps(Container c, FocusListener fa) {
        Component[] comps = c.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof Container) {
                this._addFocusListenersToSubComps((Container)comps[i], fa);
            }
            if (!comps[i].isFocusable()) continue;
            comps[i].addFocusListener(fa);
        }
    }

    private void _populateHeaderPanel(HeaderPanel panel, String title, List<String> items) {
        if (title == null) {
            title = "";
        }
        panel.getHeader().setText(title);
        panel.getHeader().setMinimumChars(title.length());
        String listText = "";
        if (items != null) {
            String[] listOfItems = items.toArray(new String[0]);
            StringBuilder b = new StringBuilder("<html><ul>");
            for (int i = 0; i < listOfItems.length; ++i) {
                b.append("<li>");
                if (listOfItems[i] == null) {
                    listOfItems[i] = "";
                }
                b.append(listOfItems[i]);
            }
            b.append("</ul></html>");
            listText = b.toString();
        }
        RichHintLabel label = (RichHintLabel)panel.getHostedComponent();
        label.setText(listText);
        HTMLDocument doc = (HTMLDocument)label.getDocument();
        HTMLDocument.Iterator iter = doc.getIterator(HTML.Tag.A);
        while (iter.isValid()) {
            String href = (String)iter.getAttributes().getAttribute(HTML.Attribute.HREF);
            String id = (String)iter.getAttributes().getAttribute(HTML.Attribute.ID);
            String labelText = "";
            try {
                int start = iter.getStartOffset();
                int end = iter.getEndOffset();
                labelText = doc.getText(start, end - start);
            }
            catch (BadLocationException start) {
                // empty catch block
            }
            if (href != null) {
                LinkAction action = new LinkAction();
                ContentElement elem = new ContentElement(id, ContentElement.Type.HYPERLINK, labelText, href);
                action.putValue(_INFO_KEY, elem);
                label.registerAction(href, action);
            }
            iter.next();
        }
    }

    private HeaderPanel _getPrerequisiteComponent() {
        if (this._preqPanel == null) {
            this._preqPanel = this._createHeaderPanel(0, 16, true);
        }
        return this._preqPanel;
    }

    private ImageCanvas _getImageCanvas() {
        if (this._canvas == null) {
            this._canvas = new ImageComponent();
            this._canvas.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 12));
        }
        return this._canvas;
    }

    private RichHintLabel _getDescriptionComponent() {
        if (this._descLabel == null) {
            this._descLabel = ChecklistHelper.createLinkLabel(Color.black);
            this._descLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this._descLabel;
    }

    private HeaderPanel _getSummaryComponent() {
        if (this._summaryPanel == null) {
            this._summaryPanel = this._createHeaderPanel(16, 0, false);
        }
        return this._summaryPanel;
    }

    private Container _getActionPanel() {
        Component comp = this.getControlPanel();
        if (comp == null || !(comp instanceof Container)) {
            JPanel actionPanel = new JPanel(){

                @Override
                public void addImpl(Component comp, Object constr, int index) {
                    if (comp instanceof JComponent) {
                        ((JComponent)comp).setAlignmentX(1.0f);
                    }
                    index = comp instanceof SubstepButton ? 0 : index;
                    super.addImpl(comp, constr, index);
                }

                @Override
                public void setEnabled(boolean enable) {
                    Component[] comps;
                    super.setEnabled(enable);
                    for (Component comp : comps = this.getComponents()) {
                        comp.setEnabled(enable);
                    }
                }
            };
            actionPanel.setOpaque(false);
            actionPanel.setLayout(new BoxLayout(actionPanel, 1));
            actionPanel.setBorder(BorderFactory.createEmptyBorder(24, 12, 0, 0));
            comp = actionPanel;
            this.setControlPanel(actionPanel);
        }
        return (Container)comp;
    }

    private void _addActionComponet(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
        }
        this._getActionPanel().add(comp);
    }

    private Container _getLinkPanel() {
        Component comp = this.getHelpPanel();
        if (comp == null || !(comp instanceof Container)) {
            JPanel linkPanel = new JPanel(){

                @Override
                public void addImpl(Component comp, Object constr, int index) {
                    if (comp instanceof JComponent) {
                        ((JComponent)comp).setAlignmentX(0.0f);
                    }
                    super.addImpl(comp, constr, index);
                }
            };
            linkPanel.setOpaque(false);
            linkPanel.setLayout(new BoxLayout(linkPanel, 1));
            linkPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            comp = linkPanel;
            this.setHelpPanel(linkPanel);
        }
        return (Container)comp;
    }

    private void _addLinkComponet(Component comp) {
        if (comp instanceof JComponent) {
            ((JComponent)comp).setBorder(BorderFactory.createEmptyBorder(0, 0, 16, 0));
        }
        this._getLinkPanel().add(comp);
    }

    private void _updateGoToSubsteps() {
        if (!this.getStep().isSimple()) {
            if (this._gotoSubstep == null) {
                this._gotoSubstep = new SubstepButton();
            }
            if (this._gotoSubstep.getParent() != this._getActionPanel()) {
                this._addActionComponet(this._gotoSubstep);
                this.revalidate();
            }
        } else if (this._gotoSubstep != null) {
            this._getActionPanel().remove(this._gotoSubstep);
            this.revalidate();
        }
    }

    private void _updateRequirements() {
        Component headerArea = this.getRequirementComponent();
        HeaderPanel reqsComp = this._getPrerequisiteComponent();
        if (headerArea != null && headerArea != reqsComp) {
            return;
        }
        List<String> reqs = this.getTaskContentProvider().getRequirements();
        if (reqs != null && reqs.size() != 0) {
            String reqTitle = this.getTaskContentProvider().getRequirementsHeaderLabel();
            if (reqTitle == null || "".equals(reqTitle)) {
                reqTitle = TaskContent._sGetDefaultRequirementLabel();
            }
            this._populateHeaderPanel(reqsComp, reqTitle, reqs);
            reqsComp.setVisible(true);
            this.setRequirementComponent(reqsComp);
            this.revalidate();
        } else if (reqsComp == headerArea) {
            reqsComp.setVisible(false);
            this.revalidate();
        }
    }

    private void _updateDescription() {
        Component descArea = this.getDescriptionComponent();
        RichHintLabel descComp = this._getDescriptionComponent();
        if (descArea != null && descArea != descComp) {
            return;
        }
        String description = this.getTaskContentProvider().getDescription();
        if (description != null && !"".equals(description)) {
            descComp.setHtmlText(description);
            descComp.setVisible(true);
            this.setDescriptionComponent(descComp);
            this.revalidate();
        } else if (descComp == descArea) {
            descComp.setVisible(false);
            this.revalidate();
        }
    }

    private void _updateImage() {
        Image image = this.getTaskContentProvider().getImage();
        if (image != null) {
            ImageCanvas canvas = this._getImageCanvas();
            canvas.setImage(image);
            if (canvas.getParent() != this) {
                this.add((Component)this._getImageCanvas(), (Object)ContentLayout.Position.CENTER_LEFT);
            }
        } else if (this._canvas != null) {
            this.remove((Component)((Object)this._canvas));
        }
    }

    private void _updateSummary() {
        Component footerArea = this.getSummaryComponent();
        HeaderPanel summComp = this._getSummaryComponent();
        if (footerArea != null && footerArea != summComp) {
            return;
        }
        List<String> summary = this.getTaskContentProvider().getSummary();
        if (summary != null && summary.size() != 0) {
            String summaryHeader = this.getTaskContentProvider().getSummaryHeaderLabel();
            if (summaryHeader == null || "".equals(summaryHeader)) {
                summaryHeader = TaskContent._sGetDefaultSummaryLabel();
            }
            this._populateHeaderPanel(summComp, summaryHeader, summary);
            summComp.setVisible(true);
            this.setSummaryComponent(summComp);
            this.revalidate();
        } else if (summComp == footerArea) {
            summComp.setVisible(false);
            this.revalidate();
        }
    }

    private void _addContentElement(ContentElement elem) {
        JComponent comp = null;
        switch (elem.getType()) {
            case ACTIONBUTTON: {
                comp = new ActionComponent(elem);
                this._addActionComponet(comp);
                break;
            }
            default: {
                comp = new LinkComponent(elem);
                this._addLinkComponet(comp);
            }
        }
        if (comp != null) {
            if (this._linkElementComps == null) {
                this._linkElementComps = new HashMap();
            }
            this._linkElementComps.put(elem, comp);
        }
    }

    private void _removeContentElement(ContentElement elem) {
        if (this._linkElementComps == null) {
            return;
        }
        Component comp = this._linkElementComps.get(elem);
        if (comp != null) {
            switch (elem.getType()) {
                case ACTIONBUTTON: {
                    this._getActionPanel().remove(comp);
                    break;
                }
                default: {
                    this._getLinkPanel().remove(comp);
                }
            }
        }
    }

    private class ScrollListener
    extends FocusAdapter {
        private ScrollListener() {
        }

        @Override
        public void focusGained(FocusEvent fe) {
            Component c = fe.getComponent();
            Container parent = c.getParent();
            if (parent instanceof JComponent) {
                ((JComponent)parent).scrollRectToVisible(c.getBounds());
            }
        }
    }

    private class ProviderListener
    implements PropertyChangeListener {
        private ProviderListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            String name = pe.getPropertyName();
            if ("requirementHeaderLabel".equals(name) || "requirements".equals(name)) {
                if (TaskContent.this._step.isExpanded()) {
                    TaskContent.this._updateRequirements();
                } else {
                    TaskContent.this._reqDirty = true;
                }
            } else if ("image".equals(name)) {
                if (TaskContent.this._step.isExpanded()) {
                    TaskContent.this._updateImage();
                } else {
                    TaskContent.this._imageDirty = true;
                }
            } else if ("description".equals(name)) {
                if (TaskContent.this._step.isExpanded()) {
                    TaskContent.this._updateDescription();
                } else {
                    TaskContent.this._descriptionDirty = true;
                }
            } else if ("contentElementAdded".equals(name)) {
                if (TaskContent.this._step.isExpanded()) {
                    TaskContent.this._addContentElement((ContentElement)pe.getNewValue());
                }
            } else if ("contentElementRemoved".equals(name)) {
                TaskContent.this._removeContentElement((ContentElement)pe.getOldValue());
            } else if ("summaryHeaderLabel".equals(name) || "summary".equals(name)) {
                if (TaskContent.this._step.isExpanded()) {
                    TaskContent.this._updateSummary();
                } else {
                    TaskContent.this._summaryDirty = true;
                }
            }
        }
    }

    private class StepListener
    implements PropertyChangeListener {
        private StepListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pe) {
            String name = pe.getPropertyName();
            if ("substepAdded".equals(name) || "substepRemoved".equals(name)) {
                if (TaskContent.this._step.isExpanded()) {
                    TaskContent.this._updateGoToSubsteps();
                } else {
                    TaskContent.this._gotoDirty = true;
                }
            } else if ("enabled".equals(name)) {
                TaskContent.this._getActionPanel().setEnabled(Boolean.TRUE.equals(pe.getNewValue()));
            } else if ("expanded".equals(name) && Boolean.TRUE.equals(pe.getNewValue())) {
                TaskContent.this._stepExpanded();
            }
        }
    }

    private class LinkAction
    extends AbstractAction {
        private LinkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TaskContent.this.getStep().setSelected(true);
            TaskContent.this.fireContentActionPerformed((ContentElement)this.getValue(TaskContent._INFO_KEY));
        }
    }

    private class ImageComponent
    extends ImageCanvas {
        private ImageComponent() {
        }

        public Dimension getMinimumSize() {
            return super.getPreferredSize();
        }
    }

    private class SubstepButton
    extends JComponent
    implements Accessible {
        public SubstepButton() {
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    TaskContent.this._step.setDrillDownSubsteps(true);
                }
            };
            String gotoStr = UIBundle.get("CHECKLIST_SUBSTEP");
            RichHintLabel text = ChecklistHelper.createLinkLabel("<a class=bold href=\"http:goto\">" + gotoStr + "</a>", "goto", action);
            JButton gotoSub = new JButton(OracleIcons.getIcon((String)"navigateForward.png"));
            gotoSub.putClientProperty("AccessibleName", gotoStr);
            gotoSub.setHorizontalAlignment(2);
            gotoSub.setBorder(null);
            gotoSub.setContentAreaFilled(false);
            gotoSub.addActionListener(action);
            this.setLayout(new GridBagLayout());
            this.add((Component)text, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 6), 0, 0));
            this.add((Component)gotoSub, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleActionComponent();
            }
            return this.accessibleContext;
        }

        private class AccessibleActionComponent
        extends JComponent.AccessibleJComponent {
            private AccessibleActionComponent() {
                super(SubstepButton.this);
            }
        }
    }

    private class LinkComponent
    extends JComponent
    implements Accessible {
        private ContentElement _info;

        private LinkComponent(ContentElement info) {
            Icon icon = info.getIcon();
            String text = info.getLabel();
            String description = info.getHint();
            this.setLayout(new BoxLayout(this, 0));
            JLabel iconLabel = new JLabel(icon);
            RichHintLabel rLabel = ChecklistHelper.createLinkLabel();
            String richText = text;
            String target = info.getTarget();
            if (richText != null) {
                richText = "<a href=\"" + target + "\">" + richText + "</a>";
            }
            if (description != null && !"".equals(description)) {
                richText = richText + "<br>" + description;
            }
            if (richText != null) {
                rLabel.setHtmlText(richText);
            }
            iconLabel.setAlignmentY(0.0f);
            rLabel.setAlignmentY(0.0f);
            this.add(iconLabel);
            this.add(Box.createRigidArea(new Dimension(8, 0)));
            this.add(rLabel);
            this._info = info;
            if (richText != null) {
                rLabel.registerAction(target, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        TaskContent.this.getStep().setSelected(true);
                        TaskContent.this.fireContentActionPerformed(LinkComponent.this._info);
                    }
                });
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleActionComponent();
            }
            return this.accessibleContext;
        }

        private class AccessibleActionComponent
        extends JComponent.AccessibleJComponent {
            private AccessibleActionComponent() {
                super(LinkComponent.this);
            }
        }
    }

    private class ActionComponent
    extends JComponent
    implements Accessible,
    ActionListener {
        private ContentElement _info;

        public ActionComponent(ContentElement info) {
            String text = info.getLabel();
            Icon icon = info.getIcon();
            String menuPath = info.getHint();
            JButton button = new JButton(text, icon);
            button.addFocusListener(TaskContent.this._scrollListener);
            JLabel path = null;
            if (menuPath != null && !"".equals(menuPath)) {
                path = new JLabel();
                menuPath = menuPath.replace(",", " > ");
                path.setText(menuPath);
                path.setForeground(new Color(204, 204, 204));
                path.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
            }
            this.setLayout(new BoxLayout(this, 1));
            button.setAlignmentX(1.0f);
            this.add(button);
            button.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            if (path != null) {
                path.setAlignmentX(1.0f);
                this.add(path);
            }
            this._info = info;
            button.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            TaskContent.this.getStep().setSelected(true);
            TaskContent.this.fireContentActionPerformed(this._info);
        }

        @Override
        public void setEnabled(boolean enable) {
            Component[] comps;
            super.setEnabled(enable);
            for (Component comp : comps = this.getComponents()) {
                comp.setEnabled(enable);
            }
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleActionComponent();
            }
            return this.accessibleContext;
        }

        private class AccessibleActionComponent
        extends JComponent.AccessibleJComponent {
            private AccessibleActionComponent() {
                super(ActionComponent.this);
            }
        }
    }

    private static class ContentLayout
    implements LayoutManager2 {
        private Component _topLeft;
        private Component _topRight;
        private Component _centerLeft;
        private Component _centerRight;
        private Component _center;
        private Component _bottom;

        private ContentLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
            if (constraints instanceof Position) {
                Position pos = (Position)((Object)constraints);
                switch (pos) {
                    case TOP_LEFT: {
                        this._topLeft = comp;
                        break;
                    }
                    case TOP_RIGHT: {
                        this._topRight = comp;
                        break;
                    }
                    case CENTER_LEFT: {
                        this._centerLeft = comp;
                        break;
                    }
                    case CENTER_RIGHT: {
                        this._centerRight = comp;
                        break;
                    }
                    case CENTER: {
                        this._center = comp;
                        break;
                    }
                    case BOTTOM: {
                        this._bottom = comp;
                    }
                }
            }
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            if (comp == this._topLeft) {
                this._topLeft = null;
            } else if (comp == this._topRight) {
                this._topRight = null;
            } else if (comp == this._centerLeft) {
                this._centerLeft = null;
            } else if (comp == this._centerRight) {
                this._centerRight = null;
            } else if (comp == this._center) {
                this._center = null;
            } else if (comp == this._bottom) {
                this._bottom = null;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Component topLeft = this._getComponent(Position.TOP_LEFT);
            Component topRight = this._getComponent(Position.TOP_RIGHT);
            Component centerLeft = this._getComponent(Position.CENTER_LEFT);
            Component centerRight = this._getComponent(Position.CENTER_RIGHT);
            Component center = this._getComponent(Position.CENTER);
            Component bottom = this._getComponent(Position.BOTTOM);
            Dimension compSize = new Dimension();
            Dimension leftSize = new Dimension();
            Dimension rightSize = new Dimension();
            if (topLeft != null) {
                leftSize.width = topLeft.getMinimumSize().width;
                leftSize.height = topLeft.getPreferredSize().height;
            }
            if (centerLeft != null) {
                Dimension centerLeftSize = centerLeft.getMinimumSize();
                leftSize.width = Math.max(leftSize.width, centerLeftSize.width);
                leftSize.height += centerLeftSize.height;
            }
            if (topRight != null) {
                Dimension topRightSize = topRight.getMinimumSize();
                rightSize.width += topRightSize.width;
                rightSize.height += topRightSize.height;
            }
            if (centerRight != null) {
                Dimension centerRightSize = centerRight.getMinimumSize();
                Dimension size = centerLeft == null ? leftSize : rightSize;
                size.width = Math.max(centerRightSize.width, size.width);
                size.height += centerRight.getPreferredSize().height;
            }
            compSize.width = leftSize.width + rightSize.width;
            compSize.height = Math.max(leftSize.height, rightSize.height);
            if (center != null) {
                Dimension centerSize = center.getMinimumSize();
                compSize.width = Math.max(centerSize.width, compSize.width);
                compSize.height += centerSize.height;
            }
            if (bottom != null) {
                compSize.width = Math.max(bottom.getMinimumSize().width, compSize.width);
                compSize.height += bottom.getPreferredSize().height;
            }
            Insets inset = parent.getInsets();
            compSize.width += inset.left + inset.right;
            compSize.height += inset.top + inset.bottom;
            return compSize;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Component topLeft = this._getComponent(Position.TOP_LEFT);
            Component topRight = this._getComponent(Position.TOP_RIGHT);
            Component centerLeft = this._getComponent(Position.CENTER_LEFT);
            Component centerRight = this._getComponent(Position.CENTER_RIGHT);
            Component center = this._getComponent(Position.CENTER);
            Component bottom = this._getComponent(Position.BOTTOM);
            Dimension compSize = new Dimension();
            Dimension leftSize = new Dimension();
            Dimension rightSize = new Dimension();
            if (topLeft != null) {
                leftSize.width = topLeft.getMinimumSize().width;
            }
            if (centerLeft != null) {
                Dimension centerLeftSize = centerLeft.getPreferredSize();
                leftSize.width = Math.max(leftSize.width, centerLeftSize.width);
                leftSize.height += centerLeftSize.height;
            }
            if (topRight != null) {
                Dimension topRightSize = topRight.getPreferredSize();
                rightSize.width += topRightSize.width;
                rightSize.height += topRightSize.height;
            }
            if (centerRight != null) {
                Dimension centerRightSize = centerRight.getPreferredSize();
                Dimension size = centerLeft == null ? leftSize : rightSize;
                size.width = Math.max(centerRightSize.width, size.width);
                size.height += centerRightSize.height;
            }
            if (topLeft != null) {
                Dimension topLeftSize = topLeft.getPreferredSize();
                if (centerLeft == null && centerRight == null) {
                    leftSize.width = topLeftSize.width;
                }
                leftSize.height += topLeftSize.height;
            }
            compSize.width = leftSize.width + rightSize.width;
            compSize.height = Math.max(leftSize.height, rightSize.height);
            if (center != null) {
                Dimension centerSize = center.getPreferredSize();
                compSize.width = Math.max(centerSize.width, compSize.width);
                compSize.height += centerSize.height;
            }
            if (bottom != null) {
                Dimension bottomSize = bottom.getPreferredSize();
                compSize.width = Math.max(bottomSize.width, compSize.width);
                compSize.height += bottomSize.height;
            }
            Insets inset = parent.getInsets();
            compSize.width += inset.left + inset.right;
            compSize.height += inset.top + inset.bottom;
            return compSize;
        }

        @Override
        public void layoutContainer(Container parent) {
            Component topLeft = this._getComponent(Position.TOP_LEFT);
            Component topRight = this._getComponent(Position.TOP_RIGHT);
            Component centerLeft = this._getComponent(Position.CENTER_LEFT);
            Component centerRight = this._getComponent(Position.CENTER_RIGHT);
            Component center = this._getComponent(Position.CENTER);
            Component bottom = this._getComponent(Position.BOTTOM);
            Rectangle compBounds = parent.getBounds();
            Insets inset = parent.getInsets();
            compBounds.width -= inset.left + inset.right;
            compBounds.height -= inset.top + inset.bottom;
            Dimension leftSize = new Dimension();
            Dimension rightSize = new Dimension();
            Dimension topLeftSize = new Dimension();
            Dimension centerLeftSize = new Dimension();
            Dimension topRightSize = new Dimension();
            Dimension centerRightSize = new Dimension();
            if (topLeft != null) {
                leftSize.width = topLeft.getMinimumSize().width;
            }
            if (centerLeft != null) {
                centerLeftSize = centerLeft.getPreferredSize();
                leftSize.width = Math.max(leftSize.width, centerLeftSize.width);
                leftSize.height += centerLeftSize.height;
            }
            if (topRight != null) {
                topRightSize = topRight.getPreferredSize();
                rightSize.width += topRightSize.width;
                rightSize.height += topRightSize.height;
            }
            if (centerRight != null) {
                centerRightSize = centerRight.getPreferredSize();
                Dimension size = centerLeft == null ? leftSize : rightSize;
                size.width = Math.max(centerRightSize.width, size.width);
                size.height += centerRightSize.height;
            }
            if (topLeft != null) {
                topLeftSize = topLeft.getPreferredSize();
                if (centerLeft == null && centerRight == null) {
                    leftSize.width = topLeftSize.width;
                }
                leftSize.height += topLeftSize.height;
            }
            if (topLeft != null) {
                int width = leftSize.width;
                if (centerLeft == null) {
                    width = compBounds.width - rightSize.width;
                }
                topLeft.setBounds(inset.left, inset.top, width, topLeftSize.height);
            }
            if (centerLeft != null) {
                centerLeft.setBounds(inset.left, inset.top + topLeftSize.height, leftSize.width, centerLeftSize.height);
            }
            if (topRight != null) {
                int diff = Math.max(compBounds.width - topRightSize.width, 0);
                topRight.setBounds(inset.left + diff, inset.top, topRightSize.width, topRightSize.height);
            }
            if (centerRight != null) {
                if (centerLeft != null) {
                    int width = Math.max(compBounds.width - leftSize.width, 0);
                    centerRight.setBounds(inset.left + leftSize.width, inset.top + topRightSize.height, width, centerRightSize.height);
                } else {
                    int width = Math.max(compBounds.width - topRightSize.width, 0);
                    centerRight.setBounds(inset.left, inset.top + topLeftSize.height, width, centerRightSize.height);
                }
            }
            int y = inset.top + Math.max(leftSize.height, rightSize.height);
            if (center != null) {
                Dimension centerSize = center.getPreferredSize();
                center.setBounds(inset.left, y, compBounds.width, centerSize.height);
                y += centerSize.height;
            }
            if (bottom != null) {
                Dimension bottomSize = bottom.getPreferredSize();
                bottom.setBounds(inset.left, y, compBounds.width, bottomSize.height);
            }
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            return null;
        }

        private Component _getComponent(Position pos) {
            Component comp = null;
            switch (pos) {
                case TOP_LEFT: {
                    comp = this._topLeft;
                    break;
                }
                case TOP_RIGHT: {
                    comp = this._topRight;
                    break;
                }
                case CENTER_LEFT: {
                    comp = this._centerLeft;
                    break;
                }
                case CENTER_RIGHT: {
                    comp = this._centerRight;
                    break;
                }
                case CENTER: {
                    comp = this._center;
                    break;
                }
                case BOTTOM: {
                    comp = this._bottom;
                }
            }
            if (comp != null && comp.isVisible()) {
                return comp;
            }
            return null;
        }

        private static enum Position {
            TOP_LEFT,
            TOP_RIGHT,
            CENTER_LEFT,
            CENTER_RIGHT,
            CENTER,
            BOTTOM;

        }
    }
}

