/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.checklist;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import javax.swing.Icon;
import oracle.javatools.ui.checklist.ChecklistModel;
import oracle.javatools.ui.checklist.StepContent;

public final class Step {
    private String _title;
    private Icon _icon;
    private StepStatus _status = StepStatus.NOT_STARTED;
    private boolean _selected;
    private boolean _expanded;
    private boolean _visible = true;
    private boolean _enable = true;
    private Step _parent;
    private ChecklistModel _model;
    private Vector<Step> _substeps = new Vector(3);
    private boolean _substepDrillDown;
    private StepContent _content;
    private PropertyChangeSupport _propertySupport;
    private Listener _listener = new Listener();

    public void setTitle(String title) {
        if (title != this._title) {
            String old = this._title;
            this._title = title;
            this.firePropertyChange("title", old, this._title);
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setIcon(Icon icon) {
        if (icon != this._icon) {
            Icon old = this._icon;
            this._icon = icon;
            this.firePropertyChange("icon", old, this._icon);
        }
    }

    public Icon getIcon() {
        return this._icon;
    }

    public void setStatus(StepStatus status) {
        if (status != this._status) {
            StepStatus old = this._status;
            this._status = status;
            this.firePropertyChange("status", (Object)old, (Object)this._status);
        }
    }

    public StepStatus getStatus() {
        return this._status;
    }

    public void setExpanded(boolean expanded) {
        if (this.isExpanded() != expanded) {
            this._expanded = expanded;
            this.firePropertyChange("expanded", !this._expanded, this._expanded);
        }
    }

    public boolean isExpanded() {
        return this._expanded;
    }

    public void setSelected(boolean selected) {
        if (selected != this.isSelected()) {
            this._selected = selected;
            this.firePropertyChange("selected", !this._selected, this._selected);
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            this._visible = visible;
            this.firePropertyChange("visible", !this._visible, this._visible);
        }
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setEnabled(boolean enable) {
        if (enable != this.isEnabled()) {
            this._enable = enable;
            this.firePropertyChange("enabled", !this._enable, this._enable);
        }
    }

    public boolean isEnabled() {
        return this._enable;
    }

    public void setContent(StepContent content) {
        if (content != this._content) {
            StepContent old = this._content;
            this._content = content;
            this.firePropertyChange("content", old, this._content);
        }
    }

    public StepContent getContent() {
        return this._content;
    }

    public boolean getAllowsSubsteps() {
        return this.getParent() == null;
    }

    public int getSubstepCount() {
        return this._substeps.size();
    }

    public Step getSubstepAt(int index) {
        if (this.getAllowsSubsteps()) {
            return this._substeps.get(index);
        }
        return null;
    }

    public int getSubstepIndex(Step step) {
        return this._substeps.indexOf(step);
    }

    public Step[] getSubsteps() {
        return this._substeps.toArray(new Step[0]);
    }

    public void addSubstep(Step step) {
        if (this.getAllowsSubsteps()) {
            step.removeAllSubsteps();
            this._substeps.add(step);
            Step._sSetParent(step, this);
            this.firePropertyChange("substepAdded", null, step);
            step.addPropertyChangeListener(this._listener);
        }
    }

    public void addSubstep(Step step, int index) {
        if (this.getAllowsSubsteps()) {
            step.removeAllSubsteps();
            this._substeps.add(index, step);
            Step._sSetParent(step, this);
            this.firePropertyChange("substepAdded", null, step);
            step.addPropertyChangeListener(this._listener);
        }
    }

    public void removeSubstep(Step step) {
        if (this._substeps.remove(step)) {
            Step._sSetParent(step, null);
            this.firePropertyChange("substepRemoved", step, null);
            step.removePropertyChangeListener(this._listener);
        }
    }

    public void removeAllSubsteps() {
        if (this.getAllowsSubsteps()) {
            for (int i = 0; i < this._substeps.size(); ++i) {
                this.removeSubstep(this._substeps.get(i));
            }
        }
    }

    public void setDrillDownSubsteps(boolean drillDown) {
        if (drillDown != this.getDrillDownSubsteps() && this.getSubstepCount() > 0) {
            this._substepDrillDown = drillDown;
            this.firePropertyChange("drillDownSubsteps", !this._substepDrillDown, this._substepDrillDown);
        }
    }

    public boolean getDrillDownSubsteps() {
        return this._substepDrillDown;
    }

    public Step getParent() {
        return this._parent;
    }

    public int getIndex() {
        if (this.getParent() != null) {
            return this.getParent().getSubstepIndex(this);
        }
        return this._model != null ? this._model.getStepIndex(this) : -1;
    }

    public boolean isSimple() {
        return this._substeps.size() == 0;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport == null) {
            this._propertySupport = new PropertyChangeSupport(this);
        }
        this._propertySupport.addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertySupport != null) {
            this._propertySupport.removePropertyChangeListener(listener);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._propertySupport != null) {
            this._propertySupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    void setModel(ChecklistModel model) {
        this._model = model;
    }

    private static void _sSetParent(Step child, Step parent) {
        Step old = child._parent;
        child._parent = parent;
        child.firePropertyChange("parent", old, parent);
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("status".equals(evt.getPropertyName())) {
                Step[] steps = Step.this.getSubsteps();
                boolean allDone = true;
                boolean allWillNotDo = true;
                boolean allNotStarted = true;
                for (int i = 0; i < steps.length; ++i) {
                    StepStatus subStatus = steps[i].getStatus();
                    allDone = allDone && subStatus == StepStatus.DONE;
                    allWillNotDo = allWillNotDo && subStatus == StepStatus.WILL_NOT_DO;
                    allNotStarted = allNotStarted && subStatus == StepStatus.NOT_STARTED;
                }
                StepStatus status = allDone ? StepStatus.DONE : (allWillNotDo ? StepStatus.WILL_NOT_DO : (allNotStarted ? StepStatus.NOT_STARTED : StepStatus.IN_PROCESS));
                Step.this.setStatus(status);
            }
        }
    }

    public static enum StepStatus {
        NOT_STARTED,
        IN_PROCESS,
        DONE,
        WILL_NOT_DO;

    }
}

