/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.time.LocalDate;
import java.time.Year;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import oracle.javatools.ui.calendar.CalendarModel;

final class YearComponent
extends JSpinner {
    private CalendarModel model;
    private final int MAX_ALLOWED_YEAR = 9999;
    private final int MIN_ALLOWED_YEAR = 1;

    YearComponent(CalendarModel model) {
        this.model = model;
        model.addPropertyChangeListener(evt -> this.updateYear());
        Year year = Year.from(model.getVisibleDate());
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(year.getValue(), 1, 9999, 1);
        this.setModel(spinnerModel);
        this.setEditor(new JSpinner.NumberEditor((JSpinner)this, "####"));
        this.setValue(year.getValue());
        this.setOpaque(false);
        this.addChangeListener(e -> {
            LocalDate newYear = model.getVisibleDate().withYear((Integer)this.getValue());
            model.setVisibleDate(newYear);
        });
    }

    private void updateYear() {
        int spinnerYear;
        int year = Year.from(this.model.getVisibleDate()).getValue();
        if (year != (spinnerYear = ((Integer)this.getValue()).intValue())) {
            this.setValue(year);
        }
    }
}

