/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.TextStyle;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.ComplexAppearanceManager;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.FormatPainter;
import oracle.bali.ewt.painter.NullPainter;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.ImmInsets;
import oracle.javatools.ui.calendar.CalendarModel;

final class DayComponent
extends JPanel {
    private boolean isSelectionAdjusting = false;
    private SpreadTable dayTable;
    private ArrayTwoDModel tableModel = new ArrayTwoDModel(7, 6);
    private ArrayOneDModel headerModel = new ArrayOneDModel(7);
    private static final int _DAYS_IN_WEEK = 7;
    private static final int _WEEKS_IN_MONTH = 6;
    private Font boldFont;
    private ImmInsets cellInsets = new ImmInsets(0, 0, 0, 0);
    private final CalendarModel model;

    DayComponent(CalendarModel model) {
        this.model = model;
        model.addPropertyChangeListener(evt -> this.refresh(evt.getPropertyName()));
        this.buildTableModel(model.getVisibleDate());
        this.buildColHeaderModel();
        this.dayTable = new CustomSpreadTable((TwoDModel)this.tableModel, (OneDModel)this.headerModel, null);
        this.customizeDayTable();
        this.updateMultiSelect();
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)this.dayTable);
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        this.rebuild(this.model.getVisibleDate());
        this.repaint();
    }

    private void rebuild(LocalDate dateTime) {
        this.buildTableModel(dateTime);
        this.buildColHeaderModel();
        this.dayTable.setModels((TwoDModel)this.tableModel, (OneDModel)this.headerModel, null);
        this.updateSelection();
        this.updateAppearance();
    }

    private void updateSelection() {
        this.isSelectionAdjusting = true;
        TwoDSelection newSelection = new TwoDSelection();
        for (int week = 0; week <= 5; ++week) {
            for (int day = 0; day <= 6; ++day) {
                LocalDate date = this.getDateAt(day, week);
                if (date == null || date.getMonth() != this.model.getVisibleDate().getMonth() || !this.model.isDateSelected(date)) continue;
                TwoDSelection cellSelection = new TwoDSelection(day, week);
                newSelection = newSelection.add(cellSelection);
            }
        }
        try {
            this.dayTable.getGrid().setSelection(newSelection);
            this.dayTable.getGrid().repaint();
        }
        catch (PropertyVetoException veto) {
            System.out.println("ui.calendar.DayPanel._updateSelection: VetoExeception");
        }
        this.isSelectionAdjusting = false;
    }

    private void updateAppearance() {
        ComplexAppearanceManager appMan = (ComplexAppearanceManager)this.dayTable.getGrid().getAppearanceManager();
        for (int week = 0; week < 6; ++week) {
            for (int day = 0; day < 7; ++day) {
                Appearance app = appMan.getCellAppearance(day, week);
                LocalDate date = this.getDateAt(day, week);
                if (date == null || date.getMonth() != this.model.getVisibleDate().getMonth()) {
                    app.setBackground(UIManager.getColor("TextArea.background"));
                    app.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                    app.setFont(this.boldFont);
                    app.setInsets(this.cellInsets);
                } else if (!this.model.canSelectDate(date)) {
                    app.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                    app.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                } else {
                    app.setBackground(UIManager.getColor("Table.background"));
                    app.setForeground(UIManager.getColor("TextArea.foreground"));
                    app.setFont(this.boldFont);
                    app.setInsets(this.cellInsets);
                }
                appMan.setCellAppearance(day, week, app);
            }
        }
    }

    SpreadTable getTable() {
        return this.dayTable;
    }

    private LocalDate getDateAt(int day, int week) {
        LocalDate date = (LocalDate)this.tableModel.getData(day, week);
        return date;
    }

    private void refresh(String propertyName) {
        if (propertyName.equals("visibleDate")) {
            this.rebuild(this.model.getVisibleDate());
        } else if (propertyName.equals("multiSelect")) {
            this.updateMultiSelect();
        }
        this.updateSelection();
        this.updateAppearance();
    }

    private void buildTableModel(LocalDate dateTime) {
        Period period;
        this.model.getVisibleDate().getMonth();
        LocalDate firstDayOfMonth = dateTime = dateTime.minusDays(dateTime.getDayOfMonth() - 1);
        LocalDate firstDayInGrid = dateTime.minusDays(firstDayOfMonth.getDayOfWeek().getValue() - 1);
        int firstDay = this.getFirstDay();
        if (firstDay > 0 && (period = Period.between(firstDayInGrid = firstDayInGrid.minusDays(7 - firstDay), firstDayOfMonth)).getDays() > 6) {
            firstDayInGrid = firstDayInGrid.plusDays(7L);
        }
        LocalDate gridDate = firstDayInGrid;
        for (int w = 0; w < 6; ++w) {
            for (int d = 0; d < 7; ++d) {
                this.tableModel.setData(d, w, (Object)gridDate);
                gridDate = gridDate.plusDays(1L);
            }
        }
    }

    private int getFirstDay() {
        int firstDay = Calendar.getInstance(this.getLocale()).getFirstDayOfWeek();
        if ((firstDay -= 2) < 0) {
            firstDay += 7;
        }
        return firstDay;
    }

    private void buildColHeaderModel() {
        int day = this.getFirstDay() + 1;
        for (int i = 0; i < 7; ++i) {
            DayOfWeek dayOfWeek = DayOfWeek.of(day);
            this.headerModel.setData(i, (Object)dayOfWeek.getDisplayName(TextStyle.SHORT, this.getLocale()));
            if (++day <= 7) continue;
            day = 1;
        }
    }

    private void customizeDayTable() {
        Font baseFont = UIManager.getFont("Label.font");
        this.boldFont = baseFont.deriveFont(1).deriveFont((float)baseFont.getSize() - 1.0f);
        Appearance appearance = this.dayTable.getColumnHeader().getAppearance();
        appearance.setHorizontalJustify(3);
        appearance.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        appearance.setInsets(this.cellInsets);
        Font smallerFont = baseFont.deriveFont((float)baseFont.getSize() - 1.0f);
        appearance.setFont(smallerFont);
        this.dayTable.getColumnHeader().setAppearance(appearance);
        this.dayTable.setColumnHeaderHeight(16);
        this.dayTable.setFont(this.boldFont);
        NullPainter np = new NullPainter();
        this.dayTable.getColumnHeader().setFirstItemBorderPainter((BorderPainter)np);
        this.dayTable.getColumnHeader().setLastItemBorderPainter((BorderPainter)np);
        this.dayTable.getColumnHeader().setHeaderItemBorderPainter((BorderPainter)np);
        this.dayTable.getColumnHeader().setFont(this.boldFont);
        ComplexAppearanceManager appMan = new ComplexAppearanceManager();
        this.dayTable.getGrid().setAppearanceManager((AppearanceManager)appMan);
        appearance = appMan.getAppearance();
        appearance.setHorizontalJustify(3);
        appearance.setVerticalJustify(1);
        appMan.setAppearance(appearance);
        if (this.model.isMultiSelect()) {
            this.dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 2));
        } else {
            this.dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 1));
        }
        this.dayTable.setHorizontalSeparatorsVisible(false);
        this.dayTable.setVerticalSeparatorsVisible(false);
        this.dayTable.getColumnHeader().setCanResizeItems(false);
        FormatPainter datePainter = new FormatPainter((Format)new LocalDateFormat());
        this.dayTable.getGrid().setColumnPainter(0, (Painter)datePainter);
        this.dayTable.getGrid().setColumnPainter(1, (Painter)datePainter);
        this.dayTable.getGrid().setColumnPainter(2, (Painter)datePainter);
        this.dayTable.getGrid().setColumnPainter(3, (Painter)datePainter);
        this.dayTable.getGrid().setColumnPainter(4, (Painter)datePainter);
        this.dayTable.getGrid().setColumnPainter(5, (Painter)datePainter);
        this.dayTable.getGrid().setColumnPainter(6, (Painter)datePainter);
        this.autoSetWidth();
    }

    private void autoSetWidth() {
        int colWidth = this.getMinColSize();
        this.dayTable.getGrid().setColumnWidth(0, colWidth);
        this.dayTable.getGrid().setColumnWidth(1, colWidth);
        this.dayTable.getGrid().setColumnWidth(2, colWidth);
        this.dayTable.getGrid().setColumnWidth(3, colWidth);
        this.dayTable.getGrid().setColumnWidth(4, colWidth);
        this.dayTable.getGrid().setColumnWidth(5, colWidth);
        this.dayTable.getGrid().setColumnWidth(6, colWidth);
        this.dayTable.getColumnHeader().setPreferredHeaderSize(colWidth * 7);
    }

    private int getMinColSize() {
        int minSize = 0;
        FontMetrics fmetrics = this.getFontMetrics(this.boldFont);
        for (DayOfWeek day : DayOfWeek.values()) {
            String name = day.getDisplayName(TextStyle.SHORT_STANDALONE, this.getLocale());
            int width = SwingUtilities.computeStringWidth(fmetrics, name);
            minSize = Math.max(minSize, width += this.cellInsets.left + this.cellInsets.right);
        }
        for (int i = 1; i <= 31; ++i) {
            int width = SwingUtilities.computeStringWidth(fmetrics, new Integer(i).toString());
            minSize = Math.max(minSize, width);
        }
        int sepSize = this.dayTable.getColumnGeometryManager().getSeparatorSize();
        return minSize += sepSize;
    }

    private void updateMultiSelect() {
        if (this.model.isMultiSelect()) {
            this.dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 2));
        } else {
            this.dayTable.getGrid().setGridSelectionManager((GridSelectionManager)new DayGridSelectionManager(0, 0, 1));
        }
    }

    private static class LocalDateFormat
    extends Format {
        private LocalDateFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            LocalDate localDate = (LocalDate)obj;
            int day = localDate.getDayOfMonth();
            StringBuffer sb = new StringBuffer("" + day);
            return sb;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return LocalDate.parse(source);
        }
    }

    private class DayGridSelectionManager
    extends GeneralGridSelectionManager {
        public DayGridSelectionManager(int columnConstraint, int rowConstraint, int cellConstraint) {
            super(columnConstraint, rowConstraint, cellConstraint);
        }

        public TwoDSelection modifySelection(TwoDSelection oldSelection, TwoDSelection newSelection, int how) {
            if (!DayComponent.this.isSelectionAdjusting) {
                switch (how) {
                    case 0: {
                        DayComponent.this.model.clearSelectedDates();
                    }
                    case 2: {
                        newSelection = !DayComponent.this.model.isMultiSelect() ? this.addSingleSelection(newSelection) : this.addMultiSelection(newSelection);
                        break;
                    }
                    case 1: {
                        this._removeSelection(newSelection);
                    }
                }
            }
            if (newSelection == null) {
                DayComponent.this.updateSelection();
                newSelection = this.getSelection();
                how = 0;
            }
            return super.modifySelection(oldSelection, newSelection, how);
        }

        private TwoDSelection addSingleSelection(TwoDSelection newValue) {
            DayComponent.this.model.clearSelectedDates();
            CellRange[] cellRanges = newValue.getCellRanges();
            if (cellRanges != null) {
                LocalDate newDate = DayComponent.this.getDateAt(newValue.getSingleCell().column, newValue.getSingleCell().row);
                if (newDate != null && newDate.getMonth() == DayComponent.this.model.getVisibleDate().getMonth() && DayComponent.this.model.canSelectDate(newDate)) {
                    DayComponent.this.model.setSelectedDate(newDate);
                } else {
                    newValue = newValue.subtract(newValue);
                }
            }
            return newValue;
        }

        private TwoDSelection addMultiSelection(TwoDSelection newValue) {
            CellRange[] cellRanges = newValue.getCellRanges();
            if (cellRanges != null) {
                for (int rangeIndex = 0; rangeIndex < cellRanges.length; ++rangeIndex) {
                    CellRange range = cellRanges[rangeIndex];
                    for (int x = range.getLowerLimit().column; x <= range.getUpperLimit().column; ++x) {
                        for (int y = range.getLowerLimit().row; y <= range.getUpperLimit().row; ++y) {
                            LocalDate newDate = DayComponent.this.getDateAt(x, y);
                            if (newDate != null && newDate.getMonth() == DayComponent.this.model.getVisibleDate().getMonth() && DayComponent.this.model.canSelectDate(newDate)) {
                                DayComponent.this.model.addSelectedDate(newDate);
                                continue;
                            }
                            TwoDSelection removeCell = new TwoDSelection(new Cell(x, y));
                            newValue = newValue.subtract(removeCell);
                        }
                    }
                }
            }
            return newValue;
        }

        private void _removeSelection(TwoDSelection newValue) {
            CellRange[] cellRanges = newValue.getCellRanges();
            if (cellRanges != null) {
                for (int rangeIndex = 0; rangeIndex < cellRanges.length; ++rangeIndex) {
                    CellRange range = cellRanges[rangeIndex];
                    for (int x = range.getLowerLimit().column; x <= range.getUpperLimit().column; ++x) {
                        for (int y = range.getLowerLimit().row; y <= range.getUpperLimit().row; ++y) {
                            LocalDate newDate = DayComponent.this.getDateAt(x, y);
                            if (newDate == null || newDate.getMonth() != DayComponent.this.model.getVisibleDate().getMonth()) continue;
                            DayComponent.this.model.removeSelectedDate(newDate);
                        }
                    }
                }
            }
        }
    }

    private class CustomSpreadTable
    extends SpreadTable {
        public CustomSpreadTable(TwoDModel gridModel, OneDModel columnHeaderModel, OneDModel rowHeaderModel) {
            super(gridModel, columnHeaderModel, rowHeaderModel);
            this.setBorder(null);
        }

        protected Grid createGrid(TwoDModel ds) {
            return new CustomGrid(ds);
        }

        protected Header createColumnHeader(OneDModel ds) {
            return new CustomColumnHeader(ds);
        }

        private class CustomKeyHandler
        extends StandardGridKeyHandler {
            private CustomKeyHandler() {
            }

            protected Cell enter(Grid grid, Cell focusCell, KeyEvent e, boolean shiftDown) {
                return focusCell;
            }
        }

        private class CustomColumnHeader
        extends Header {
            public CustomColumnHeader(OneDModel ds) {
                super(ds);
            }

            public boolean isFocusable() {
                return false;
            }

            public Header.AccessibleHeader createAccessibleHeader() {
                return new AccessibleDayHeader();
            }

            private class AccessibleDayHeader
            extends Header.AccessibleHeader {
                private AccessibleDayHeader() {
                    super((Header)CustomColumnHeader.this);
                }

                public String getAccessibleName(int index) {
                    DayOfWeek dayOfWeek = DayOfWeek.of(index + 1);
                    String name = dayOfWeek.getDisplayName(TextStyle.FULL, this.getLocale());
                    return name;
                }
            }
        }

        private class CustomGrid
        extends Grid {
            public CustomGrid(TwoDModel ds) {
                super(ds);
                this.setGridKeyHandler((GridKeyHandler)new CustomKeyHandler());
            }
        }
    }
}

