/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.calendar;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import oracle.javatools.ui.calendar.CalendarDateProvider;

public final class CalendarModel {
    private LocalDate visibleDate;
    private ZoneId zoneId;
    private LocalTime time;
    private Set<LocalDate> dates = new TreeSet<LocalDate>();
    private LocalDate minDate;
    private LocalDate maxDate;
    private CalendarDateProvider provider;
    private boolean isMultiSelect = false;
    private boolean showTime = false;
    private boolean editTime = false;
    private PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport(this);

    public CalendarModel() {
        ZonedDateTime zdt = ZonedDateTime.now();
        this.visibleDate = zdt.toLocalDate();
        this.zoneId = zdt.getZone();
        this.time = zdt.toLocalTime();
    }

    public static LocalDate dateToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static Date localDateToDate(LocalDate localDate) {
        Instant instant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    Date getDateTime() {
        LocalTime localTime = this.getTime();
        LocalDateTime localDateTime = localTime.atDate(LocalDate.now());
        Instant instant = localDateTime.atZone(this.getZoneId()).toInstant();
        Date dateTime = Date.from(instant);
        return dateTime;
    }

    public boolean canSelectDate(LocalDate date) {
        if (!this.dateInBounds(date)) {
            return false;
        }
        return this.provider == null || this.provider.isDateValid(date, this.zoneId);
    }

    private boolean dateInBounds(LocalDate date) {
        if (this.minDate == null && this.maxDate == null) {
            return true;
        }
        if (date == null) {
            return false;
        }
        if (this.minDate != null && date.isBefore(this.minDate)) {
            return false;
        }
        return this.maxDate == null || !date.isAfter(this.maxDate);
    }

    private void verifySelectedDates() {
        Iterator<LocalDate> it = this.dates.iterator();
        while (it.hasNext()) {
            LocalDate date = it.next();
            if (this.canSelectDate(date)) continue;
            it.remove();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this._propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this._propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void setZoneId(ZoneId zoneId) {
        if (this.zoneId.equals(zoneId)) {
            return;
        }
        ZoneId oldZoneId = this.zoneId;
        this.zoneId = zoneId;
        ZonedDateTime zdt = ZonedDateTime.of(this.getVisibleDate(), this.time, oldZoneId);
        Instant ins = zdt.toInstant();
        ZonedDateTime newZdt = ZonedDateTime.ofInstant(ins, zoneId);
        LocalTime newTime = newZdt.toLocalTime();
        this.setTime(newTime);
        this._propertyChangeSupport.firePropertyChange("zoneId", oldZoneId, zoneId);
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setTime(LocalTime time) {
        if (this.time.equals(time)) {
            return;
        }
        LocalTime oldTime = this.time;
        this.time = time;
        this._propertyChangeSupport.firePropertyChange("time", oldTime, time);
    }

    public LocalTime getTime() {
        return this.time;
    }

    public void setSelectedDates(Set<LocalDate> selectedDates) {
        if (!this.isMultiSelect && selectedDates.size() > 1) {
            throw new IllegalArgumentException("Attempt to select multiple dates in a single select calendar");
        }
        TreeSet<LocalDate> oldSelectedDates = new TreeSet<LocalDate>(this.dates);
        this.dates.clear();
        this.dates.addAll(selectedDates);
        this.verifySelectedDates();
        this._propertyChangeSupport.firePropertyChange("selectedDates", oldSelectedDates, Collections.unmodifiableSet(this.dates));
    }

    public void setSelectedDate(LocalDate selectedDate) {
        this.setSelectedDates(Collections.singleton(selectedDate));
    }

    public boolean isDateSelected(LocalDate date) {
        return this.dates.contains(date);
    }

    @Deprecated
    Date[] getSelectedDatesDeprecated() {
        Set<ZonedDateTime> zDates = this.getSelectedDates();
        Date[] dateArray = new Date[zDates.size()];
        int i = 0;
        for (ZonedDateTime d : zDates) {
            dateArray[i++] = Date.from(d.toInstant());
        }
        return dateArray;
    }

    @Deprecated
    void setSelectedDate(Date date) {
        LocalDate localDate = CalendarModel.dateToLocalDate(date);
        LocalTime localTime = date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
        this.setSelectedDate(localDate);
        this.setTime(localTime);
    }

    @Deprecated
    void setSelectedDatesDeprecated(Date[] dates) {
        for (Date date : dates) {
            this.setSelectedDate(date);
        }
    }

    public void addSelectedDate(LocalDate date) {
        if (!this.isMultiSelect) {
            this.setSelectedDate(date);
        }
        TreeSet<LocalDate> oldSelectedDates = new TreeSet<LocalDate>(this.dates);
        this.dates.add(date);
        this.verifySelectedDates();
        this._propertyChangeSupport.firePropertyChange("selectedDates", oldSelectedDates, Collections.unmodifiableSet(this.dates));
    }

    public void removeSelectedDate(LocalDate date) {
        if (!this.dates.contains(date)) {
            return;
        }
        TreeSet<LocalDate> oldSelectedDates = new TreeSet<LocalDate>(this.dates);
        this.dates.remove(date);
        this.verifySelectedDates();
        this._propertyChangeSupport.firePropertyChange("selectedDates", oldSelectedDates, Collections.unmodifiableSet(this.dates));
    }

    public void clearSelectedDates() {
        if (this.dates.isEmpty()) {
            return;
        }
        TreeSet<LocalDate> oldSelectedDates = new TreeSet<LocalDate>(this.dates);
        this.dates.clear();
        this._propertyChangeSupport.firePropertyChange("selectedDates", oldSelectedDates, Collections.emptySet());
    }

    public Set<ZonedDateTime> getSelectedDates() {
        if (this.dates.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<ZonedDateTime> zDates = new TreeSet<ZonedDateTime>();
        for (LocalDate date : this.dates) {
            zDates.add(ZonedDateTime.of(date, this.getTime(), this.getZoneId()));
        }
        return zDates;
    }

    public ZonedDateTime getSelectedDate() {
        if (this.dates.isEmpty()) {
            return null;
        }
        LocalDate date = this.dates.iterator().next();
        ZonedDateTime zdt = ZonedDateTime.of(date, this.getTime(), this.getZoneId());
        return zdt;
    }

    public void setSelectedDate(ZonedDateTime date) {
        this.setZoneId(date.getZone());
        this.setTime(date.toLocalTime());
        this.setSelectedDate(date.toLocalDate());
    }

    public void setMinDate(LocalDate minDate) {
        if (this.minDate != null && this.minDate.equals(minDate)) {
            return;
        }
        LocalDate oldMinDate = this.minDate;
        this.minDate = minDate;
        this.verifySelectedDates();
        this._propertyChangeSupport.firePropertyChange("minDate", oldMinDate, minDate);
    }

    public LocalDate getMinDate() {
        return this.minDate;
    }

    public void setMaxDate(LocalDate maxDate) {
        if (this.maxDate != null && this.maxDate.equals(maxDate)) {
            return;
        }
        LocalDate oldMaxDate = this.maxDate;
        this.maxDate = maxDate;
        this.verifySelectedDates();
        this._propertyChangeSupport.firePropertyChange("maxDate", oldMaxDate, maxDate);
    }

    public LocalDate getMaxDate() {
        return this.maxDate;
    }

    public void setProvider(CalendarDateProvider provider) {
        if (this.provider != null && this.provider.equals(provider)) {
            return;
        }
        CalendarDateProvider oldProvider = this.provider;
        this.provider = provider;
        this.verifySelectedDates();
        this._propertyChangeSupport.firePropertyChange("provider", oldProvider, provider);
    }

    public CalendarDateProvider getProvider() {
        return this.provider;
    }

    public void setMultiSelect(boolean isMultiSelect) {
        if (this.isMultiSelect == isMultiSelect) {
            return;
        }
        this.clearSelectedDates();
        boolean oldIsMultiSelect = this.isMultiSelect;
        this.isMultiSelect = isMultiSelect;
        this._propertyChangeSupport.firePropertyChange("multiSelect", oldIsMultiSelect, isMultiSelect);
    }

    public boolean isMultiSelect() {
        return this.isMultiSelect;
    }

    public void setVisibleDate(LocalDate visibleDate) {
        if (this.visibleDate.equals(visibleDate)) {
            return;
        }
        LocalDate oldVisibleDate = this.visibleDate;
        this.visibleDate = visibleDate;
        this._propertyChangeSupport.firePropertyChange("visibleDate", oldVisibleDate, visibleDate);
    }

    public LocalDate getVisibleDate() {
        return this.visibleDate;
    }

    public void setShowTime(boolean showTime) {
        boolean oldShowTime = this.showTime;
        this.showTime = showTime;
        this._propertyChangeSupport.firePropertyChange("showTime", oldShowTime, showTime);
    }

    public boolean isShowTime() {
        return this.showTime;
    }

    public void setEditTime(boolean editTime) {
        boolean oldEditTime = this.editTime;
        this.editTime = editTime;
        this._propertyChangeSupport.firePropertyChange("editTime", oldEditTime, editTime);
    }

    public boolean isEditTime() {
        return this.editTime;
    }
}

