/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import oracle.bali.ewt.graphics.JoiningIcon;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.builders.BasicBuilder;
import oracle.javatools.ui.builders.BuiltToolBar;
import oracle.javatools.ui.builders.ToolBarBuilder;
import oracle.javatools.ui.search.PromptedTextField;
import oracle.javatools.ui.search.SearchField;

class BuiltToolBarImpl
implements BuiltToolBar {
    private JToolBar toolBar;
    private SearchField searchField = null;

    BuiltToolBarImpl(ToolBarBuilder.ToolBarInstructions instructions) {
        this.toolBar = instructions.toolBar;
        this.toolBar.setFloatable(false);
        if (instructions.searchStyle != null) {
            if (instructions.searchPrompt == null) {
                instructions.searchPrompt = "";
            }
            PromptedTextField tf = new PromptedTextField();
            tf.setPrompt(instructions.searchPrompt);
            tf.setColumns(14);
            tf.setMaximumSize(tf.getPreferredSize());
            this.searchField = new SearchField(tf, instructions.searchStyle);
            this.searchField.setMaximumSize(this.searchField.getPreferredSize());
            this.toolBar.add(this.searchField);
        }
        this.addItems(instructions.leftContents);
        this.toolBar.add(Box.createHorizontalGlue());
        this.addItems(instructions.rightContents);
        if (!instructions.moreToolbarActions.isEmpty()) {
            String text = instructions.moreActionsText == null ? UIBundle.get("TOOLBAR_MORE_ACTIONS") : instructions.moreActionsText;
            this.toolBar.add(this.createDropButton(text, instructions.moreToolbarActions));
        }
    }

    private void addItems(List<Object> items) {
        for (Object item : items) {
            if (item instanceof Action) {
                this.toolBar.add((Action)item);
                continue;
            }
            if (item == "SEPARATOR_ITEM") {
                this.toolBar.addSeparator();
                continue;
            }
            if (item instanceof ToolBarBuilder.DropAction) {
                ToolBarBuilder.DropAction dropAction = (ToolBarBuilder.DropAction)item;
                if (dropAction.icon == null) {
                    this.toolBar.add(this.createDropButton(dropAction.text, dropAction.actions));
                    continue;
                }
                this.toolBar.add(this.createDropButton(dropAction.icon, dropAction.text, dropAction.actions));
                continue;
            }
            if (!(item instanceof JComponent)) continue;
            this.toolBar.add((JComponent)item);
        }
    }

    private JComponent createDropButton(String text, List<Action> actions) {
        JButton button = new JButton(StringUtils.stripMnemonic((String)text), OracleIcons.getIcon((String)"extras/dropdown_small.png"));
        button.addActionListener(new BasicBuilder.MoreActionsL(actions));
        int mnemonic = StringUtils.getMnemonicKeyCode((String)text);
        if (mnemonic != 0) {
            button.setMnemonic(mnemonic);
        }
        button.setHorizontalTextPosition(10);
        return button;
    }

    private JComponent createDropButton(Icon icon, String tiptext, List<Action> actions) {
        JoiningIcon joiningIcon = new JoiningIcon(icon, OracleIcons.getIcon((String)"extras/dropdown_small.png"));
        JButton button = new JButton((Icon)joiningIcon);
        button.addActionListener(new BasicBuilder.MoreActionsL(actions));
        button.setToolTipText(tiptext);
        button.setHorizontalTextPosition(10);
        return button;
    }

    @Override
    public JComponent getGUI() {
        return this.toolBar;
    }

    @Override
    public JToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public SearchField getSearchField() {
        return this.searchField;
    }
}

