/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui.builders;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.TextLayer;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.builders.BuiltBasic;
import oracle.javatools.util.ListenableCollection;
import oracle.javatools.util.ListenableHashSet;

public abstract class BasicBuilder<T> {
    protected Instructions instructions = this.createInstructions();

    protected BasicBuilder() {
    }

    protected abstract Instructions createInstructions();

    protected void buildToolbar(BuiltBasic builtBasic) {
        if (!this.instructions.titlebar) {
            return;
        }
        if (this.instructions.toolbarObjects.isEmpty() && this.instructions.moreToolbarActions.isEmpty()) {
            return;
        }
        ControlBar controlBar = builtBasic.getComponentWithTitlebar().getControlBar();
        for (Object object : this.instructions.toolbarObjects) {
            if (object instanceof JComponent) {
                controlBar.add((JComponent)object);
                continue;
            }
            if (!(object instanceof Action)) continue;
            controlBar.add((Action)object);
        }
        if (!this.instructions.moreToolbarActions.isEmpty()) {
            String text = this.instructions.moreActionsText == null ? UIBundle.get("TOOLBAR_MORE_ACTIONS") : this.instructions.moreActionsText;
            JButton button = new JButton(StringUtils.stripMnemonic((String)text), OracleIcons.getIcon((String)"extras/dropdown_small.png"));
            button.addActionListener(new MoreActionsL(this.instructions.moreToolbarActions));
            int mnemonic = StringUtils.getMnemonicKeyCode((String)text);
            if (mnemonic != 0) {
                button.setMnemonic(mnemonic);
            }
            button.setHorizontalTextPosition(10);
            controlBar.add(button);
        }
    }

    public void setResizable(boolean resizable) {
        this.instructions.resize = resizable;
    }

    public void setEmptyText(String emptyText) {
        this.instructions.emptyText = emptyText;
    }

    public void setEmptyTextLarge(String emptyText) {
        this.instructions.emptyText = emptyText;
        this.instructions.emptyTextFont = TextLayer.LARGE_FONT;
    }

    public void setDoubleClickListener(ActionListener actionListener) {
        this.instructions.doubleClickListener = actionListener;
    }

    public void setLabel(String labelText) {
        this.instructions.labelText = labelText;
    }

    public void setTitlebar(boolean titlebar) {
        this.instructions.titlebar = titlebar;
    }

    public void setActions(Action ... actions) {
        this.instructions.titlebar = true;
        for (Action action : actions) {
            this.instructions.toolbarObjects.add(action);
        }
    }

    public void setToolbarComponents(JComponent ... components) {
        this.instructions.titlebar = true;
        for (JComponent component : components) {
            this.instructions.toolbarObjects.add(component);
        }
    }

    public void setActionsSecondary(Action ... actions) {
        this.setActionsSecondary((String)null, actions);
    }

    public void setActionsSecondary(String moreActionsText, Action ... actions) {
        this.instructions.titlebar = true;
        this.instructions.moreActionsText = moreActionsText;
        for (Action action : actions) {
            this.instructions.moreToolbarActions.add(action);
        }
    }

    public void setSelection(T ... selection) {
        this.instructions.selection = selection;
    }

    public ListenableCollection<T> setCheckable(Collection<T> initiallyCheckedItems) {
        this.instructions.checkedItems = initiallyCheckedItems == null ? null : new ListenableHashSet(initiallyCheckedItems);
        return this.instructions.checkedItems;
    }

    public void setRollover(boolean rollover) {
        this.instructions.rollover = rollover;
    }

    public void setSelectionEnabledComponent(JComponent component) {
        this.instructions.selectionEnabledComponents.add(component);
    }

    public void setSelectionEnabledAction(Action action) {
        this.instructions.selectionEnabledActions.add(action);
    }

    static class MoreActionsL
    implements ActionListener {
        private List<Action> moreToolbarActions;

        MoreActionsL(List<Action> moreToolbarActions) {
            this.moreToolbarActions = moreToolbarActions;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton b = (JButton)e.getSource();
            JPopupMenu menu = new JPopupMenu();
            for (Action action : this.moreToolbarActions) {
                menu.add(action);
            }
            menu.show(b, 0, b.getHeight());
        }
    }

    protected class Instructions {
        protected boolean resize = false;
        protected ActionListener doubleClickListener;
        protected boolean titlebar = false;
        protected String labelText;
        protected List toolbarObjects = new ArrayList();
        protected List<Action> moreToolbarActions = new ArrayList<Action>();
        protected String moreActionsText;
        protected String emptyText;
        protected Font emptyTextFont = TextLayer.REGULAR_FONT;
        boolean rollover = false;
        T[] selection = null;
        Set<JComponent> selectionEnabledComponents = new HashSet<JComponent>();
        Set<Action> selectionEnabledActions = new HashSet<Action>();
        ListenableCollection<T> checkedItems;

        protected Instructions() {
        }
    }
}

