/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.javatools.ui.TriStateButtonModel;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;

public class TriStateCheckBox
extends JCheckBox {
    private boolean initialized = false;
    private static boolean isOLAF = UIManager.getLookAndFeel() instanceof OracleLookAndFeel;
    private static final int STROKE_INDENT = isOLAF ? 2 : 3;
    private static final int STROKE_WIDTH = 3;
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();

    public TriStateCheckBox() {
        this("");
    }

    public TriStateCheckBox(Icon icon) {
        this("", icon, State.FALSE);
    }

    public TriStateCheckBox(Icon icon, State state) {
        this("", icon, state);
    }

    public TriStateCheckBox(String text) {
        this(text, null, State.FALSE);
    }

    public TriStateCheckBox(String text, State state) {
        this(text, null, state);
    }

    public TriStateCheckBox(String text, Icon icon) {
        this(text, icon, State.FALSE);
    }

    public TriStateCheckBox(String text, Icon icon, State state) {
        super(text, icon, false);
        this.setModel(new TriStateButtonModel());
        this.setRolloverEnabled(true);
        this.initialized = true;
        this.setState(state);
    }

    private TriStateButtonModel getTriModel() {
        return (TriStateButtonModel)this.getModel();
    }

    private boolean isPartial() {
        return this.getTriModel().isPartial();
    }

    private void setPartial(boolean isPartial) {
        this.getTriModel().setPartial(isPartial);
    }

    @Override
    public void setModel(ButtonModel newModel) {
        if (this.initialized && !(newModel instanceof TriStateButtonModel)) {
            throw new IllegalArgumentException("TriStateCheckbox requires a model of type TriStateButtonModel");
        }
        super.setModel(newModel);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isPartial()) {
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics(f);
            Insets i = this.getInsets();
            size = this.getSize(size);
            TriStateCheckBox.viewRect.x = i.left;
            TriStateCheckBox.viewRect.y = i.top;
            TriStateCheckBox.viewRect.width = TriStateCheckBox.size.width - (i.right + TriStateCheckBox.viewRect.x);
            TriStateCheckBox.viewRect.height = TriStateCheckBox.size.height - (i.bottom + TriStateCheckBox.viewRect.y);
            TriStateCheckBox.iconRect.height = 0;
            TriStateCheckBox.iconRect.width = 0;
            TriStateCheckBox.iconRect.y = 0;
            TriStateCheckBox.iconRect.x = 0;
            TriStateCheckBox.textRect.height = 0;
            TriStateCheckBox.textRect.width = 0;
            TriStateCheckBox.textRect.y = 0;
            TriStateCheckBox.textRect.x = 0;
            Icon altIcon = UIManager.getIcon("CheckBox.icon");
            SwingUtilities.layoutCompoundLabel(this, fm, this.getText(), altIcon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), viewRect, iconRect, textRect, this.getText() == null ? 0 : this.getIconTextGap());
            if (this.model instanceof TriStateButtonModel && Themes.isThemed()) {
                ThemeProperties properties = Themes.getActiveTheme().getPartProperties("checkbox.partial");
                altIcon = properties.getIcon("image");
                altIcon.paintIcon(this, g, TriStateCheckBox.iconRect.x, TriStateCheckBox.iconRect.y);
            } else {
                this.paintPartialOverlay(this, g, TriStateCheckBox.iconRect.x, TriStateCheckBox.iconRect.y, altIcon.getIconWidth(), altIcon.getIconHeight());
            }
        }
    }

    private void paintPartialOverlay(JComponent c, Graphics g, int x, int y, int width, int height) {
        BasicStroke stroke = new BasicStroke(3.0f, 1, 1);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.isEnabled() ? UIManager.getColor("controlDkShadow") : UIManager.getColor("controlShadow"));
        g2.setStroke(stroke);
        int y1 = y + height / 2;
        int x1 = x + STROKE_INDENT + 1;
        if (!isOLAF) {
            ++x1;
        }
        g2.drawLine(x1, y1, x + width - STROKE_INDENT * 2, y1);
    }

    public State getState() {
        if (this.isPartial()) {
            return State.PARTIAL;
        }
        if (this.isSelected()) {
            return State.TRUE;
        }
        return State.FALSE;
    }

    public void setState(State state) {
        if (state == this.getState()) {
            return;
        }
        if (state == State.PARTIAL) {
            this.setPartial(true);
        } else {
            this.setSelected(state == State.TRUE);
        }
    }

    public void setCanUserSetPartial(boolean userCanSetPartial) {
        this.getTriModel().setCanUserSetPartial(userCanSetPartial);
    }

    public boolean canUserSetPartial() {
        return this.getTriModel().canUserSetPartial();
    }

    public void setDirection(boolean directionTruePartialFalse) {
        this.getTriModel().setDirection(directionTruePartialFalse);
    }

    public boolean getDirection() {
        return this.getTriModel().getDirection();
    }

    public static enum State {
        TRUE,
        FALSE,
        PARTIAL;

    }
}

