/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.ComponentOrientation;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public final class StringUtils {
    private static final int CHAR_BUFFER_SIZE = 100;
    private static final Object charsBufferLock = new Object();
    private static char[] charsBuffer = new char[100];

    private StringUtils() {
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap, int ellipsesLocation) {
        int gap;
        horizontalAlignment = StringUtils.getAbsoluteAlignment(horizontalAlignment);
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        int lsb = 0;
        int rsb = 0;
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
            gap = 0;
        } else {
            gap = icon == null ? 0 : textIconGap;
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = Math.min(availTextWidth, (int)v.getPreferredSpan(0));
                textR.height = (int)v.getPreferredSpan(1);
            } else {
                textR.width = SwingUtilities2.stringWidth(c, fm, text);
                lsb = SwingUtilities2.getLeftSideBearing(c, fm, text);
                if (lsb < 0) {
                    textR.width -= lsb;
                }
                if (textR.width > availTextWidth) {
                    text = StringUtils.clipString(c, fm, text, availTextWidth, ellipsesLocation);
                    textR.width = SwingUtilities2.stringWidth(c, fm, text);
                }
                textR.height = fm.getHeight();
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        if (lsb < 0) {
            textR.x -= lsb;
            textR.width += lsb;
        }
        if (rsb > 0) {
            textR.width -= rsb;
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String clipString(JComponent c, FontMetrics fm, String string, int availTextWidth, int clipLocation) {
        String clipString = "...";
        int stringLength = string.length();
        availTextWidth -= SwingUtilities2.stringWidth(c, fm, clipString);
        boolean needsTextLayout = false;
        Object object = charsBufferLock;
        synchronized (object) {
            if (charsBuffer == null || charsBuffer.length < stringLength) {
                charsBuffer = string.toCharArray();
            } else {
                string.getChars(0, stringLength, charsBuffer, 0);
            }
            needsTextLayout = SwingUtilities2.isComplexLayout(charsBuffer, 0, stringLength);
            int width = 0;
            switch (clipLocation) {
                case 10: {
                    for (int nChars = stringLength - 1; nChars >= 0; --nChars) {
                        if ((width += fm.charWidth(charsBuffer[nChars])) <= availTextWidth) continue;
                        string = string.substring(nChars + 1);
                        break;
                    }
                    string = clipString + string;
                    break;
                }
                case 11: {
                    for (int nChars = 0; nChars < stringLength; ++nChars) {
                        if ((width += fm.charWidth(charsBuffer[nChars])) <= availTextWidth) continue;
                        string = string.substring(0, nChars);
                        break;
                    }
                    string = string + clipString;
                    break;
                }
                case 0: {
                    boolean addLeft = true;
                    int leftCount = 0;
                    int rightCount = 0;
                    for (int nChars = 0; nChars < stringLength; ++nChars) {
                        int i;
                        int n = i = addLeft ? leftCount : stringLength - 1 - rightCount;
                        if ((width += fm.charWidth(charsBuffer[i])) > availTextWidth) break;
                        leftCount += addLeft ? 1 : 0;
                        rightCount += addLeft ? 0 : 1;
                        addLeft = !addLeft;
                    }
                    String leftString = leftCount == 0 ? "" : string.substring(0, leftCount);
                    String rightString = rightCount == 0 ? "" : string.substring(stringLength - rightCount);
                    string = leftString + clipString + rightString;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("StringUtils.clipString called with bad clipLocation: " + clipLocation);
                }
            }
        }
        return string;
    }

    private static int getAbsoluteAlignment(int alignment) {
        ComponentOrientation co = ComponentOrientation.getOrientation(Locale.getDefault());
        if (co.isLeftToRight()) {
            if (alignment == 10) {
                alignment = 2;
            } else if (alignment == 11) {
                alignment = 4;
            }
        } else if (alignment == 10) {
            alignment = 4;
        } else if (alignment == 11) {
            alignment = 2;
        }
        return alignment;
    }
}

