/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.ui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.graphics.IconRepository;
import oracle.bali.ewt.layout.EqualColumnLayout;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.ui.Reorderable;
import oracle.javatools.ui.plaf.IconicButtonUI;

public class ReorderableBar
extends JPanel {
    private static final Border _BORDER = BorderFactory.createEmptyBorder(2, 5, 0, 5);
    private JButton _up;
    private JButton _down;
    private JButton _top;
    private JButton _bottom;
    private Reorderable _reorderable;
    private Listener _listener;
    private static final String _UP_NAME = "Up";
    private static final String _DOWN_NAME = "Down";
    private static final String _TOP_NAME = "Top";
    private static final String _BOTTOM_NAME = "Bottom";

    public ReorderableBar(Reorderable reorderable, boolean right) {
        this._reorderable = reorderable;
        this._listener = new Listener();
        ResourceBundle bundle = ResourceBundle.getBundle("oracle.bali.ewt.resource.JEWTBundle", LocaleUtils.getDefaultableLocale((Component)this));
        if (right) {
            this._up = this._createButton(IconRepository.SHUTTLE_REORDER_UP_RIGHT_ARROW, bundle, "SHUTTLE.REORDER_UP", _UP_NAME);
            this._down = this._createButton(IconRepository.SHUTTLE_REORDER_DOWN_RIGHT_ARROW, bundle, "SHUTTLE.REORDER_DOWN", _DOWN_NAME);
            this._top = this._createButton(IconRepository.SHUTTLE_REORDER_TOP_RIGHT_ARROW, bundle, "SHUTTLE.REORDER_TOP", _TOP_NAME);
            this._bottom = this._createButton(IconRepository.SHUTTLE_REORDER_BOTTOM_RIGHT_ARROW, bundle, "SHUTTLE.REORDER_BOTTOM", _BOTTOM_NAME);
        } else {
            this._up = this._createButton(IconRepository.SHUTTLE_REORDER_UP_LEFT_ARROW, bundle, "SHUTTLE.REORDER_UP", _UP_NAME);
            this._down = this._createButton(IconRepository.SHUTTLE_REORDER_DOWN_LEFT_ARROW, bundle, "SHUTTLE.REORDER_DOWN", _DOWN_NAME);
            this._top = this._createButton(IconRepository.SHUTTLE_REORDER_TOP_LEFT_ARROW, bundle, "SHUTTLE.REORDER_TOP", _TOP_NAME);
            this._bottom = this._createButton(IconRepository.SHUTTLE_REORDER_BOTTOM_LEFT_ARROW, bundle, "SHUTTLE.REORDER_BOTTOM", _DOWN_NAME);
        }
        this.setLayout((LayoutManager)new EqualColumnLayout(5));
        this.add(this._top);
        this.add(this._up);
        this.add(this._down);
        this.add(this._bottom);
        this._reorderable.addSelectionListener(this._listener);
        this.updateButtons();
    }

    public Reorderable getReorderable() {
        return this._reorderable;
    }

    public void setReorderable(Reorderable reorderable) {
        if (reorderable != this._reorderable) {
            if (this._reorderable != null) {
                this._reorderable.removeSelectionListener(this._listener);
            }
            this._reorderable = reorderable;
            if (this._reorderable != null) {
                this._reorderable.addSelectionListener(this._listener);
            }
        }
    }

    public void updateButtons() {
        if (this._reorderable != null) {
            this._up.setEnabled(this.isEnabled() && this._reorderable.isSelectionUpwardlyMobile());
            this._down.setEnabled(this.isEnabled() && this._reorderable.isSelectionDownwardlyMobile());
            this._top.setEnabled(this.isEnabled() && this._reorderable.isSelectionTopMobile());
            this._bottom.setEnabled(this.isEnabled() && this._reorderable.isSelectionBottomMobile());
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (!enable) {
            this._up.setEnabled(enable);
            this._down.setEnabled(enable);
            this._top.setEnabled(enable);
            this._bottom.setEnabled(enable);
        } else {
            this.updateButtons();
        }
    }

    public void setUpEnabled(boolean enable) {
        this._up.setEnabled(enable);
    }

    public void setDownEnabled(boolean enable) {
        this._down.setEnabled(enable);
    }

    public void setTopEnabled(boolean enable) {
        this._top.setEnabled(enable);
    }

    public void setBottomEnabled(boolean enable) {
        this._bottom.setEnabled(enable);
    }

    public ListSelectionListener getSelectionListener() {
        return this._listener;
    }

    private JButton _createButton(Object iconKey, ResourceBundle bundle, String toolTip, String name) {
        JButton button = new JButton(IconRepository.getIcon((Object)iconKey));
        button.setToolTipText(StringUtils.stripMnemonic((String)bundle.getString(toolTip)));
        button.setOpaque(false);
        button.addActionListener(this._listener);
        IconicButtonUI.install(button);
        button.setBorder(_BORDER);
        button.setRolloverEnabled(false);
        button.setName(name);
        return button;
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            JButton source = (JButton)ae.getSource();
            if (ReorderableBar.this._reorderable == null) {
                return;
            }
            if (source == ReorderableBar.this._up) {
                ReorderableBar.this._reorderable.moveSelectionUp();
            } else if (source == ReorderableBar.this._down) {
                ReorderableBar.this._reorderable.moveSelectionDown();
            } else if (source == ReorderableBar.this._bottom) {
                ReorderableBar.this._reorderable.moveSelectionBottom();
            } else if (source == ReorderableBar.this._top) {
                ReorderableBar.this._reorderable.moveSelectionTop();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ReorderableBar.this.updateButtons();
        }
    }
}

